/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.exception.ElasticSearchClientGenericException;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataColumnImpl;

public class ElasticSearchUtils {
    protected ElasticSearchValueTypeMapper valueTypeMapper;

    public ElasticSearchUtils(ElasticSearchValueTypeMapper valueTypeMapper) {
        this.valueTypeMapper = valueTypeMapper;
    }

    public Date[] calculateDateLimits(ElasticSearchClient client, DataSetMetadata metadata, String dateColumnId, Query query) throws ElasticSearchClientGenericException {
        SearchHitResponse hit0;
        LinkedHashMap<String, Object> fields;
        SearchHitResponse[] hits;
        SearchResponse searchResult;
        ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)metadata.getDefinition();
        String minDateColumnId = dateColumnId + "_min";
        String maxDateColumnId = dateColumnId + "_max";
        DataColumnImpl minDateColumn = new DataColumnImpl(minDateColumnId, ColumnType.NUMBER);
        DataColumnImpl maxDateColumn = new DataColumnImpl(maxDateColumnId, ColumnType.NUMBER);
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>(2);
        columns.add((DataColumn)minDateColumn);
        columns.add((DataColumn)maxDateColumn);
        DataSetGroup aggregation = new DataSetGroup();
        GroupFunction minFunction = new GroupFunction(dateColumnId, minDateColumnId, AggregateFunctionType.MIN);
        GroupFunction maxFunction = new GroupFunction(dateColumnId, maxDateColumnId, AggregateFunctionType.MAX);
        aggregation.addGroupFunction(new GroupFunction[]{minFunction, maxFunction});
        SearchRequest request = new SearchRequest(metadata);
        request.setColumns(columns);
        request.setAggregations(Arrays.asList(aggregation));
        if (query != null) {
            request.setQuery(query);
        }
        if ((searchResult = client.search((DataSetDef)def, metadata, request)) != null && (hits = searchResult.getHits()) != null && hits.length == 1 && (fields = (hit0 = hits[0]).getFields()) != null && !fields.isEmpty()) {
            Double min = (Double)fields.get(minDateColumnId);
            Double max = (Double)fields.get(maxDateColumnId);
            Date minValue = this.valueTypeMapper.parseDate(def, dateColumnId, min.longValue());
            Date maxValue = this.valueTypeMapper.parseDate(def, dateColumnId, max.longValue());
            return new Date[]{minValue, maxValue};
        }
        return null;
    }

    public String transformPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        if (pattern.trim().length() > 0) {
            pattern = pattern.replace("%", "*");
            pattern = pattern.replace("_", "?");
        }
        return pattern;
    }
}

