/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.StaticDataSetProvider;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchQueryBuilderFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.CountResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.EmptySearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.IndexMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.MappingsResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.MultiFieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.TypeMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.DataSetDefRegistryListener;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.engine.group.IntervalBuilder;
import org.dashbuilder.dataset.engine.group.IntervalBuilderLocator;
import org.dashbuilder.dataset.engine.group.IntervalList;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.impl.MemSizeEstimator;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchDataSetProvider
implements DataSetProvider,
DataSetDefRegistryListener {
    public static final int RESPONSE_CODE_OK = 200;
    private static final String COMMA = ",";
    private static ElasticSearchDataSetProvider SINGLETON = null;
    protected Logger log = LoggerFactory.getLogger(ElasticSearchDataSetProvider.class);
    protected StaticDataSetProvider staticDataSetProvider;
    protected DataSetDefRegistry dataSetDefRegistry;
    protected IntervalBuilderLocator intervalBuilderLocator;
    protected ElasticSearchClientFactory clientFactory;
    protected ElasticSearchValueTypeMapper typeMapper;
    protected ElasticSearchQueryBuilderFactory queryBuilderFactory;
    protected final Map<String, DataSetMetadata> _metadataMap = new HashMap<String, DataSetMetadata>();
    protected final Map<String, ElasticSearchClient> _clientsMap = new HashMap<String, ElasticSearchClient>();

    public static ElasticSearchDataSetProvider get() {
        if (SINGLETON == null) {
            StaticDataSetProvider staticDataSetProvider = DataSetCore.get().getStaticDataSetProvider();
            DataSetDefRegistry dataSetDefRegistry = DataSetCore.get().getDataSetDefRegistry();
            IntervalBuilderLocator intervalBuilderLocator = DataSetCore.get().getIntervalBuilderLocator();
            SINGLETON = new ElasticSearchDataSetProvider(staticDataSetProvider, dataSetDefRegistry, intervalBuilderLocator);
        }
        return SINGLETON;
    }

    public ElasticSearchDataSetProvider() {
    }

    public ElasticSearchDataSetProvider(StaticDataSetProvider staticDataSetProvider, DataSetDefRegistry dataSetDefRegistry, IntervalBuilderLocator intervalBuilderLocator) {
        this.staticDataSetProvider = staticDataSetProvider;
        this.dataSetDefRegistry = dataSetDefRegistry;
        this.intervalBuilderLocator = intervalBuilderLocator;
        this.typeMapper = new ElasticSearchValueTypeMapper();
        ElasticSearchUtils searchUtils = new ElasticSearchUtils(this.typeMapper);
        this.clientFactory = new ElasticSearchClientFactory(this.typeMapper, searchUtils);
        this.queryBuilderFactory = new ElasticSearchQueryBuilderFactory(this.typeMapper, searchUtils);
    }

    public void destroy() {
        for (ElasticSearchClient client : this._clientsMap.values()) {
            this.destroyClient(client);
        }
    }

    public DataSetProviderType getType() {
        return DataSetProviderType.ELASTICSEARCH;
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        ElasticSearchDataSetDef elDef = (ElasticSearchDataSetDef)def;
        if (elDef.isCacheEnabled()) {
            DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def.getUUID(), null);
            if (dataSet != null) {
                return this.staticDataSetProvider.lookupDataSet(def.getUUID(), lookup);
            }
            long rows = this.getRowCount(elDef);
            if (rows > (long)elDef.getCacheMaxRows().intValue()) {
                return this._lookupDataSet(elDef, lookup);
            }
            dataSet = this._lookupDataSet(elDef, null);
            dataSet.setUUID(def.getUUID());
            dataSet.setDefinition(def);
            this.staticDataSetProvider.registerDataSet(dataSet);
            return this.staticDataSetProvider.lookupDataSet(def.getUUID(), lookup);
        }
        return this._lookupDataSet(elDef, lookup);
    }

    protected DataSet _lookupDataSet(ElasticSearchDataSetDef elDef, DataSetLookup lookup) throws Exception {
        List intervalSelects;
        Object columnId;
        boolean trim;
        boolean isTestMode = lookup != null && lookup.testMode();
        DataSetMetadata metadata = this.getDataSetMetadata((DataSetDef)elDef, isTestMode);
        DataSetFilter dataSetFilter = elDef.getDataSetFilter();
        if (dataSetFilter != null) {
            lookup.addOperation(new DataSetOp[]{dataSetFilter});
        }
        SearchRequest request = new SearchRequest(metadata);
        int numRows = lookup.getNumberOfRows();
        boolean bl = trim = numRows > 0;
        if (trim) {
            int rowOffset = lookup.getRowOffset();
            request.setStart(rowOffset);
            request.setSize(numRows);
        }
        DataSetGroup _groupOp = null;
        boolean allColumns = true;
        int groupIdx = lookup.getFirstGroupOpIndex(0, null, Boolean.valueOf(false));
        if (groupIdx == -1) {
            groupIdx = lookup.getFirstGroupOpIndex(0, null, Boolean.valueOf(true));
        }
        if (groupIdx != -1) {
            _groupOp = (DataSetGroup)lookup.getOperation(groupIdx);
        }
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        if (_groupOp != null && !_groupOp.isSelect()) {
            List groupFunctions = _groupOp.getGroupFunctions();
            boolean exitsFunction = false;
            if (groupFunctions != null && !groupFunctions.isEmpty()) {
                for (GroupFunction groupFunction : groupFunctions) {
                    DataColumn column;
                    if (groupFunction.getFunction() != null) {
                        exitsFunction = true;
                    }
                    if ((column = this.getColumnById(metadata, (String)(columnId = groupFunction.getSourceId() != null ? groupFunction.getSourceId() : metadata.getColumnId(0)))) != null) {
                        DataColumn c = column.cloneEmpty();
                        String cId = groupFunction.getColumnId() != null ? groupFunction.getColumnId() : groupFunction.getSourceId();
                        c.setId(cId);
                        c.setGroupFunction(groupFunction);
                        if (groupFunction.getFunction() != null) {
                            c.setColumnType(ColumnType.NUMBER);
                        }
                        columns.add(c);
                        continue;
                    }
                    throw new IllegalArgumentException("Grouping function by a non existing column [" + (String)columnId + "] in dataset ");
                }
            }
            if (exitsFunction) {
                request.setAggregations(Collections.singletonList(_groupOp));
            }
        }
        request.setColumns(!columns.isEmpty() ? columns : this.getAllColumns(metadata));
        ArrayList<DataSetFilter> filters = lookup.getOperationList(DataSetFilter.class);
        if (filters != null && !filters.isEmpty()) {
            for (DataSetFilter filerOp : filters) {
                List columnFilters = filerOp.getColumnFilterList();
                if (columnFilters == null || columnFilters.isEmpty()) continue;
                columnId = columnFilters.iterator();
                while (columnId.hasNext()) {
                    ColumnFilter filter = (ColumnFilter)columnId.next();
                    String fcId = filter.getColumnId();
                    if (fcId == null || this.existColumn(metadata, fcId)) continue;
                    throw new IllegalArgumentException("Filtering by a non existing column [" + fcId + "] in dataset ");
                }
            }
        }
        if ((intervalSelects = lookup.getFirstGroupOpSelections()) != null && !intervalSelects.isEmpty()) {
            if (filters == null) {
                filters = new ArrayList<DataSetFilter>(intervalSelects.size());
            }
            DataSetFilter filterOp = new DataSetFilter();
            filterOp.setDataSetUUID(metadata.getUUID());
            for (DataSetGroup intervalSelect : intervalSelects) {
                ColumnFilter drillDownFilter = this._getIntervalSelectionFilter(intervalSelect);
                filterOp.addFilterColumn(new ColumnFilter[]{drillDownFilter});
            }
            filters.add(filterOp);
        }
        Query query = this.queryBuilderFactory.newQueryBuilder().metadata(metadata).groupInterval(_groupOp != null ? Arrays.asList(_groupOp) : null).filter(filters).build();
        request.setQuery(query);
        ArrayList<DataSetSort> sortOps = lookup.getOperationList(DataSetSort.class);
        if ((sortOps == null || sortOps.isEmpty()) && elDef.getColumnSort() != null) {
            if (sortOps == null) {
                sortOps = new ArrayList<DataSetSort>();
            }
            DataSetSort defaultSort = new DataSetSort();
            defaultSort.addSortColumn(new ColumnSort[]{elDef.getColumnSort()});
            sortOps.add(defaultSort);
        } else if (sortOps != null) {
            for (DataSetSort sortOp : sortOps) {
                List sorts = sortOp.getColumnSortList();
                if (sorts == null || sorts.isEmpty()) continue;
                for (ColumnSort sort : sorts) {
                    if (this.existColumn(metadata, sort.getColumnId())) continue;
                    throw new IllegalArgumentException("Sorting by a non existing column [" + sort.getColumnId() + "] in dataset ");
                }
            }
        }
        request.setSorting((List<DataSetSort>)sortOps);
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        dataSet.setColumns(request.getColumns());
        ElasticSearchClient client = this.getClient(elDef);
        SearchResponse searchResponse = client.search((DataSetDef)elDef, metadata, request);
        if (searchResponse instanceof EmptySearchResponse) {
            return dataSet;
        }
        this.fillDataSetValues(elDef, dataSet, searchResponse.getHits());
        this.postProcess(metadata, dataSet);
        if (trim) {
            dataSet.setRowCountNonTrimmed((int)searchResponse.getTotalHits());
        }
        return dataSet;
    }

    protected ColumnFilter _getIntervalSelectionFilter(DataSetGroup intervalSel) {
        ColumnFilter filter = null;
        if (intervalSel != null && intervalSel.isSelect()) {
            ColumnGroup cg = intervalSel.getColumnGroup();
            List intervalList = intervalSel.getSelectedIntervalList();
            ArrayList<String> names = new ArrayList<String>();
            Comparable min = null;
            Comparable max = null;
            for (Interval interval : intervalList) {
                names.add(interval.getName());
                Comparable intervalMin = (Comparable)interval.getMinValue();
                Comparable intervalMax = (Comparable)interval.getMaxValue();
                if (intervalMin != null) {
                    if (min == null) {
                        min = intervalMin;
                    } else if (min.compareTo(intervalMin) > 0) {
                        min = intervalMin;
                    }
                }
                if (intervalMax == null) continue;
                if (max == null) {
                    max = intervalMax;
                    continue;
                }
                if (max.compareTo(intervalMax) <= 0) continue;
                max = intervalMax;
            }
            if (min != null && max != null && min.compareTo(max) > 0) {
                min = max;
            }
            filter = min != null && max != null ? FilterFactory.between((String)cg.getSourceId(), (Comparable)min, max) : (min != null ? FilterFactory.greaterOrEqualsTo((String)cg.getSourceId(), (Comparable)min) : (max != null ? FilterFactory.lowerOrEqualsTo((String)cg.getSourceId(), max) : FilterFactory.equalsTo((String)cg.getSourceId(), names)));
        }
        return filter;
    }

    private void postProcess(DataSetMetadata metadata, DataSet dataSet) {
        for (DataColumn column : dataSet.getColumns()) {
            ColumnType type;
            ColumnGroup cg;
            ColumnType columnType = column.getColumnType();
            if (!ColumnType.LABEL.equals((Object)columnType) || (cg = column.getColumnGroup()) == null || !cg.areEmptyIntervalsAllowed() || (type = metadata.getColumnType(cg.getSourceId())) == null || !ColumnType.DATE.equals((Object)type)) continue;
            DateIntervalType intervalType = DateIntervalType.getByName((String)cg.getIntervalSize());
            Month firstMonth = cg.getFirstMonthOfYear();
            DayOfWeek firstDayOfWeek = cg.getFirstDayOfWeek();
            int startIndex = 0;
            int intervalSize = -1;
            if (intervalType != null) {
                if (firstMonth != null && intervalType.equals((Object)DateIntervalType.MONTH)) {
                    startIndex = firstMonth.getIndex() - 1;
                    intervalSize = Month.values().length;
                }
                if (firstDayOfWeek != null && intervalType.equals((Object)DateIntervalType.DAY_OF_WEEK)) {
                    startIndex = firstDayOfWeek.getIndex() - 1;
                    intervalSize = DayOfWeek.values().length;
                }
            }
            this.fillEmptyRows(dataSet, column, startIndex, intervalSize);
        }
    }

    private void fillEmptyRows(DataSet dataSet, DataColumn dateGroupColumn, int startIndex, int intervalSize) {
        IntervalBuilder intervalBuilder = this.intervalBuilderLocator.lookup(ColumnType.DATE, dateGroupColumn.getColumnGroup().getStrategy());
        IntervalList intervalList = intervalBuilder.build(dateGroupColumn);
        if (intervalList.size() > dataSet.getRowCount()) {
            List values = dateGroupColumn.getValues();
            int counter = 0;
            int intervalIdx = startIndex;
            while (counter < intervalList.size()) {
                String value;
                if (intervalSize != -1 && intervalIdx >= intervalSize) {
                    intervalIdx = 0;
                }
                String interval = ((Interval)intervalList.get(intervalIdx)).getName();
                String string = value = values.isEmpty() || values.size() < intervalIdx + 1 ? null : (String)values.get(intervalIdx);
                if (value == null || !value.equals(interval)) {
                    dataSet.addEmptyRowAt(intervalIdx);
                    dateGroupColumn.getValues().set(intervalIdx, interval);
                }
                ++counter;
                ++intervalIdx;
            }
        }
    }

    protected List<DataColumn> getAllColumns(DataSetMetadata metadata) {
        int numberOfColumns = metadata.getNumberOfColumns();
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>(numberOfColumns);
        for (int x = 0; x < numberOfColumns; ++x) {
            DataColumn column = this.getColumnById(metadata, metadata.getColumnId(x));
            columns.add(column);
        }
        return columns;
    }

    protected DataColumn getColumnById(DataSetMetadata metadata, String columnId) {
        if (metadata == null || columnId == null || columnId.trim().length() == 0) {
            return null;
        }
        int numCols = metadata.getNumberOfColumns();
        for (int x = 0; x < numCols; ++x) {
            String metaColumnId = metadata.getColumnId(x);
            if (!columnId.equals(metaColumnId)) continue;
            DataColumnImpl column = new DataColumnImpl(metadata.getColumnId(x), metadata.getColumnType(x));
            return column;
        }
        return null;
    }

    protected boolean existColumn(DataSetMetadata metadata, String columnId) {
        return this.getColumnById(metadata, columnId) != null;
    }

    protected void fillDataSetValues(ElasticSearchDataSetDef elDef, DataSet dataSet, SearchHitResponse[] hits) throws Exception {
        List dataSetColumns = dataSet.getColumns();
        int position = 0;
        for (SearchHitResponse hit : hits) {
            int columnNumber = 0;
            for (DataColumn column : dataSetColumns) {
                String columnId = column.getId();
                Object value = hit.getFieldValue(columnId);
                dataSet.setValueAt(position, columnNumber, value);
                ++columnNumber;
            }
            ++position;
        }
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        try {
            ElasticSearchDataSetDef elDef = (ElasticSearchDataSetDef)def;
            if (!elDef.isCacheEnabled()) {
                return false;
            }
            DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def, null);
            if (dataSet == null) {
                return false;
            }
            long rows = this.getRowCount(elDef);
            return rows != (long)dataSet.getRowCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        return this.getDataSetMetadata(def, true);
    }

    private DataSetMetadata getDataSetMetadata(DataSetDef def, boolean isTestMode) throws Exception {
        String columnId;
        ElasticSearchDataSetDef elasticSearchDataSetDef = (ElasticSearchDataSetDef)def;
        if (!isTestMode) {
            DataSetMetadata result = this._metadataMap.get(elasticSearchDataSetDef.getUUID());
            if (result != null) {
                return result;
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Using look-up in test mode. Skipping read data set metadata for uuid [" + def.getUUID() + "] from cache.");
        }
        String[] index = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getIndex());
        String[] type = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getType());
        long rowCount = this.getRowCount(elasticSearchDataSetDef);
        ElasticSearchClient client = this.getClient(elasticSearchDataSetDef);
        MappingsResponse mappingsResponse = client.getMappings(index);
        if (mappingsResponse == null || mappingsResponse.getStatus() != 200) {
            throw new IllegalArgumentException("Cannot retrieve index mappings for index: [" + index[0] + "]. See previous errors.");
        }
        LinkedList<String> columnIds = new LinkedList<String>();
        LinkedList<ColumnType> columnTypes = new LinkedList<ColumnType>();
        Map<String, DataColumn> indexMappingsColumnsMap = this.parseColumnsFromIndexMappings(mappingsResponse.getIndexMappings(), elasticSearchDataSetDef);
        if (indexMappingsColumnsMap == null || indexMappingsColumnsMap.isEmpty()) {
            throw new RuntimeException("There are no column for index [" + index[0] + "] and type [" + ArrayUtils.toString((Object)type) + "].");
        }
        Collection<DataColumn> indexMappingsColumns = indexMappingsColumnsMap.values();
        List dataSetColumns = elasticSearchDataSetDef.getColumns();
        if (dataSetColumns != null && !dataSetColumns.isEmpty()) {
            for (DataColumnDef column : dataSetColumns) {
                columnId = column.getId();
                DataColumn indexCol = indexMappingsColumnsMap.get(columnId);
                if (indexCol == null) {
                    this.log.warn("The column [" + columnId + "] for the data set definition with UUID [" + def.getUUID() + "] is no longer present in the mappings.");
                    continue;
                }
                ColumnType columnType = column.getColumnType();
                ColumnType indexColumnType = indexCol.getColumnType();
                if (indexColumnType.equals((Object)ColumnType.TEXT) && columnType.equals((Object)ColumnType.LABEL)) {
                    throw new RuntimeException("The column [" + columnId + "] is defined in dataset definition as LABEL, but the column in the index [" + index[0] + "] and type [" + ArrayUtils.toString((Object)type) + "] is using ANALYZED index, you cannot use it as a label.");
                }
                columnIds.add(columnId);
                columnTypes.add(columnType);
            }
        }
        if (def.isAllColumnsEnabled()) {
            for (DataColumn indexMappingsColumn : indexMappingsColumns) {
                columnId = indexMappingsColumn.getId();
                int columnIdx = columnIds.indexOf(columnId);
                boolean columnExists = columnIdx != -1;
                if (columnExists) continue;
                columnIds.add(columnId);
                columnTypes.add(indexMappingsColumn.getColumnType());
            }
        }
        if (columnIds.isEmpty()) {
            throw new RuntimeException("Cannot obtain data set metadata columns for data set with UUID [" + def.getUUID() + "]. All columns flag is not set and there are no column definitions in the data set definition.");
        }
        int _rowCount = (int)rowCount;
        int estimatedSize = this.estimateSize(columnTypes, _rowCount);
        DataSetMetadataImpl result = new DataSetMetadataImpl(def, def.getUUID(), _rowCount, columnIds.size(), columnIds, columnTypes, estimatedSize);
        if (!isTestMode) {
            boolean isDefRegistered;
            boolean bl = isDefRegistered = def.getUUID() != null && this.dataSetDefRegistry.getDataSetDef(def.getUUID()) != null;
            if (isDefRegistered) {
                this._metadataMap.put(def.getUUID(), (DataSetMetadata)result);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Using look-up in test mode. Skipping adding data set metadata for uuid [" + def.getUUID() + "] into cache.");
        }
        return result;
    }

    private int estimateSize(List<ColumnType> columnTypes, int rowCount) {
        int estimatedSize = 0;
        if (columnTypes != null && !columnTypes.isEmpty()) {
            for (ColumnType type : columnTypes) {
                if (ColumnType.DATE.equals((Object)type)) {
                    estimatedSize += MemSizeEstimator.sizeOf(Date.class) * rowCount;
                    continue;
                }
                if (ColumnType.NUMBER.equals((Object)type)) {
                    estimatedSize += MemSizeEstimator.sizeOf(Double.class) * rowCount;
                    continue;
                }
                estimatedSize += 30 * rowCount;
            }
        }
        return estimatedSize;
    }

    protected Map<String, DataColumn> parseColumnsFromIndexMappings(IndexMappingResponse[] indexMappings, ElasticSearchDataSetDef def) {
        HashMap<String, DataColumn> result = null;
        for (IndexMappingResponse indexMapping : indexMappings) {
            result = new HashMap<String, DataColumn>();
            String indexName = indexMapping.getIndexName();
            TypeMappingResponse[] typeMappings = indexMapping.getTypeMappings();
            if (typeMappings == null || typeMappings.length == 0) {
                throw new IllegalArgumentException("There are no types for index: [" + indexName + "[");
            }
            for (TypeMappingResponse typeMapping : typeMappings) {
                String typeName = typeMapping.getTypeName();
                FieldMappingResponse[] properties = typeMapping.getFields();
                if (properties == null || properties.length == 0) {
                    throw new IllegalArgumentException("There are no fields for index: [" + indexName + "] and type [" + typeName + "[");
                }
                for (FieldMappingResponse fieldMapping : properties) {
                    MultiFieldMappingResponse[] multiFieldMappingResponse;
                    String format;
                    String fieldName = fieldMapping.getName();
                    DataColumn _column = this.parseColumnFromIndexMappings(def, indexName, typeName, fieldName, format = fieldMapping.getFormat(), fieldMapping.getDataType(), fieldMapping.getIndexType());
                    if (_column != null) {
                        result.put(_column.getId(), _column);
                    }
                    if ((multiFieldMappingResponse = fieldMapping.getMultiFields()) == null || multiFieldMappingResponse.length <= 0) continue;
                    for (MultiFieldMappingResponse multiField : multiFieldMappingResponse) {
                        DataColumn _multiFieldColumn = this.parseColumnFromIndexMappings(def, indexName, typeName, fieldName + "." + multiField.getName(), null, multiField.getDataType(), multiField.getIndexType());
                        if (_multiFieldColumn == null) continue;
                        result.put(_multiFieldColumn.getId(), _multiFieldColumn);
                    }
                }
            }
        }
        return result;
    }

    protected DataColumn parseColumnFromIndexMappings(ElasticSearchDataSetDef def, String indexName, String typeName, String fieldName, String format, FieldMappingResponse.FieldType fieldType, FieldMappingResponse.IndexType indexType) {
        String columnId = this.getColumnId(indexName, typeName, fieldName);
        ColumnType columnType = this.getDataType(fieldType, indexType);
        DataColumnImpl column = null;
        if (columnType != null) {
            boolean isLabelColumn = ColumnType.LABEL.equals((Object)columnType);
            boolean isTextColumn = ColumnType.TEXT.equals((Object)columnType);
            boolean isNumberColumn = ColumnType.NUMBER.equals((Object)columnType);
            String pattern = def.getPattern(columnId);
            if (!this.isEmpty(pattern)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using pattern [" + pattern + "] given in the data set definition with uuid [" + def.getUUID() + "] for column [" + columnId + "].");
                }
            } else if (isLabelColumn || isTextColumn) {
                if (indexType == null) {
                    indexType = FieldMappingResponse.IndexType.ANALYZED;
                }
                def.setPattern(columnId, indexType.name().toLowerCase());
            } else if (isNumberColumn) {
                def.setPattern(columnId, fieldType.name().toLowerCase());
            } else if (!this.isEmpty(format)) {
                def.setPattern(columnId, format);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using pattern [" + format + "] given by the index mappings response for column [" + columnId + "].");
                }
            } else {
                String defaultPattern = this.typeMapper.defaultDateFormat();
                def.setPattern(columnId, defaultPattern);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Using default pattern [" + defaultPattern + "] for column [" + columnId + "].");
                }
            }
            column = new DataColumnImpl(columnId, columnType);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("[" + indexName + "]/[" + typeName + "] - Skipping column retrieved from index mappings response with id [" + columnId + "], as data type for this column is not supported.");
        }
        return column;
    }

    protected String getColumnId(String index, String type, String field) throws IllegalArgumentException {
        if (index == null || index.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot create the column identifier. Index name is not set.");
        }
        if (type == null || type.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot create the column identifier. Document type name is not set.");
        }
        if (field == null || field.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot create the column identifier. Field name is not set.");
        }
        return field;
    }

    protected ColumnType getDataType(FieldMappingResponse.FieldType fieldType, FieldMappingResponse.IndexType indexType) throws IllegalArgumentException {
        if (fieldType == null) {
            return null;
        }
        switch (fieldType) {
            case STRING: {
                if (indexType != null && indexType.equals((Object)FieldMappingResponse.IndexType.NOT_ANALYZED)) {
                    return ColumnType.LABEL;
                }
                return ColumnType.TEXT;
            }
            case FLOAT: {
                return ColumnType.NUMBER;
            }
            case DOUBLE: {
                return ColumnType.NUMBER;
            }
            case BYTE: {
                return ColumnType.NUMBER;
            }
            case SHORT: {
                return ColumnType.NUMBER;
            }
            case INTEGER: {
                return ColumnType.NUMBER;
            }
            case LONG: {
                return ColumnType.NUMBER;
            }
            case TOKEN_COUNT: {
                return ColumnType.LABEL;
            }
            case DATE: {
                return ColumnType.DATE;
            }
            case BOOLEAN: {
                return ColumnType.LABEL;
            }
            case BINARY: {
                return ColumnType.LABEL;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("The ElasticSearch core data type [" + fieldType.toString() + "] is not suppored.");
        }
        return null;
    }

    protected long getRowCount(ElasticSearchDataSetDef elasticSearchDataSetDef) throws Exception {
        String[] index = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getIndex());
        String[] type = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getType());
        ElasticSearchClient client = this.getClient(elasticSearchDataSetDef);
        CountResponse response = client.count(index, type);
        if (response != null) {
            return response.getCount();
        }
        return 0L;
    }

    private ElasticSearchClient getClient(ElasticSearchDataSetDef def) {
        ElasticSearchClient client = this._clientsMap.get(def.getUUID());
        if (client == null) {
            client = this.clientFactory.newClient(def);
            this._clientsMap.put(def.getUUID(), client);
        }
        return client;
    }

    private ElasticSearchClient destroyClient(String uuid) {
        ElasticSearchClient client = this._clientsMap.get(uuid);
        if (client != null) {
            this._clientsMap.remove(uuid);
            this.destroyClient(client);
        }
        return client;
    }

    private ElasticSearchClient destroyClient(ElasticSearchClient client) {
        try {
            client.close();
        }
        catch (IOException e) {
            this.log.error("Error closing elastic search data provider client.", (Throwable)e);
        }
        return client;
    }

    public void onDataSetDefStale(DataSetDef def) {
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    public void onDataSetDefModified(DataSetDef oldDef, DataSetDef newDef) {
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)oldDef.getProvider())) {
            this.remove(oldDef.getUUID());
        }
    }

    public void onDataSetDefRemoved(DataSetDef oldDef) {
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)oldDef.getProvider())) {
            this.remove(oldDef.getUUID());
        }
    }

    public void onDataSetDefRegistered(DataSetDef newDef) {
    }

    protected void remove(String uuid) {
        this._metadataMap.remove(uuid);
        this.destroyClient(uuid);
        this.staticDataSetProvider.removeDataSet(uuid);
    }

    public static String[] fromString(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{""};
        }
        return str.split(COMMA);
    }

    public static String toString(String[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int total = array.length;
        for (int x = 0; x < total; ++x) {
            String s = array[x];
            builder.append(s);
            if (x >= total - 1) continue;
            builder.append(COMMA);
        }
        return builder.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

