/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl;

import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.exception.ElasticSearchClientGenericException;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.NativeClientAggregationsBuilder;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.NativeClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.NativeClientQueryBuilder;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.NativeClientResponseParser;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.CountResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.IndexMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.MappingsResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.MultiFieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.TypeMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.IntervalBuilderDynamicDate;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ElasticSearchNativeClient
implements ElasticSearchClient<ElasticSearchNativeClient> {
    protected static final String EL_CLUTER_NAME = "cluster.name";
    protected static final String EL_CLIENT_TIMEOUT = "client.transport.ping_timeout";
    protected String serverURL;
    protected String clusterName;
    protected String[] index;
    protected String[] type;
    protected long timeout = 30000L;
    private Client client;
    private final ElasticSearchClientFactory clientFactory;
    private final ElasticSearchValueTypeMapper valueTypeMapper;
    private final IntervalBuilderDynamicDate intervalBuilderDynamicDate;
    private final ElasticSearchUtils utils;

    public ElasticSearchNativeClient(ElasticSearchClientFactory clientFactory, ElasticSearchValueTypeMapper valueTypeMapper, IntervalBuilderDynamicDate intervalBuilderDynamicDate, ElasticSearchUtils utils) {
        this.clientFactory = clientFactory;
        this.valueTypeMapper = valueTypeMapper;
        this.intervalBuilderDynamicDate = intervalBuilderDynamicDate;
        this.utils = utils;
    }

    @Override
    public ElasticSearchNativeClient serverURL(String serverURL) {
        this.serverURL = serverURL;
        return this;
    }

    @Override
    public ElasticSearchNativeClient index(String ... indexes) {
        this.index = indexes;
        return this;
    }

    @Override
    public ElasticSearchNativeClient type(String ... types) {
        this.type = types;
        return this;
    }

    @Override
    public ElasticSearchNativeClient clusterName(String clusterName) {
        this.clusterName = clusterName;
        return this;
    }

    @Override
    public ElasticSearchNativeClient setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public MappingsResponse getMappings(String ... index) throws ElasticSearchClientGenericException {
        this.checkClient();
        LinkedList<IndexMappingResponse> indexMappingResponse = null;
        int responseCode = 200;
        try {
            indexMappingResponse = new LinkedList<IndexMappingResponse>();
            GetMappingsResponse _mappingsResponse = this.getMappings();
            responseCode = ElasticSearchUtils.getResponseCode((ActionResponse)_mappingsResponse);
            if (200 == responseCode) {
                ImmutableOpenMap mappingsResponse = _mappingsResponse.getMappings();
                if (mappingsResponse == null || mappingsResponse.isEmpty()) {
                    throw new RuntimeException("There are no index mappings on the server.");
                }
                UnmodifiableIterator mappingsResponseIt = mappingsResponse.keysIt();
                while (mappingsResponseIt.hasNext()) {
                    String mappingsResponseKey = (String)mappingsResponseIt.next();
                    LinkedList<TypeMappingResponse> typeMappingResponse = new LinkedList<TypeMappingResponse>();
                    UnmodifiableIterator typeNames = ((ImmutableOpenMap)mappingsResponse.get((Object)mappingsResponseKey)).keysIt();
                    if (!typeNames.hasNext()) {
                        throw new RuntimeException("There index '" + mappingsResponseKey + "' has not types.");
                    }
                    while (typeNames.hasNext()) {
                        String typeName = (String)typeNames.next();
                        Map mappingsMap = ((MappingMetaData)((ImmutableOpenMap)mappingsResponse.get((Object)mappingsResponseKey)).get((Object)typeName)).getSourceAsMap();
                        FieldMappingResponse[] fieldMappingResponses = this.parseMappings(mappingsMap);
                        if (null == fieldMappingResponses) continue;
                        TypeMappingResponse resultTypeMapping = new TypeMappingResponse(typeName, fieldMappingResponses);
                        typeMappingResponse.add(resultTypeMapping);
                    }
                    indexMappingResponse.add(new IndexMappingResponse(mappingsResponseKey, typeMappingResponse.toArray(new TypeMappingResponse[typeMappingResponse.size()])));
                }
            }
        }
        catch (Exception e) {
            throw new ElasticSearchClientGenericException(e);
        }
        return new MappingsResponse(responseCode, indexMappingResponse.toArray(new IndexMappingResponse[indexMappingResponse.size()]));
    }

    @Override
    public CountResponse count(String[] index, String ... type) throws ElasticSearchClientGenericException {
        this.checkClient();
        SearchRequestBuilder searchRequestBuilder = new SearchRequestBuilder((ElasticsearchClient)this.client, SearchAction.INSTANCE).setSize(0);
        if (null != index) {
            searchRequestBuilder.setIndices(index);
        }
        if (null != type) {
            searchRequestBuilder.setTypes(type);
        }
        ActionFuture response = this.client.search(searchRequestBuilder.request());
        SearchResponse searchResponse = (SearchResponse)response.actionGet();
        long total = searchResponse.getHits().totalHits();
        return new CountResponse(total, searchResponse.getTotalShards());
    }

    @Override
    public org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse search(ElasticSearchDataSetDef definition, DataSetMetadata metadata, SearchRequest request) throws ElasticSearchClientGenericException {
        QueryBuilder queryBuilder;
        boolean existQuery;
        boolean existAggregations;
        this.checkClient();
        int start = request.getStart();
        int size = request.getSize();
        List<DataSetGroup> aggregations = request.getAggregations();
        List<DataSetSort> sorting = request.getSorting();
        List<DataColumn> columns = Collections.unmodifiableList(request.getColumns());
        SearchRequestBuilder searchRequestBuilder = new SearchRequestBuilder((ElasticsearchClient)this.client, SearchAction.INSTANCE).setFetchSource(true);
        if (null != this.index) {
            searchRequestBuilder.setIndices(this.index);
            if (null != this.type) {
                searchRequestBuilder.setTypes(this.type);
            }
        }
        List<AbstractAggregationBuilder> aggregationsBuilders = null;
        if (null != aggregations && !aggregations.isEmpty()) {
            aggregationsBuilders = new NativeClientAggregationsBuilder(this.clientFactory, this.intervalBuilderDynamicDate, this.utils, metadata, columns, request).build(aggregations.get(0));
        }
        boolean bl = existAggregations = aggregationsBuilders != null && !aggregations.isEmpty();
        if (existAggregations) {
            for (AbstractAggregationBuilder b : aggregationsBuilders) {
                searchRequestBuilder.addAggregation(b);
            }
        }
        boolean bl2 = existQuery = (queryBuilder = new NativeClientQueryBuilder().build(request.getQuery())) != null;
        if (existQuery) {
            searchRequestBuilder.setQuery(queryBuilder);
        }
        int sizeToPull = existAggregations ? 0 : size;
        int startToPull = existAggregations ? 0 : start;
        searchRequestBuilder.setFrom(startToPull);
        if (sizeToPull > -1) {
            searchRequestBuilder.setSize(sizeToPull);
        }
        if (!existQuery && !existAggregations) {
            searchRequestBuilder.setQuery((QueryBuilder)new MatchAllQueryBuilder());
        }
        if (!existAggregations && !columns.isEmpty()) {
            String[] fields = this.getColumnIds(columns);
            for (String field : fields) {
                searchRequestBuilder.addField(field);
            }
        }
        if (sorting != null && !sorting.isEmpty()) {
            for (DataSetSort sortOp : sorting) {
                List columnSorts = sortOp.getColumnSortList();
                if (columnSorts == null || columnSorts.isEmpty()) continue;
                for (ColumnSort columnSort : columnSorts) {
                    searchRequestBuilder.addSort(columnSort.getColumnId(), columnSort.getOrder().asInt() == 1 ? SortOrder.ASC : SortOrder.DESC);
                }
            }
        }
        SearchResponse response = (SearchResponse)this.client.search(searchRequestBuilder.request()).actionGet();
        try {
            return new NativeClientResponseParser(this.valueTypeMapper).parse(metadata, response, columns);
        }
        catch (ParseException e) {
            throw new ElasticSearchClientGenericException("Error parsing response from server.", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private FieldMappingResponse[] parseMappings(Map<String, Object> mappingsMap) {
        Map propertiesMap;
        if (null != mappingsMap && !mappingsMap.isEmpty() && null != (propertiesMap = (Map)mappingsMap.get("properties")) && !propertiesMap.isEmpty()) {
            LinkedList<FieldMappingResponse> fieldMappingResponses = new LinkedList<FieldMappingResponse>();
            for (Map.Entry entry : propertiesMap.entrySet()) {
                FieldMappingResponse fieldMapping = this.parsePropertyMappings((String)entry.getKey(), (Map)entry.getValue());
                if (null == fieldMapping) continue;
                fieldMappingResponses.add(fieldMapping);
            }
            return fieldMappingResponses.toArray(new FieldMappingResponse[fieldMappingResponses.size()]);
        }
        return null;
    }

    private FieldMappingResponse parsePropertyMappings(String pId, Map<String, Object> propertyMapping) {
        if (null != propertyMapping && !propertyMapping.isEmpty()) {
            String format = null;
            LinkedList<MultiFieldMappingResponse> multiFieldMappings = new LinkedList<MultiFieldMappingResponse>();
            Object[] parseIndexMappingsFieldAndType = this.parseIndexMappingsFieldAndType(propertyMapping);
            if (null != parseIndexMappingsFieldAndType && parseIndexMappingsFieldAndType.length == 2) {
                Map mFields;
                Object mf;
                FieldMappingResponse.FieldType fieldType = (FieldMappingResponse.FieldType)((Object)parseIndexMappingsFieldAndType[0]);
                FieldMappingResponse.IndexType indexType = (FieldMappingResponse.IndexType)((Object)parseIndexMappingsFieldAndType[1]);
                Object f = propertyMapping.get("format");
                if (null != f) {
                    format = f.toString();
                }
                if (null != (mf = propertyMapping.get("fields")) && !(mFields = (Map)mf).isEmpty()) {
                    for (Map.Entry entry1 : mFields.entrySet()) {
                        String mFieldId = (String)entry1.getKey();
                        Map mFieldMappings = (Map)entry1.getValue();
                        Object[] mFieldMapTypeIndex = this.parseIndexMappingsFieldAndType(mFieldMappings);
                        if (null == mFieldMapTypeIndex || mFieldMapTypeIndex.length != 2) continue;
                        FieldMappingResponse.FieldType fieldType1 = (FieldMappingResponse.FieldType)((Object)mFieldMapTypeIndex[0]);
                        FieldMappingResponse.IndexType indexType1 = (FieldMappingResponse.IndexType)((Object)mFieldMapTypeIndex[1]);
                        MultiFieldMappingResponse multiFieldMapping = new MultiFieldMappingResponse(mFieldId, fieldType1, indexType1);
                        multiFieldMappings.add(multiFieldMapping);
                    }
                }
                return new FieldMappingResponse(pId, fieldType, indexType, format, multiFieldMappings.isEmpty() ? null : multiFieldMappings.toArray(new MultiFieldMappingResponse[multiFieldMappings.size()]));
            }
        }
        return null;
    }

    private Object[] parseIndexMappingsFieldAndType(Map<String, ?> propertyMapping) {
        if (null != propertyMapping && !propertyMapping.isEmpty()) {
            Object f;
            FieldMappingResponse.FieldType fieldType = null;
            FieldMappingResponse.IndexType indexType = null;
            Object i = propertyMapping.get("index");
            if (null != i) {
                indexType = FieldMappingResponse.IndexType.valueOf(i.toString().toUpperCase());
            }
            if (null != (f = propertyMapping.get("type"))) {
                fieldType = FieldMappingResponse.FieldType.valueOf(f.toString().toUpperCase());
            }
            return new Object[]{fieldType, indexType};
        }
        return null;
    }

    private void checkClient() throws ElasticSearchClientGenericException {
        if (null == this.client) {
            try {
                this.buildClient();
            }
            catch (Exception e) {
                throw new ElasticSearchClientGenericException("Error while building the elastic search client.", e);
            }
        }
    }

    private String[] getColumnIds(List<DataColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        String[] result = new String[columns.size()];
        for (int x = 0; x < columns.size(); ++x) {
            DataColumn column = columns.get(x);
            result[x] = column.getId();
        }
        return result;
    }

    private Client buildClient() throws Exception {
        if (null == this.client) {
            this.client = NativeClientFactory.getInstance().newClient(this.serverURL, this.clusterName, this.timeout);
        }
        return this.client;
    }

    private GetMappingsResponse getMappings() {
        GetMappingsRequestBuilder builder = new GetMappingsRequestBuilder((ElasticsearchClient)this.client, GetMappingsAction.INSTANCE, this.index);
        return (GetMappingsResponse)this.client.admin().indices().getMappings((GetMappingsRequest)builder.request()).actionGet();
    }
}

