/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.suite;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchCommonTests;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetCustomColumnsTest;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTest;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchEmptyIntervalsTest;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchMultiFieldsTest;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.NativeClientFactory;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={ElasticSearchCommonTests.class, ElasticSearchDataSetCustomColumnsTest.class, ElasticSearchDataSetTest.class, ElasticSearchEmptyIntervalsTest.class, ElasticSearchMultiFieldsTest.class})
public class ElasticSearchTestSuite {
    @ClassRule
    public static TemporaryFolder elHomeFolder = new TemporaryFolder();
    static final Logger logger = LoggerFactory.getLogger(ElasticSearchTestSuite.class);
    protected static final String EL_PROPERTY_ELASTICSEARCH = "elasticsearch";
    protected static final String EL_PROPERTY_HOME = "path.home";
    protected static final String EL_PROPERTY_SHARDS = "index.number_of_shards";
    protected static final String EL_PROPERTY_REPLICAS = "index.number_of_replicas";
    protected static final String EL_PROPERTY_FOREGROUND = "foreground";
    protected static final String EL_PROPERTY_SCRIPT_INLINE = "script.inline";
    protected static final String EL_PROPERTY_SCRIPT_INDEXED = "script.indexed";
    protected static final String EL_EXAMPLE_MAPPINGS = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-mappings.json";
    protected static final String EL_EXAMPLE_DATA = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-data.json";
    protected static final String EL_EXAMPLE_CSENSITIVE_INDEX = "expensereports-sensitive";
    protected static final String EL_EXAMPLE_CSENSITIVE_TYPE = "expense";
    protected static final String EL_EXAMPLE_CSENSITIVE_MAPPINGS = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-csensitive-mappings.json";
    protected static final String EL_EXAMPLE_CSENSITIVE_DATA = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-csensitive-data.json";
    protected static final String EL_EXAMPLE_EMPTYINTERVALS_INDEX = "emptyintervals";
    protected static final String EL_EXAMPLE_EMPTYINTERVALS_TYPE = "emptyinterval";
    protected static final String EL_EXAMPLE_EMPTYINTERVALS_MAPPINGS = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/emptyIntervals-mappings.json";
    protected static final String EL_EXAMPLE_EMPTYINTERVALS_DATA = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/emptyIntervals-data.json";
    protected static final String EL_EXAMPLE_MULTIFIELDS_INDEX = "multifields";
    protected static final String EL_EXAMPLE_MULTIFIELDS_TYPE = "multifield";
    protected static final String EL_EXAMPLE_MULTIFIELDS_MAPPINGS = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/multifields-mappings.json";
    protected static final String EL_EXAMPLE_MULTIFIELDS_DATA = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/multifields-data.json";
    protected static final String ENCODING = "UTF-8";
    private static Node elasticSearchNode = null;
    private static Client client = null;

    @BeforeClass
    public static void setUpClass() {
        try {
            ElasticSearchTestSuite.runELServer(elHomeFolder);
            ElasticSearchTestSuite.createAndPopulateExpenseReportsIndex();
            ElasticSearchTestSuite.createAndPopulateExpenseReportsCSensitiveIndex();
            ElasticSearchTestSuite.createAndPopulateEmptyIntervalsIndex();
            ElasticSearchTestSuite.createAndPopulateMultiFieldsIndex();
        }
        catch (Exception e) {
            logger.error("Error starting up the ELS instance.", (Throwable)e);
        }
    }

    @AfterClass
    public static void tearDownClass() {
        try {
            ElasticSearchTestSuite.stopELServer(elHomeFolder);
        }
        catch (Exception e) {
            logger.error("Error stopping the ELS instance.", (Throwable)e);
        }
    }

    public static void runELServer(TemporaryFolder elHomeFolder) throws Exception {
        File elHome = elHomeFolder.newFolder("dashbuilder-elasticsearch");
        elasticSearchNode = NodeBuilder.nodeBuilder().local(true).clusterName(EL_PROPERTY_ELASTICSEARCH).settings(Settings.settingsBuilder().put(EL_PROPERTY_SHARDS, "1").put(EL_PROPERTY_REPLICAS, "0").put(EL_PROPERTY_FOREGROUND, "yes").put(EL_PROPERTY_SCRIPT_INLINE, "on").put(EL_PROPERTY_SCRIPT_INDEXED, "on").put(EL_PROPERTY_HOME, elHome.getAbsolutePath())).node();
        elasticSearchNode.start();
        client = elasticSearchNode.client();
        NativeClientFactory.getInstance().setTestClient(client);
    }

    public static void createAndPopulateExpenseReportsIndex() throws Exception {
        ElasticSearchTestSuite.createIndexELServer("expensereports", EL_EXAMPLE_MAPPINGS);
        ElasticSearchTestSuite.populateELServer("expensereports", EL_EXAMPLE_CSENSITIVE_TYPE, EL_EXAMPLE_DATA);
        ElasticSearchTestSuite.testDocumentsCount("expensereports", EL_EXAMPLE_CSENSITIVE_TYPE, 50L);
    }

    public static void createAndPopulateExpenseReportsCSensitiveIndex() throws Exception {
        ElasticSearchTestSuite.createIndexELServer(EL_EXAMPLE_CSENSITIVE_INDEX, EL_EXAMPLE_CSENSITIVE_MAPPINGS);
        ElasticSearchTestSuite.populateELServer(EL_EXAMPLE_CSENSITIVE_INDEX, EL_EXAMPLE_CSENSITIVE_TYPE, EL_EXAMPLE_CSENSITIVE_DATA);
        ElasticSearchTestSuite.testDocumentsCount(EL_EXAMPLE_CSENSITIVE_INDEX, EL_EXAMPLE_CSENSITIVE_TYPE, 50L);
    }

    public static void createAndPopulateEmptyIntervalsIndex() throws Exception {
        ElasticSearchTestSuite.createIndexELServer(EL_EXAMPLE_EMPTYINTERVALS_INDEX, EL_EXAMPLE_EMPTYINTERVALS_MAPPINGS);
        ElasticSearchTestSuite.populateELServer(EL_EXAMPLE_EMPTYINTERVALS_INDEX, EL_EXAMPLE_EMPTYINTERVALS_TYPE, EL_EXAMPLE_EMPTYINTERVALS_DATA);
        ElasticSearchTestSuite.testDocumentsCount(EL_EXAMPLE_EMPTYINTERVALS_INDEX, EL_EXAMPLE_EMPTYINTERVALS_TYPE, 11L);
    }

    public static void createAndPopulateMultiFieldsIndex() throws Exception {
        ElasticSearchTestSuite.createIndexELServer(EL_EXAMPLE_MULTIFIELDS_INDEX, EL_EXAMPLE_MULTIFIELDS_MAPPINGS);
        ElasticSearchTestSuite.populateELServer(EL_EXAMPLE_MULTIFIELDS_INDEX, EL_EXAMPLE_MULTIFIELDS_TYPE, EL_EXAMPLE_MULTIFIELDS_DATA);
        ElasticSearchTestSuite.testDocumentsCount(EL_EXAMPLE_MULTIFIELDS_INDEX, EL_EXAMPLE_MULTIFIELDS_TYPE, 6L);
    }

    public static void createIndexELServer(String index, String jsonMappingsFile) throws Exception {
        String mappingsContent = ElasticSearchTestSuite.getFileAsString(jsonMappingsFile);
        CreateIndexRequest indexRequest = (CreateIndexRequest)new CreateIndexRequestBuilder((ElasticsearchClient)client, CreateIndexAction.INSTANCE).setIndex(index).setSource(mappingsContent).request();
        CreateIndexResponse indexResponse = (CreateIndexResponse)client.admin().indices().create(indexRequest).actionGet();
        if (!indexResponse.isAcknowledged()) {
            throw new RuntimeException("Error creating index [" + index + "]");
        }
    }

    public static void populateELServer(String index, String type, String dataFile) throws Exception {
        String[] textStr;
        String data = ElasticSearchTestSuite.getFileAsString(dataFile);
        BulkRequestBuilder bulkRequestBuilder = client.prepareBulk().setRefresh(true);
        for (String line : textStr = data.split("\\r\\n|\\n|\\r")) {
            bulkRequestBuilder.add(client.prepareIndex(index, type).setSource(line));
        }
        BulkResponse response = (BulkResponse)bulkRequestBuilder.execute().actionGet();
        if (response.hasFailures()) {
            throw new RuntimeException("Error when performing test index's data bulk operation. Index=[" + index + "]");
        }
    }

    public static void stopELServer(TemporaryFolder elHomeFolder) throws Exception {
        client.close();
        elasticSearchNode.close();
        elHomeFolder.delete();
    }

    public static void testDocumentsCount(String index, String type, long count) throws Exception {
        SearchRequest request = new SearchRequestBuilder((ElasticsearchClient)client, SearchAction.INSTANCE).setIndices(new String[]{index}).setTypes(new String[]{type}).request();
        SearchResponse response = (SearchResponse)client.search(request).actionGet();
        long c = response.getHits().totalHits();
        assert (count == c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getFileAsString(String file) throws Exception {
        InputStream mappingsFileUrl = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        String fileContent = null;
        try (StringWriter writer = null;){
            writer = new StringWriter();
            IOUtils.copy((InputStream)mappingsFileUrl, (Writer)writer, (String)ENCODING);
            fileContent = writer.toString();
        }
        return fileContent.replaceAll("\n", "\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object[] doGet(String url) throws Exception {
        Object[] response = null;
        if (url == null || url.trim().length() == 0) {
            return response;
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        try (CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet);){
            HttpEntity entity1 = response1.getEntity();
            String responseBody = ElasticSearchTestSuite.responseAsString(response1);
            int responseStatus = response1.getStatusLine().getStatusCode();
            response = new Object[]{responseStatus, responseBody};
            EntityUtils.consume((HttpEntity)entity1);
        }
        return response;
    }

    protected static String responseAsString(CloseableHttpResponse response) throws IOException {
        return ElasticSearchTestSuite.streamAsString(response.getEntity().getContent());
    }

    protected static String streamAsString(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)ENCODING);
        return writer.toString();
    }

    protected static void log(Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message.toString());
        }
    }
}

