/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl;

import java.util.Collection;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;

public class NativeClientQueryBuilder {
    public QueryBuilder build(Query query) {
        return this.translate(query);
    }

    private QueryBuilder translate(Query query) {
        if (query == null) {
            return null;
        }
        Query.Type type = query.getType();
        switch (type) {
            case BOOL: {
                return this.translateBool(query);
            }
            case MATCH: {
                return this.translateMatch(query);
            }
            case MATCH_ALL: {
                return this.translateMatchAll(query);
            }
            case WILDCARD: {
                return this.translateWildcard(query);
            }
            case QUERY_STRING: {
                return this.translateQueryString(query);
            }
            case FILTERED: {
                return this.translateFiltered(query);
            }
            case AND: {
                return this.translateAnd(query);
            }
            case OR: {
                return this.translateOr(query);
            }
            case NOT: {
                return this.translateNot(query);
            }
            case EXISTS: {
                return this.translateExists(query);
            }
            case TERM: {
                return this.translateTerm(query);
            }
            case TERMS: {
                return this.translateTerms(query);
            }
            case RANGE: {
                return this.translateRange(query);
            }
        }
        return null;
    }

    private ExistsQueryBuilder translateExists(Query query) {
        if (query == null) {
            return null;
        }
        String field = query.getField();
        return new ExistsQueryBuilder(field);
    }

    private TermQueryBuilder translateTerm(Query query) {
        if (query == null) {
            return null;
        }
        String field = query.getField();
        Object value = query.getParam(Query.Parameter.VALUE.name());
        return new TermQueryBuilder(field, value);
    }

    private TermsQueryBuilder translateTerms(Query query) {
        if (query == null) {
            return null;
        }
        String field = query.getField();
        Collection terms = (Collection)query.getParam(Query.Parameter.VALUE.name());
        return new TermsQueryBuilder(field, (Iterable)terms);
    }

    private RangeQueryBuilder translateRange(Query query) {
        Object gte;
        Object gt;
        Object lte;
        if (query == null) {
            return null;
        }
        String field = query.getField();
        RangeQueryBuilder builder = new RangeQueryBuilder(field);
        Object lt = query.getParam(Query.Parameter.LT.name());
        if (null != lt) {
            builder.lt(lt);
        }
        if (null != (lte = query.getParam(Query.Parameter.LTE.name()))) {
            builder.lte(lte);
        }
        if (null != (gt = query.getParam(Query.Parameter.GT.name()))) {
            builder.gt(gt);
        }
        if (null != (gte = query.getParam(Query.Parameter.GTE.name()))) {
            builder.gte(gte);
        }
        return builder;
    }

    private BoolQueryBuilder translateAnd(Query query) {
        return this.translateLogical(query, 1);
    }

    private BoolQueryBuilder translateOr(Query query) {
        return this.translateLogical(query, 2);
    }

    private BoolQueryBuilder translateNot(Query query) {
        return this.translateBooleanQueries(new BoolQueryBuilder(), 3, query.getParam(Query.Parameter.FILTER.name()));
    }

    private BoolQueryBuilder translateLogical(Query query, int op) {
        return this.translateBooleanQueries(new BoolQueryBuilder(), op, query.getParam(Query.Parameter.FILTERS.name()));
    }

    private BoolQueryBuilder translateBooleanQueries(BoolQueryBuilder builder, int op, Object queryArguments) {
        if (op == 2) {
            builder.minimumNumberShouldMatch(1);
        }
        if (null != queryArguments && queryArguments instanceof Collection) {
            Collection queries = (Collection)queryArguments;
            for (Query q : queries) {
                QueryBuilder queryBuilder = this.translate(q);
                this.applyLogicalOperator(builder, op, queryBuilder);
            }
        } else if (null != queryArguments && queryArguments instanceof Query) {
            QueryBuilder queryBuilder = this.translate((Query)queryArguments);
            this.applyLogicalOperator(builder, op, queryBuilder);
        } else if (null != queryArguments && queryArguments instanceof QueryBuilder) {
            this.applyLogicalOperator(builder, op, (QueryBuilder)queryArguments);
        }
        return builder;
    }

    private void applyLogicalOperator(BoolQueryBuilder builder, int op, QueryBuilder argument) {
        if (op == 1) {
            builder.must(argument);
        } else if (op == 2) {
            builder.should(argument);
        } else if (op == 3) {
            builder.mustNot(argument);
        }
    }

    private BoolQueryBuilder translateBool(Query query) {
        if (query == null) {
            return null;
        }
        BoolQueryBuilder builder = new BoolQueryBuilder();
        this.translateBooleanQueries(builder, 1, query.getParam(Query.Parameter.MUST.name()));
        this.translateBooleanQueries(builder, 2, query.getParam(Query.Parameter.SHOULD.name()));
        this.translateBooleanQueries(builder, 3, query.getParam(Query.Parameter.MUST_NOT.name()));
        return builder;
    }

    private BoolQueryBuilder translateFiltered(Query query) {
        if (query == null) {
            return null;
        }
        Query _query = (Query)query.getParam(Query.Parameter.QUERY.name());
        Query filter = (Query)query.getParam(Query.Parameter.FILTER.name());
        BoolQueryBuilder builder = new BoolQueryBuilder();
        QueryBuilder queryBuilder = this.translate(_query);
        if (null != queryBuilder) {
            builder.must(queryBuilder);
        }
        QueryBuilder filterBuilder = this.translate(filter);
        if (null != filter) {
            builder.filter(filterBuilder);
        }
        return builder;
    }

    private MatchQueryBuilder translateMatch(Query query) {
        if (query == null) {
            return null;
        }
        String field = query.getField();
        Object value = query.getParam(Query.Parameter.VALUE.name());
        String operator = (String)query.getParam(Query.Parameter.OPERATOR.name());
        MatchQueryBuilder builder = new MatchQueryBuilder(field, value);
        if (null != operator) {
            builder.operator(this.getMatchOperator(operator));
            builder.minimumShouldMatch("1");
        }
        return builder;
    }

    private MatchQueryBuilder.Operator getMatchOperator(String op) {
        if ("OR".equalsIgnoreCase(op)) {
            return MatchQueryBuilder.Operator.OR;
        }
        return MatchQueryBuilder.Operator.AND;
    }

    private WildcardQueryBuilder translateWildcard(Query query) {
        if (query == null) {
            return null;
        }
        String field = query.getField();
        Object value = query.getParam(Query.Parameter.VALUE.name());
        return new WildcardQueryBuilder(field, (String)value);
    }

    private QueryStringQueryBuilder translateQueryString(Query query) {
        if (query == null) {
            return null;
        }
        Object pattern = query.getParam(Query.Parameter.QUERY.name());
        Object defField = query.getParam(Query.Parameter.DEFAULT_FIELD.name());
        Object defOp = query.getParam(Query.Parameter.DEFAULT_OPERATOR.name());
        Object lowerCase = query.getParam(Query.Parameter.LOWERCASE_EXPANDED_TERMS.name());
        return new QueryStringQueryBuilder(pattern.toString()).defaultField(defField.toString()).defaultOperator(this.getQueryOperator(defOp.toString())).lowercaseExpandedTerms(Boolean.valueOf(lowerCase.toString()).booleanValue());
    }

    private QueryStringQueryBuilder.Operator getQueryOperator(String op) {
        if ("OR".equalsIgnoreCase(op)) {
            return QueryStringQueryBuilder.Operator.OR;
        }
        return QueryStringQueryBuilder.Operator.AND;
    }

    private MatchAllQueryBuilder translateMatchAll(Query query) {
        if (query == null) {
            return null;
        }
        return new MatchAllQueryBuilder();
    }
}

