/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTestBase;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticSearchDataSetCustomColumnsTest
extends ElasticSearchDataSetTestBase {
    protected static final String EL_EXAMPLE_ALL_COLUMNS_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports-allcolumns.dset";
    protected static final String EL_DATASET_ALL_COLUMNS_UUID = "expense_reports_allcolumns";
    protected static final String EL_EXAMPLE_CUSTOM_COLUMNS_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports-custom-columns.dset";
    protected static final String EL_DATASET_CUSTOM_COLUMNS_UUID = "expense_reports_custom_columns";
    protected static final String EL_EXAMPLE_CUSTOM_COLUMNS2_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports-custom-columns2.dset";
    protected static final String EL_DATASET_CUSTOM_COLUMNS2_UUID = "expense_reports_custom_columns2";
    protected static final String EL_EXAMPLE_BAD_COLUMNS_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports-custom-columns-error.dset";
    protected static final String EL_DATASET_BAD_COLUMNS_UUID = "expense_reports_custom_columns_error";

    @Before
    public void registerDataSet() throws Exception {
        super.setUp();
        this._registerDataSet(EL_EXAMPLE_ALL_COLUMNS_DATASET_DEF);
        this._registerDataSet(EL_EXAMPLE_CUSTOM_COLUMNS_DATASET_DEF);
        this._registerDataSet(EL_EXAMPLE_CUSTOM_COLUMNS2_DATASET_DEF);
        this._registerDataSet(EL_EXAMPLE_BAD_COLUMNS_DATASET_DEF);
    }

    @Test
    public void testAllColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_ALL_COLUMNS_UUID)).buildLookup());
        Assert.assertNotNull((Object)result.getColumns());
        Assert.assertTrue((result.getColumns().size() == 6 ? 1 : 0) != 0);
        this.assertColumnIdAndType(result, "AMOUNT", ColumnType.NUMBER);
        this.assertColumnIdAndType(result, "CITY", ColumnType.LABEL);
        this.assertColumnIdAndType(result, "CREATION_DATE", ColumnType.DATE);
        this.assertColumnIdAndType(result, "DEPARTMENT", ColumnType.LABEL);
        this.assertColumnIdAndType(result, "EMPLOYEE", ColumnType.TEXT);
        this.assertColumnIdAndType(result, "EXPENSES_ID", ColumnType.NUMBER);
    }

    @Test
    public void testCustomColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CUSTOM_COLUMNS_UUID)).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assert.assertNotNull((Object)result.getColumns());
        Assert.assertTrue((result.getColumns().size() == 6 ? 1 : 0) != 0);
        this.assertColumnIdAndType(result, "AMOUNT", ColumnType.NUMBER);
        this.assertColumnIdAndType(result, "CITY", ColumnType.TEXT);
        this.assertColumnIdAndType(result, "CREATION_DATE", ColumnType.DATE);
        this.assertColumnIdAndType(result, "DEPARTMENT", ColumnType.LABEL);
        this.assertColumnIdAndType(result, "EMPLOYEE", ColumnType.TEXT);
        this.assertColumnIdAndType(result, "EXPENSES_ID", ColumnType.NUMBER);
    }

    @Test
    public void testGivenColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CUSTOM_COLUMNS2_UUID)).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
        Assert.assertNotNull((Object)result.getColumns());
        Assert.assertTrue((result.getColumns().size() == 4 ? 1 : 0) != 0);
        this.assertColumnIdAndType(result, "EXPENSES_ID", ColumnType.NUMBER);
        this.assertColumnIdAndType(result, "EMPLOYEE", ColumnType.TEXT);
        this.assertColumnIdAndType(result, "CITY", ColumnType.TEXT);
        this.assertColumnIdAndType(result, "AMOUNT", ColumnType.NUMBER);
    }

    private void assertColumnIdAndType(DataSet result, String columnId, ColumnType columnType) {
        DataColumn amountCol = result.getColumnById(columnId);
        Assert.assertNotNull((Object)amountCol);
        Assert.assertEquals((Object)amountCol.getColumnType(), (Object)columnType);
    }

    @Test(expected=RuntimeException.class)
    public void testSortingWithNonExstingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CUSTOM_COLUMNS_UUID)).sort("mycolumn", SortOrder.DESCENDING)).buildLookup());
    }

    @Test(expected=RuntimeException.class)
    public void testSortingWithNonDefinedColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CUSTOM_COLUMNS2_UUID)).sort("DEPARTMENT", SortOrder.DESCENDING)).buildLookup());
    }

    @Test(expected=RuntimeException.class)
    public void testColumnsBadDefined() throws Exception {
        this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_BAD_COLUMNS_UUID)).sort("EXPENSES_ID", SortOrder.ASCENDING)).buildLookup());
    }
}

