/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.impl;

import org.dashbuilder.displayer.ChartSettingsBuilder;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.impl.AbstractDisplayerSettingsBuilder;

public abstract class AbstractChartSettingsBuilder<T extends ChartSettingsBuilder>
extends AbstractDisplayerSettingsBuilder<T>
implements ChartSettingsBuilder<T> {
    @Override
    public T subtype(DisplayerSubType displayerSubType) {
        this.displayerSettings.setSubtype(displayerSubType);
        return (T)this;
    }

    @Override
    public T width(int width) {
        this.displayerSettings.setChartWidth(width);
        return (T)this;
    }

    @Override
    public T height(int height) {
        this.displayerSettings.setChartHeight(height);
        return (T)this;
    }

    @Override
    public T margins(int top, int bottom, int left, int right) {
        this.displayerSettings.setChartMarginTop(top);
        this.displayerSettings.setChartMarginBottom(bottom);
        this.displayerSettings.setChartMarginLeft(left);
        this.displayerSettings.setChartMarginRight(right);
        return (T)this;
    }

    @Override
    public T legendOff() {
        this.displayerSettings.setChartShowLegend(false);
        return (T)this;
    }

    @Override
    public T legendOn(Position position) {
        return this.legendOn(position.name());
    }

    @Override
    public T legendOn(String position) {
        this.displayerSettings.setChartShowLegend(true);
        this.displayerSettings.setChartLegendPosition(Position.getByName(position));
        return (T)this;
    }

    @Override
    public T resizableOn(int maxWidth, int maxHeight) {
        this.displayerSettings.setResizable(true);
        this.displayerSettings.setChartMaxWidth(maxWidth);
        this.displayerSettings.setChartMaxHeight(maxHeight);
        return (T)this;
    }

    @Override
    public T resizableOff() {
        this.displayerSettings.setResizable(false);
        return (T)this;
    }
}

