/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.Position;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class DisplayerSettings {
    protected String UUID;
    protected DataSet dataSet;
    protected DataSetLookup dataSetLookup;
    protected List<ColumnSettings> columnSettingsList = new ArrayList<ColumnSettings>();
    protected Map<String, String> settings = new HashMap<String, String>(30);

    public DisplayerSettings() {
    }

    public DisplayerSettings(DisplayerType displayerType) {
        this();
        this.setType(displayerType);
    }

    public DisplayerSettings cloneInstance() {
        DisplayerSettings clone = new DisplayerSettings();
        clone.UUID = this.UUID;
        clone.settings = new HashMap<String, String>(this.settings);
        clone.columnSettingsList = new ArrayList<ColumnSettings>();
        for (ColumnSettings columnSettings : this.columnSettingsList) {
            clone.columnSettingsList.add(columnSettings.cloneInstance());
        }
        if (this.dataSet != null) {
            clone.dataSet = this.dataSet.cloneInstance();
        }
        if (this.dataSetLookup != null) {
            clone.dataSetLookup = this.dataSetLookup.cloneInstance();
        }
        return clone;
    }

    public boolean equals(Object obj) {
        try {
            DisplayerSettings other = (DisplayerSettings)obj;
            if (other == null) {
                return false;
            }
            if (this.UUID != null && !this.UUID.equals(other.UUID)) {
                return false;
            }
            if (this.dataSet != null && !this.dataSet.equals(other.dataSet)) {
                return false;
            }
            if (this.dataSetLookup != null && !this.dataSetLookup.equals((Object)other.dataSetLookup)) {
                return false;
            }
            if (this.columnSettingsList.size() != other.columnSettingsList.size()) {
                return false;
            }
            for (int i = 0; i < this.columnSettingsList.size(); ++i) {
                if (this.columnSettingsList.get(i).equals(other.columnSettingsList.get(i))) continue;
                return false;
            }
            if (this.settings.size() != other.settings.size()) {
                return false;
            }
            for (String setting : this.settings.keySet()) {
                if (this.settings.get(setting).equals(other.settings.get(setting))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public List<ColumnSettings> getColumnSettingsList() {
        return this.columnSettingsList;
    }

    public void setColumnSettingsList(List<ColumnSettings> columnSettingsList) {
        if (columnSettingsList != null) {
            this.columnSettingsList = columnSettingsList;
        } else {
            this.columnSettingsList.clear();
        }
    }

    public void removeColumnSettings(String columnId) {
        Iterator<ColumnSettings> it = this.columnSettingsList.iterator();
        while (it.hasNext()) {
            ColumnSettings columnSettings = it.next();
            if (!columnSettings.getColumnId().equals(columnId)) continue;
            it.remove();
        }
    }

    public ColumnSettings getColumnSettings(String columnId) {
        for (ColumnSettings columnSettings : this.columnSettingsList) {
            if (!columnSettings.getColumnId().equals(columnId)) continue;
            return columnSettings;
        }
        return null;
    }

    public ColumnSettings getColumnSettings(DataColumn column) {
        ColumnSettings sourceSettings = this.getColumnSettings(column.getId());
        return ColumnSettings.cloneWithDefaults(sourceSettings, column);
    }

    public void setColumnName(String columnId, String name) {
        ColumnSettings columnSettings = this.getColumnSettings(columnId);
        if (columnSettings == null) {
            columnSettings = new ColumnSettings(columnId);
            this.columnSettingsList.add(columnSettings);
        }
        columnSettings.setColumnName(name);
    }

    public void setColumnValueExpression(String columnId, String expression) {
        ColumnSettings columnSettings = this.getColumnSettings(columnId);
        if (columnSettings == null) {
            columnSettings = new ColumnSettings(columnId);
            this.columnSettingsList.add(columnSettings);
        }
        columnSettings.setValueExpression(expression);
    }

    public void setColumnValuePattern(String columnId, String pattern) {
        ColumnSettings columnSettings = this.getColumnSettings(columnId);
        if (columnSettings == null) {
            columnSettings = new ColumnSettings(columnId);
            this.columnSettingsList.add(columnSettings);
        }
        columnSettings.setValuePattern(pattern);
    }

    public void setColumnEmptyTemplate(String columnId, String template) {
        ColumnSettings columnSettings = this.getColumnSettings(columnId);
        if (columnSettings == null) {
            columnSettings = new ColumnSettings(columnId);
            this.columnSettingsList.add(columnSettings);
        }
        columnSettings.setEmptyTemplate(template);
    }

    private String getSettingPath(DisplayerAttributeDef displayerAttributeDef) {
        return displayerAttributeDef.getFullId();
    }

    private int parseInt(String value, int defaultValue) {
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private long parseLong(String value, long defaultValue) {
        if (value == null || value.trim().length() == 0) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    private boolean parseBoolean(String value) {
        if (value == null || value.trim().length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(value);
    }

    private String parseString(String value) {
        if (value == null || value.trim().length() == 0) {
            return "";
        }
        return value;
    }

    public String getUUID() {
        return this.UUID;
    }

    public void setUUID(String UUID) {
        this.UUID = UUID;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public DataSetLookup getDataSetLookup() {
        return this.dataSetLookup;
    }

    public void setDataSetLookup(DataSetLookup dataSetLookup) {
        this.dataSetLookup = dataSetLookup;
    }

    public String getDisplayerSetting(DisplayerAttributeDef displayerAttributeDef) {
        return this.settings.get(this.getSettingPath(displayerAttributeDef));
    }

    public void setDisplayerSetting(DisplayerAttributeDef displayerAttributeDef, String value) {
        this.settings.put(this.getSettingPath(displayerAttributeDef), value);
    }

    public void setDisplayerSetting(String displayerAttributeDef, String value) {
        this.settings.put(displayerAttributeDef, value);
    }

    public void removeDisplayerSetting(DisplayerAttributeDef displayerAttributeDef) {
        this.settings.remove(this.getSettingPath(displayerAttributeDef));
    }

    public void removeDisplayerSetting(DisplayerAttributeGroupDef displayerAttributeGroup) {
        for (DisplayerAttributeDef attributeDef : displayerAttributeGroup.getChildren()) {
            this.settings.remove(this.getSettingPath(attributeDef));
        }
    }

    public void removeDisplayerSetting(String displayerAttributeDef) {
        this.settings.remove(displayerAttributeDef);
    }

    public Map<String, String> getSettingsFlatMap() {
        return this.settings;
    }

    public void setSettingsFlatMap(Map<String, String> settings) {
        this.settings = settings;
    }

    public DisplayerType getType() {
        String strType = this.settings.get(this.getSettingPath(DisplayerAttributeDef.TYPE));
        return DisplayerType.getByName(strType);
    }

    public void setType(DisplayerType displayerType) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TYPE), displayerType.toString());
    }

    public DisplayerSubType getSubtype() {
        String strSubtype = this.settings.get(this.getSettingPath(DisplayerAttributeDef.SUBTYPE));
        return DisplayerSubType.getByName(strSubtype);
    }

    public void setSubtype(DisplayerSubType subtype) {
        if (subtype != null) {
            this.settings.put(this.getSettingPath(DisplayerAttributeDef.SUBTYPE), subtype.toString());
        } else {
            this.settings.remove(this.getSettingPath(DisplayerAttributeDef.SUBTYPE));
        }
    }

    public String getRenderer() {
        return this.settings.get(this.getSettingPath(DisplayerAttributeDef.RENDERER));
    }

    public void setRenderer(String renderer) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.RENDERER), renderer);
    }

    public String getTitle() {
        return this.parseString(this.settings.get(this.getSettingPath(DisplayerAttributeDef.TITLE)));
    }

    public void setTitle(String title) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TITLE), title);
    }

    public boolean isTitleVisible() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.TITLE_VISIBLE)));
    }

    public void setTitleVisible(boolean titleVisible) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TITLE_VISIBLE), Boolean.toString(titleVisible));
    }

    public boolean isCSVExportAllowed() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.ALLOW_EXPORT_CSV)));
    }

    public void setCSVExportAllowed(boolean csvExportAllowed) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.ALLOW_EXPORT_CSV), Boolean.toString(csvExportAllowed));
    }

    public boolean isExcelExportAllowed() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.ALLOW_EXPORT_EXCEL)));
    }

    public void setExcelExportAllowed(boolean excelExportAllowed) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.ALLOW_EXPORT_EXCEL), Boolean.toString(excelExportAllowed));
    }

    public int getRefreshInterval() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.REFRESH_INTERVAL)), -1);
    }

    public void setRefreshInterval(int refreshInSeconds) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.REFRESH_INTERVAL), Integer.toString(refreshInSeconds));
    }

    public boolean isRefreshStaleData() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.REFRESH_STALE_DATA)));
    }

    public void setRefreshStaleData(boolean refresh) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.REFRESH_STALE_DATA), Boolean.toString(refresh));
    }

    public boolean isFilterEnabled() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.FILTER_ENABLED)));
    }

    public void setFilterEnabled(boolean filterEnabled) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.FILTER_ENABLED), Boolean.toString(filterEnabled));
    }

    public boolean isFilterSelfApplyEnabled() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.FILTER_SELFAPPLY_ENABLED)));
    }

    public void setFilterSelfApplyEnabled(boolean filterSelfApplyEnabled) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.FILTER_SELFAPPLY_ENABLED), Boolean.toString(filterSelfApplyEnabled));
    }

    public boolean isFilterNotificationEnabled() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.FILTER_NOTIFICATION_ENABLED)));
    }

    public void setFilterNotificationEnabled(boolean filterNotificationEnabled) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.FILTER_NOTIFICATION_ENABLED), Boolean.toString(filterNotificationEnabled));
    }

    public boolean isFilterListeningEnabled() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.FILTER_LISTENING_ENABLED)));
    }

    public void setFilterListeningEnabled(boolean filterListeningEnabled) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.FILTER_LISTENING_ENABLED), Boolean.toString(filterListeningEnabled));
    }

    public int getChartWidth() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_WIDTH)), 500);
    }

    public void setChartWidth(int chartWidth) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_WIDTH), Integer.toString(chartWidth));
    }

    public String getChartBackgroundColor() {
        return this.parseString(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_BGCOLOR)));
    }

    public void setChartBackgroundColor(String color) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_BGCOLOR), color);
    }

    public int getChartHeight() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_HEIGHT)), 300);
    }

    public void setChartHeight(int chartHeight) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_HEIGHT), Integer.toString(chartHeight));
    }

    public int getChartMarginTop() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_TOP)), 10);
    }

    public void setChartMarginTop(int chartMarginTop) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_TOP), Integer.toString(chartMarginTop));
    }

    public int getChartMarginBottom() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_BOTTOM)), 10);
    }

    public void setChartMarginBottom(int chartMarginBottom) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_BOTTOM), Integer.toString(chartMarginBottom));
    }

    public int getChartMarginLeft() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_LEFT)), 10);
    }

    public void setChartMarginLeft(int chartMarginLeft) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_LEFT), Integer.toString(chartMarginLeft));
    }

    public int getChartMarginRight() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_RIGHT)), 10);
    }

    public void setChartMarginRight(int chartMarginRight) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_MARGIN_RIGHT), Integer.toString(chartMarginRight));
    }

    public int getChartMaxWidth() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_MAX_WIDTH)), 600);
    }

    public void setChartMaxWidth(int chartWidth) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_MAX_WIDTH), Integer.toString(chartWidth));
    }

    public int getChartMaxHeight() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_MAX_HEIGHT)), 400);
    }

    public void setChartMaxHeight(int chartHeight) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_MAX_HEIGHT), Integer.toString(chartHeight));
    }

    public void setResizable(boolean resizable) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_RESIZABLE), Boolean.toString(resizable));
    }

    public boolean isResizable() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_RESIZABLE)));
    }

    public boolean isChartShowLegend() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_SHOWLEGEND)));
    }

    public void setChartShowLegend(boolean chartShowLegend) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_SHOWLEGEND), Boolean.toString(chartShowLegend));
    }

    public Position getChartLegendPosition() {
        Position pos = Position.getByName(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_LEGENDPOSITION)));
        if (pos == null) {
            return Position.RIGHT;
        }
        return pos;
    }

    public void setChartLegendPosition(Position chartLegendPosition) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_LEGENDPOSITION), chartLegendPosition.toString());
    }

    public int getTablePageSize() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.TABLE_PAGESIZE)), 10);
    }

    public void setTablePageSize(int tablePageSize) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TABLE_PAGESIZE), Integer.toString(tablePageSize));
    }

    public int getTableWidth() {
        return this.parseInt(this.settings.get(this.getSettingPath(DisplayerAttributeDef.TABLE_WIDTH)), 0);
    }

    public void setTableWidth(int tableWidth) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TABLE_WIDTH), Integer.toString(tableWidth));
    }

    public boolean isTableSortEnabled() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.TABLE_SORTENABLED)));
    }

    public void setTableSortEnabled(boolean tableSortEnabled) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TABLE_SORTENABLED), Boolean.toString(tableSortEnabled));
    }

    public String getTableDefaultSortColumnId() {
        return this.parseString(this.settings.get(this.getSettingPath(DisplayerAttributeDef.TABLE_SORTCOLUMNID)));
    }

    public void setTableDefaultSortColumnId(String tableDefaultSortColumnId) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TABLE_SORTCOLUMNID), tableDefaultSortColumnId);
    }

    public SortOrder getTableDefaultSortOrder() {
        SortOrder order = SortOrder.getByName((String)this.settings.get(this.getSettingPath(DisplayerAttributeDef.TABLE_SORTORDER)));
        if (order == null) {
            return SortOrder.ASCENDING;
        }
        return order;
    }

    public void setTableDefaultSortOrder(SortOrder tableDefaultSortOrder) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.TABLE_SORTORDER), tableDefaultSortOrder.toString());
    }

    public boolean isXAxisShowLabels() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.XAXIS_SHOWLABELS)));
    }

    public void setXAxisShowLabels(boolean axisShowLabels) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.XAXIS_SHOWLABELS), Boolean.toString(axisShowLabels));
    }

    public String getXAxisTitle() {
        return this.parseString(this.settings.get(this.getSettingPath(DisplayerAttributeDef.XAXIS_TITLE)));
    }

    public void setXAxisTitle(String axisTitle) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.XAXIS_TITLE), axisTitle);
    }

    public boolean isYAxisShowLabels() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.YAXIS_SHOWLABELS)));
    }

    public void setYAxisShowLabels(boolean axisShowLabels) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.YAXIS_SHOWLABELS), Boolean.toString(axisShowLabels));
    }

    public String getYAxisTitle() {
        return this.parseString(this.settings.get(this.getSettingPath(DisplayerAttributeDef.YAXIS_TITLE)));
    }

    public void setYAxisTitle(String axisTitle) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.YAXIS_TITLE), axisTitle);
    }

    public long getMeterStart() {
        return this.parseLong(this.settings.get(this.getSettingPath(DisplayerAttributeDef.METER_START)), 0L);
    }

    public void setMeterStart(long meterStart) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.METER_START), Long.toString(meterStart));
    }

    public long getMeterWarning() {
        return this.parseLong(this.settings.get(this.getSettingPath(DisplayerAttributeDef.METER_WARNING)), 60L);
    }

    public void setMeterWarning(long meterWarning) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.METER_WARNING), Long.toString(meterWarning));
    }

    public long getMeterCritical() {
        return this.parseLong(this.settings.get(this.getSettingPath(DisplayerAttributeDef.METER_CRITICAL)), 90L);
    }

    public void setMeterCritical(long meterCritical) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.METER_CRITICAL), Long.toString(meterCritical));
    }

    public long getMeterEnd() {
        return this.parseLong(this.settings.get(this.getSettingPath(DisplayerAttributeDef.METER_END)), 100L);
    }

    public void setMeterEnd(long meterEnd) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.METER_END), Long.toString(meterEnd));
    }

    public boolean isChart3D() {
        return this.parseBoolean(this.settings.get(this.getSettingPath(DisplayerAttributeDef.CHART_3D)));
    }

    public void setChart3D(boolean barchartThreeDimension) {
        this.settings.put(this.getSettingPath(DisplayerAttributeDef.CHART_3D), Boolean.toString(barchartThreeDimension));
    }
}

