/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.json;

import java.util.Arrays;
import java.util.Collection;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.AreaChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.json.JsonObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DisplayerSettingsJsonTest {
    public static final DisplayerSettings OPPS_BY_PIPELINE = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("opps-by-pipeline")).dataset("SALES_OPPS")).group("PIPELINE")).column("PIPELINE", "Pipeline")).column(AggregateFunctionType.COUNT, "Number of opps")).title("salesopps_displayers_by_pipeline_title")).titleVisible(false)).width(500)).height(300)).margins(10, 10, 10, 10)).filterOn(false, true, true)).refreshOn()).buildSettings();
    public static final DisplayerSettings OPPS_BY_STATUS = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("opps-by-status")).dataset("SALES_OPPS")).group("STATUS")).column("STATUS", "Status")).column("AMOUNT", AggregateFunctionType.SUM, "Total amount")).title("salesopps_displayers_by_status_title")).titleVisible(false)).margins(10, 10, 10, 10)).filterOn(false, true, true)).refreshOn()).buildSettings();
    public static final DisplayerSettings OPPS_BY_SALESMAN = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("opps-by-salesman")).dataset("SALES_OPPS")).group("SALES_PERSON")).column("SALES_PERSON", "Sales person")).column("AMOUNT", AggregateFunctionType.SUM, "Total amount")).title("salesopps_displayers_by_salesman_title")).titleVisible(false)).margins(10, 10, 10, 10)).filterOn(false, true, true)).refreshOn()).buildSettings();
    public static final DisplayerSettings OPPS_EXPECTED_PIPELINE = ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().uuid("opps-expected-pipeline")).dataset("SALES_OPPS")).group("CLOSING_DATE")).dynamic(24, DateIntervalType.MONTH, true)).column("CLOSING_DATE", "Closing date")).column("EXPECTED_AMOUNT", AggregateFunctionType.SUM, "salesopps_displayers_by_exp_pipeline_column1")).title("salesopps_displayers_by_exp_pipeline_title")).titleVisible(false)).width(500)).height(300)).margins(20, 50, 100, 100)).filterOn(true, true, true)).refreshOn()).buildSettings();
    public static final DisplayerSettings OPPS_BY_PRODUCT = ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().subType_Bar()).uuid("opps-by-product")).dataset("SALES_OPPS")).group("PRODUCT")).column("PRODUCT", "Product")).column("AMOUNT", AggregateFunctionType.SUM, "salesopps_displayers_by_product_column1")).title("salesopps_displayers_by_product_title")).titleVisible(false)).margins(10, 50, 100, 100)).filterOn(false, true, true)).refreshOn()).buildSettings();
    public static final DisplayerSettings OPPS_BY_COUNTRY = ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().subType_Bar()).uuid("opps-by-country")).dataset("SALES_OPPS")).group("COUNTRY")).column("COUNTRY", "Country")).column("AMOUNT", AggregateFunctionType.SUM, "alesopps_displayers_by_country_column1")).title("salesopps_displayers_by_country_title")).titleVisible(false)).margins(10, 80, 100, 100)).filterOn(false, true, true)).refreshOn()).buildSettings();
    public static final DisplayerSettings OPPS_COUNTRY_SUMMARY = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().uuid("opps-country-summary")).dataset("SALES_OPPS")).group("COUNTRY")).column("COUNTRY", "salesopps_displayers_country_summary_column1")).column("AMOUNT", AggregateFunctionType.SUM, "salesopps_displayers_country_summary_column2")).column(AggregateFunctionType.COUNT, "salesopps_displayers_country_summary_column3")).column("AMOUNT", AggregateFunctionType.AVERAGE, "salesopps_displayers_country_summary_column4")).column("AMOUNT", AggregateFunctionType.MIN, "salesopps_displayers_country_summary_column5")).column("AMOUNT", AggregateFunctionType.MAX, "salesopps_displayers_country_summary_column6")).title("salesopps_displayers_country_summary_title")).titleVisible(false)).tablePageSize(20).filterOff(true)).refreshOn()).buildSettings();
    public static final DisplayerSettings OPPS_ALLOPPS_LISTING = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().uuid("opps-allopps-listing")).dataset("SALES_OPPS")).title("salesopps_displayers_all_list_title")).titleVisible(false)).tablePageSize(20).tableOrderEnabled(true).tableOrderDefault("AMOUNT", SortOrder.DESCENDING).filterOn(true, true, true)).refreshOn()).buildSettings();
    protected DisplayerSettings displayerSettings;

    @Parameterized.Parameters
    public static Collection displayers() {
        return Arrays.asList({OPPS_ALLOPPS_LISTING}, {OPPS_BY_COUNTRY}, {OPPS_BY_PIPELINE}, {OPPS_BY_PRODUCT}, {OPPS_BY_SALESMAN}, {OPPS_BY_STATUS}, {OPPS_COUNTRY_SUMMARY}, {OPPS_EXPECTED_PIPELINE});
    }

    public DisplayerSettingsJsonTest(DisplayerSettings settings) {
        this.displayerSettings = settings;
    }

    @Test
    public void testSettingsMarshalling() {
        DisplayerSettingsJSONMarshaller displayerJsonMarshaller = DisplayerSettingsJSONMarshaller.get();
        JsonObject _jsonObj = displayerJsonMarshaller.toJsonObject(this.displayerSettings);
        Assert.assertNotNull((Object)_jsonObj.toString());
        DisplayerSettings unmarshalled = displayerJsonMarshaller.fromJsonString(_jsonObj.toString());
        Assert.assertEquals((Object)unmarshalled, (Object)this.displayerSettings);
    }
}

