/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.impl;

import java.util.List;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.AbstractDataSetLookupBuilder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsBuilder;
import org.dashbuilder.displayer.DisplayerSubType;

public abstract class AbstractDisplayerSettingsBuilder<T>
extends AbstractDataSetLookupBuilder<T>
implements DisplayerSettingsBuilder<T> {
    protected DisplayerSettings displayerSettings = this.createDisplayerSettings();

    protected abstract DisplayerSettings createDisplayerSettings();

    @Override
    public T uuid(String uuid) {
        this.displayerSettings.setUUID(uuid);
        return (T)this;
    }

    @Override
    public T dataset(DataSet dataSet) {
        this.displayerSettings.setDataSet(dataSet);
        return (T)this;
    }

    @Override
    public T title(String title) {
        this.displayerSettings.setTitle(title);
        return (T)this;
    }

    @Override
    public T titleVisible(boolean visible) {
        this.displayerSettings.setTitleVisible(visible);
        return (T)this;
    }

    public T allowCsvExport(boolean allowCsvExport) {
        this.displayerSettings.setCSVExportAllowed(allowCsvExport);
        return (T)this;
    }

    public T allowExcelExport(boolean allowExcelExport) {
        this.displayerSettings.setExcelExportAllowed(allowExcelExport);
        return (T)this;
    }

    @Override
    public T backgroundColor(String backgroundColor) {
        this.displayerSettings.setChartBackgroundColor(backgroundColor);
        return (T)this;
    }

    public T xAxisTitle(String title) {
        this.displayerSettings.setXAxisShowLabels(true);
        this.displayerSettings.setXAxisTitle(title);
        return (T)this;
    }

    public T xAxisAngle(int angle) {
        this.displayerSettings.setXAxisLabelsAngle(angle);
        return (T)this;
    }

    public T yAxisTitle(String title) {
        this.displayerSettings.setYAxisShowLabels(true);
        this.displayerSettings.setYAxisTitle(title);
        return (T)this;
    }

    @Override
    public T renderer(String renderer) {
        this.displayerSettings.setRenderer(renderer);
        return (T)this;
    }

    @Override
    public T subtype(DisplayerSubType displayerSubType) {
        this.displayerSettings.setSubtype(displayerSubType);
        return (T)this;
    }

    @Override
    public T filterOn(boolean applySelf, boolean notifyOthers, boolean receiveFromOthers) {
        this.displayerSettings.setFilterEnabled(true);
        this.displayerSettings.setFilterSelfApplyEnabled(applySelf);
        this.displayerSettings.setFilterNotificationEnabled(notifyOthers);
        this.displayerSettings.setFilterListeningEnabled(receiveFromOthers);
        return (T)this;
    }

    @Override
    public T filterOff(boolean receiveFromOthers) {
        this.displayerSettings.setFilterEnabled(false);
        this.displayerSettings.setFilterListeningEnabled(receiveFromOthers);
        return (T)this;
    }

    @Override
    public T refreshOn() {
        this.displayerSettings.setRefreshInterval(-1);
        this.displayerSettings.setRefreshStaleData(true);
        return (T)this;
    }

    @Override
    public T refreshOn(int seconds, boolean staleData) {
        this.displayerSettings.setRefreshInterval(seconds);
        this.displayerSettings.setRefreshStaleData(staleData);
        return (T)this;
    }

    @Override
    public T refreshOff() {
        this.displayerSettings.setRefreshInterval(-1);
        return (T)this;
    }

    @Override
    public T format(String name) {
        return this.format(name, null);
    }

    @Override
    public T format(String name, String pattern) {
        DataSetOp op = this.getCurrentOp();
        if (op == null || !(op instanceof DataSetGroup)) {
            throw new RuntimeException("column(...) must be called first.");
        }
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        List columns = gOp.getGroupFunctions();
        if (columns.isEmpty()) {
            throw new RuntimeException("column(...) must be called first.");
        }
        GroupFunction lastColumn = (GroupFunction)columns.get(columns.size() - 1);
        return this.format(lastColumn.getColumnId(), name, pattern);
    }

    @Override
    public T format(String columnId, String name, String pattern) {
        this.displayerSettings.setColumnName(columnId, name);
        this.displayerSettings.setColumnValuePattern(columnId, pattern);
        return (T)this;
    }

    @Override
    public T expression(String expression) {
        DataSetOp op = this.getCurrentOp();
        if (op == null || !(op instanceof DataSetGroup)) {
            throw new RuntimeException("column(...) must be called first.");
        }
        DataSetGroup gOp = (DataSetGroup)this.getCurrentOp();
        List columns = gOp.getGroupFunctions();
        if (columns.isEmpty()) {
            throw new RuntimeException("column(...) must be called first.");
        }
        GroupFunction lastColumn = (GroupFunction)columns.get(columns.size() - 1);
        return this.expression(lastColumn.getColumnId(), expression);
    }

    @Override
    public T expression(String columnId, String expression) {
        this.displayerSettings.setColumnValueExpression(columnId, expression);
        return (T)this;
    }

    @Override
    public T htmlTemplate(String html) {
        this.displayerSettings.setHtmlTemplate(html);
        return (T)this;
    }

    @Override
    public T jsTemplate(String onDrawJs) {
        this.displayerSettings.setJsTemplate(onDrawJs);
        return (T)this;
    }

    @Override
    public DisplayerSettings buildSettings() {
        this.displayerSettings.setDataSetLookup(super.buildLookup());
        return this.displayerSettings;
    }
}

