/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.external;

import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.core.JsMap;
import java.util.Collections;
import java.util.Optional;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageHelper;
import org.dashbuilder.displayer.external.ExternalComponentMessageType;
import org.dashbuilder.displayer.external.ExternalDataSet;
import org.dashbuilder.displayer.external.ExternalFilterRequest;
import org.dashbuilder.displayer.external.FunctionCallRequest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExternalComponentMessageHelperTest {
    @Mock
    JsMap<String, Object> properties;
    @InjectMocks
    ExternalComponentMessage message;
    private static ExternalComponentMessageHelper helper;

    @BeforeClass
    public static void setup() {
        helper = new ExternalComponentMessageHelper();
    }

    @Test
    public void testWithId() {
        String id = "abc";
        helper.withId(this.message, id);
        ((JsMap)Mockito.verify(this.properties)).set(Matchers.eq((Object)"component_id"), Matchers.eq((Object)id));
    }

    @Test
    public void testFilterRequest() {
        Optional filterRequestOp = helper.filterRequest(this.message);
        Assert.assertFalse((boolean)filterRequestOp.isPresent());
        ExternalFilterRequest request = (ExternalFilterRequest)Mockito.mock(ExternalFilterRequest.class);
        Mockito.when((Object)this.properties.get(Matchers.eq((Object)"filter"))).thenReturn((Object)request);
        filterRequestOp = helper.filterRequest(this.message);
        Assert.assertEquals((Object)request, filterRequestOp.get());
    }

    @Test
    public void testFunctionCallRequest() {
        Optional functionCallRequestOp = helper.functionCallRequest(this.message);
        Assert.assertFalse((boolean)functionCallRequestOp.isPresent());
        FunctionCallRequest request = (FunctionCallRequest)Mockito.mock(FunctionCallRequest.class);
        Mockito.when((Object)this.properties.get(Matchers.eq((Object)"functionCallRequest"))).thenReturn((Object)request);
        functionCallRequestOp = helper.functionCallRequest(this.message);
        Assert.assertEquals((Object)request, functionCallRequestOp.get());
    }

    @Test
    public void testDataSetMessage() {
        ExternalDataSet ds = (ExternalDataSet)Mockito.mock(ExternalDataSet.class);
        ExternalComponentMessage newDataSetMessage = helper.newDataSetMessage(ds, Collections.emptyMap());
        Assert.assertEquals((Object)ExternalComponentMessageType.DATASET.name(), (Object)newDataSetMessage.type);
    }

    @Test
    public void testNewInitMessage() {
        ExternalComponentMessage initMessage = helper.newInitMessage(Collections.emptyMap());
        Assert.assertEquals((Object)ExternalComponentMessageType.INIT.name(), (Object)initMessage.type);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullMessageType() {
        ExternalComponentMessage message = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        Mockito.when((Object)message.getType()).thenReturn(null);
        helper.messageType(message);
    }
}

