/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.json;

import com.google.gwt.core.client.GWT;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.client.ClientDataSetValueFormatter;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;

public class DataSetLookupJSONMarshaller {
    private static final String UUID = "dataSetUuid";
    private static final String ROWCOUNT = "rowCount";
    private static final String ROWOFFSET = "rowOffset";
    private static final String COLUMNID = "columnId";
    private static final String SOURCEID = "sourceId";
    private static final String FILTEROPS = "filterOps";
    private static final String FUNCTION_TYPE = "functionType";
    private static final String FUNCTION_TERMS = "terms";
    private static final String GROUPOPS = "groupOps";
    private static final String COLUMNGROUP = "columnGroup";
    private static final String GROUPSTRATEGY = "groupStrategy";
    private static final String MAXINTERVALS = "maxIntervals";
    private static final String INTERVALSIZE = "intervalSize";
    private static final String EMPTYINTERVALS = "emptyIntervals";
    private static final String ASCENDING = "asc";
    private static final String FIRSTMONTHOFYEAR = "firstMonthOfYear";
    private static final String FIRSTDAYOFWEEK = "firstDayOfWeek";
    private static final String GROUPFUNCTIONS = "groupFunctions";
    private static final String FUNCTION = "function";
    private static final String SELECTEDINTERVALS = "selectedIntervals";
    private static final String JOIN = "join";
    private static final String SORTOPS = "sortOps";
    private static final String SORTORDER = "sortOrder";
    private List<String> coreFunctionTypes = new ArrayList<String>();
    private List<String> logicalFunctionTypes = new ArrayList<String>();
    private ClientDataSetValueFormatter valueFormatter = new ClientDataSetValueFormatter();

    public DataSetLookupJSONMarshaller() {
        for (LogicalExprType logicalExprType : LogicalExprType.values()) {
            this.logicalFunctionTypes.add(logicalExprType.toString());
        }
        for (LogicalExprType logicalExprType : CoreFunctionType.values()) {
            this.coreFunctionTypes.add(logicalExprType.toString());
        }
    }

    public JSONObject toJson(DataSetLookup dataSetLookup) {
        JSONObject json = new JSONObject();
        if (dataSetLookup != null) {
            List sortOps;
            List groupOps;
            String uuid = dataSetLookup.getDataSetUUID();
            if (!StringUtils.isBlank((String)uuid)) {
                json.put(UUID, (JSONValue)new JSONString(uuid));
            }
            json.put(ROWCOUNT, (JSONValue)new JSONString(Integer.toString(dataSetLookup.getNumberOfRows())));
            json.put(ROWOFFSET, (JSONValue)new JSONString(Integer.toString(dataSetLookup.getRowOffset())));
            List filterOps = dataSetLookup.getOperationList(DataSetFilter.class);
            if (!filterOps.isEmpty()) {
                json.put(FILTEROPS, (JSONValue)this.formatFilterOperations(filterOps));
            }
            if (!(groupOps = dataSetLookup.getOperationList(DataSetGroup.class)).isEmpty()) {
                json.put(GROUPOPS, (JSONValue)this.formatGroupOperations(groupOps));
            }
            if (!(sortOps = dataSetLookup.getOperationList(DataSetSort.class)).isEmpty()) {
                json.put(SORTOPS, (JSONValue)this.formatSortOperations(sortOps));
            }
        }
        return json;
    }

    private JSONArray formatFilterOperations(List<DataSetFilter> filterOps) {
        if (filterOps.size() == 0) {
            return null;
        }
        return this.formatColumnFilters(filterOps.get(0).getColumnFilterList());
    }

    private JSONArray formatColumnFilters(List<ColumnFilter> columnFilters) {
        JSONArray colFiltersJsonArray = new JSONArray();
        int colFilterCounter = 0;
        for (ColumnFilter columnFilter : columnFilters) {
            colFiltersJsonArray.set(colFilterCounter++, (JSONValue)this.formatColumnFilter(columnFilter));
        }
        return colFiltersJsonArray;
    }

    private JSONObject formatColumnFilter(ColumnFilter columnFilter) {
        if (columnFilter == null) {
            return null;
        }
        JSONObject colFilterJson = new JSONObject();
        if (columnFilter instanceof LogicalExprFilter) {
            LogicalExprFilter lef = (LogicalExprFilter)columnFilter;
            colFilterJson.put(COLUMNID, (JSONValue)new JSONString(lef.getColumnId()));
            colFilterJson.put(FUNCTION_TYPE, (JSONValue)new JSONString(lef.getLogicalOperator().toString()));
            colFilterJson.put(FUNCTION_TERMS, (JSONValue)this.formatColumnFilters(lef.getLogicalTerms()));
        } else if (columnFilter instanceof CoreFunctionFilter) {
            CoreFunctionFilter cff = (CoreFunctionFilter)columnFilter;
            colFilterJson.put(COLUMNID, (JSONValue)new JSONString(cff.getColumnId()));
            colFilterJson.put(FUNCTION_TYPE, (JSONValue)new JSONString(cff.getType().toString()));
            JSONArray paramsJsonArray = new JSONArray();
            int paramCounter = 0;
            for (Object param : cff.getParameters()) {
                String paramStr = this.valueFormatter.formatValue(param);
                paramsJsonArray.set(paramCounter++, (JSONValue)new JSONString(paramStr));
            }
            colFilterJson.put(FUNCTION_TERMS, (JSONValue)paramsJsonArray);
        } else {
            GWT.log((String)CommonConstants.INSTANCE.json_datasetlookup_unsupported_column_filter());
        }
        return colFilterJson;
    }

    private JSONArray formatGroupOperations(List<DataSetGroup> groupOps) {
        if (groupOps.size() == 0) {
            return null;
        }
        JSONArray groupOpsJsonArray = new JSONArray();
        int groupOpCounter = 0;
        for (DataSetGroup groupOp : groupOps) {
            groupOpsJsonArray.set(groupOpCounter++, (JSONValue)this.formatDataSetGroup(groupOp));
        }
        return groupOpsJsonArray;
    }

    private JSONObject formatDataSetGroup(DataSetGroup dataSetGroup) {
        if (dataSetGroup == null) {
            return null;
        }
        JSONObject dataSetGroupJson = new JSONObject();
        dataSetGroupJson.put(COLUMNGROUP, (JSONValue)this.formatColumnGroup(dataSetGroup.getColumnGroup()));
        dataSetGroupJson.put(GROUPFUNCTIONS, (JSONValue)this.formatgroupFunctions(dataSetGroup.getGroupFunctions()));
        dataSetGroupJson.put(SELECTEDINTERVALS, (JSONValue)this.formatSelectedIntervals(dataSetGroup.getSelectedIntervalList()));
        dataSetGroupJson.put(JOIN, (JSONValue)new JSONString(dataSetGroup.isJoin() ? "true" : "false"));
        return dataSetGroupJson;
    }

    private JSONObject formatColumnGroup(ColumnGroup columnGroup) {
        if (columnGroup == null) {
            return null;
        }
        JSONObject columnGroupJson = new JSONObject();
        columnGroupJson.put(SOURCEID, (JSONValue)(columnGroup.getSourceId() != null ? new JSONString(columnGroup.getSourceId()) : null));
        columnGroupJson.put(COLUMNID, (JSONValue)(columnGroup.getColumnId() != null ? new JSONString(columnGroup.getColumnId()) : null));
        columnGroupJson.put(GROUPSTRATEGY, (JSONValue)(columnGroup.getStrategy() != null ? new JSONString(columnGroup.getStrategy().toString()) : null));
        columnGroupJson.put(MAXINTERVALS, (JSONValue)new JSONString(Integer.toString(columnGroup.getMaxIntervals())));
        columnGroupJson.put(INTERVALSIZE, (JSONValue)(columnGroup.getIntervalSize() != null ? new JSONString(columnGroup.getIntervalSize()) : null));
        columnGroupJson.put(EMPTYINTERVALS, (JSONValue)new JSONString(columnGroup.areEmptyIntervalsAllowed() ? "true" : "false"));
        columnGroupJson.put(ASCENDING, (JSONValue)new JSONString(columnGroup.isAscendingOrder() ? "true" : "false"));
        columnGroupJson.put(FIRSTMONTHOFYEAR, (JSONValue)(columnGroup.getFirstMonthOfYear() != null ? new JSONString(columnGroup.getFirstMonthOfYear().toString()) : null));
        columnGroupJson.put(FIRSTDAYOFWEEK, (JSONValue)(columnGroup.getFirstDayOfWeek() != null ? new JSONString(columnGroup.getFirstDayOfWeek().toString()) : null));
        return columnGroupJson;
    }

    private JSONArray formatgroupFunctions(List<GroupFunction> groupFunctions) {
        if (groupFunctions.size() == 0) {
            return null;
        }
        JSONArray groupOpsJsonArray = new JSONArray();
        int groupFunctionCounter = 0;
        for (GroupFunction groupFunction : groupFunctions) {
            groupOpsJsonArray.set(groupFunctionCounter++, (JSONValue)this.formatGroupFunction(groupFunction));
        }
        return groupOpsJsonArray;
    }

    private JSONObject formatGroupFunction(GroupFunction groupFunction) {
        if (groupFunction == null) {
            return null;
        }
        JSONObject groupFunctionJson = new JSONObject();
        groupFunctionJson.put(SOURCEID, (JSONValue)(groupFunction.getSourceId() != null ? new JSONString(groupFunction.getSourceId()) : null));
        groupFunctionJson.put(COLUMNID, (JSONValue)(groupFunction.getColumnId() != null ? new JSONString(groupFunction.getColumnId()) : null));
        groupFunctionJson.put(FUNCTION, (JSONValue)(groupFunction.getFunction() != null ? new JSONString(groupFunction.getFunction().toString()) : null));
        return groupFunctionJson;
    }

    private JSONArray formatSelectedIntervals(List<Interval> selectedIntervalList) {
        if (selectedIntervalList.size() == 0) {
            return null;
        }
        JSONArray selectedIntervalNamesJsonArray = new JSONArray();
        int intervalNamesCounter = 0;
        for (Interval interval : selectedIntervalList) {
            selectedIntervalNamesJsonArray.set(intervalNamesCounter++, (JSONValue)new JSONString(interval.getName()));
        }
        return selectedIntervalNamesJsonArray;
    }

    private JSONArray formatSortOperations(List<DataSetSort> sortOps) {
        if (sortOps.size() == 0) {
            return null;
        }
        return this.formatColumnSorts(sortOps.get(0).getColumnSortList());
    }

    private JSONArray formatColumnSorts(List<ColumnSort> columnSorts) {
        if (columnSorts.size() == 0) {
            return null;
        }
        JSONArray columnSortsJsonArray = new JSONArray();
        int columnSortCounter = 0;
        for (ColumnSort columnSort : columnSorts) {
            columnSortsJsonArray.set(columnSortCounter++, (JSONValue)this.formatColumnSort(columnSort));
        }
        return columnSortsJsonArray;
    }

    private JSONObject formatColumnSort(ColumnSort columnSort) {
        if (columnSort == null) {
            return null;
        }
        JSONObject columnSortJson = new JSONObject();
        columnSortJson.put(COLUMNID, (JSONValue)(columnSort.getColumnId() != null ? new JSONString(columnSort.getColumnId()) : null));
        columnSortJson.put(SORTORDER, (JSONValue)(columnSort.getOrder() != null ? new JSONString(columnSort.getOrder().toString()) : null));
        return columnSortJson;
    }

    public DataSetLookup fromJson(String jsonString) {
        if (StringUtils.isBlank((String)jsonString)) {
            return null;
        }
        JSONObject dataSetLookupJson = JSONParser.parseStrict((String)jsonString).isObject();
        return this.fromJson(dataSetLookupJson);
    }

    public DataSetLookup fromJson(JSONObject json) {
        if (json == null) {
            return null;
        }
        DataSetLookup dataSetLookup = new DataSetLookup();
        dataSetLookup.setDataSetUUID(json.get(UUID) != null ? json.get(UUID).isString().stringValue() : null);
        dataSetLookup.setNumberOfRows(json.get(ROWCOUNT) != null ? Integer.parseInt(json.get(ROWCOUNT).isString().stringValue(), 10) : -1);
        dataSetLookup.setRowOffset(json.get(ROWOFFSET) != null ? Integer.parseInt(json.get(ROWOFFSET).isString().stringValue(), 10) : 0);
        List dataSetOpList = dataSetLookup.getOperationList();
        List<DataSetFilter> c = null;
        JSONValue array = json.get(FILTEROPS);
        c = this.parseFilterOperations(array != null ? array.isArray() : null);
        if (c != null) {
            dataSetOpList.addAll(c);
        }
        if ((c = this.parseGroupOperations((array = json.get(GROUPOPS)) != null ? array.isArray() : null)) != null) {
            dataSetOpList.addAll(c);
        }
        if ((c = this.parseSortOperations((array = json.get(SORTOPS)) != null ? array.isArray() : null)) != null) {
            dataSetOpList.addAll(c);
        }
        return dataSetLookup;
    }

    private List<DataSetFilter> parseFilterOperations(JSONArray columnFiltersJsonArray) {
        if (columnFiltersJsonArray == null) {
            return null;
        }
        ArrayList<DataSetFilter> dataSetFilters = new ArrayList<DataSetFilter>();
        DataSetFilter dataSetFilter = new DataSetFilter();
        dataSetFilters.add(dataSetFilter);
        List<ColumnFilter> columnFilters = this.parseColumnFilters(columnFiltersJsonArray);
        if (columnFilters != null) {
            dataSetFilter.getColumnFilterList().addAll(columnFilters);
        }
        return dataSetFilters;
    }

    private List<ColumnFilter> parseColumnFilters(JSONArray columnFiltersJsonArray) {
        if (columnFiltersJsonArray == null) {
            return null;
        }
        ArrayList<ColumnFilter> columnFilters = new ArrayList<ColumnFilter>(columnFiltersJsonArray.size());
        for (int i = 0; i < columnFiltersJsonArray.size(); ++i) {
            columnFilters.add(this.parseColumnFilter(columnFiltersJsonArray.get(i).isObject()));
        }
        return columnFilters;
    }

    private ColumnFilter parseColumnFilter(JSONObject columnFilterJson) {
        if (columnFilterJson == null) {
            return null;
        }
        String columnId = null;
        String functionType = null;
        JSONValue value = columnFilterJson.get(COLUMNID);
        if (this.checkNotNull(value, false, CommonConstants.INSTANCE.json_datasetlookup_columnfilter_null_columnid())) {
            String string = columnId = value.isString() != null ? value.isString().stringValue() : null;
        }
        if (this.checkNotNull(value = columnFilterJson.get(FUNCTION_TYPE), false, CommonConstants.INSTANCE.json_datasetlookup_columnfilter_null_functiontype())) {
            functionType = value.isString() != null ? value.isString().stringValue() : null;
        }
        value = columnFilterJson.get(FUNCTION_TERMS);
        if (this.isCoreFilter(functionType)) {
            CoreFunctionFilter cff = new CoreFunctionFilter();
            cff.setColumnId(columnId);
            cff.setType(CoreFunctionType.getByName((String)functionType));
            if (this.checkNotNull(value, false, CommonConstants.INSTANCE.json_datasetlookup_corefunction_null_params())) {
                cff.setParameters(this.parseCoreFunctionParameters(value.isArray()).toArray(new Comparable[0]));
            }
            return cff;
        }
        if (this.isLogicalFilter(functionType)) {
            LogicalExprFilter lef = new LogicalExprFilter();
            lef.setColumnId(columnId);
            lef.setLogicalOperator(LogicalExprType.getByName((String)functionType));
            if (this.checkNotNull(value, false, CommonConstants.INSTANCE.json_datasetlookup_logexpr_null_params())) {
                lef.setLogicalTerms(this.parseColumnFilters(value.isArray()));
            }
            return lef;
        }
        throw new RuntimeException(CommonConstants.INSTANCE.json_datasetlookup_columnfilter_wrong_type());
    }

    private List<Comparable> parseCoreFunctionParameters(JSONArray paramsJsonArray) {
        if (paramsJsonArray == null) {
            return null;
        }
        ArrayList<Comparable> params = new ArrayList<Comparable>(paramsJsonArray.size());
        for (int i = 0; i < paramsJsonArray.size(); ++i) {
            params.add((Comparable)((Object)paramsJsonArray.get(i).isString().stringValue()));
        }
        return params;
    }

    private List<DataSetGroup> parseGroupOperations(JSONArray groupOpsJsonArray) {
        if (groupOpsJsonArray == null) {
            return null;
        }
        ArrayList<DataSetGroup> dataSetGroups = new ArrayList<DataSetGroup>();
        for (int i = 0; i < groupOpsJsonArray.size(); ++i) {
            JSONObject dataSetGroupOpJson = groupOpsJsonArray.get(i).isObject();
            dataSetGroups.add(this.parseDataSetGroup(dataSetGroupOpJson));
        }
        return dataSetGroups;
    }

    private DataSetGroup parseDataSetGroup(JSONObject dataSetGroupJson) {
        List<GroupFunction> groupFunctions;
        if (dataSetGroupJson == null) {
            return null;
        }
        DataSetGroup dataSetGroup = new DataSetGroup();
        dataSetGroup.setColumnGroup(null);
        JSONValue value = dataSetGroupJson.get(COLUMNGROUP);
        if (value != null) {
            dataSetGroup.setColumnGroup(this.parseColumnGroup(value.isObject()));
        }
        if ((groupFunctions = this.parseGroupFunctions((value = dataSetGroupJson.get(GROUPFUNCTIONS)) != null ? value.isArray() : null)) != null) {
            dataSetGroup.getGroupFunctions().addAll(groupFunctions);
        }
        dataSetGroup.setSelectedIntervalList(null);
        value = dataSetGroupJson.get(SELECTEDINTERVALS);
        if (value != null) {
            dataSetGroup.setSelectedIntervalList(this.parseSelectedIntervals(value.isArray()));
        }
        dataSetGroup.setJoin(false);
        value = dataSetGroupJson.get(JOIN);
        if (value != null) {
            dataSetGroup.setJoin(Boolean.valueOf(value.isString().stringValue()).booleanValue());
        }
        return dataSetGroup;
    }

    private ColumnGroup parseColumnGroup(JSONObject columnGroupJson) {
        if (columnGroupJson == null) {
            return null;
        }
        ColumnGroup columnGroup = new ColumnGroup();
        JSONValue value = columnGroupJson.get(SOURCEID);
        columnGroup.setSourceId(value != null ? value.isString().stringValue() : null);
        value = columnGroupJson.get(COLUMNID);
        columnGroup.setColumnId(value != null ? value.isString().stringValue() : null);
        value = columnGroupJson.get(GROUPSTRATEGY);
        columnGroup.setStrategy(value != null ? GroupStrategy.getByName((String)value.isString().stringValue()) : null);
        value = columnGroupJson.get(MAXINTERVALS);
        columnGroup.setMaxIntervals(value != null ? Integer.parseInt(value.isString().stringValue()) : -1);
        value = columnGroupJson.get(INTERVALSIZE);
        columnGroup.setIntervalSize(value != null ? value.isString().stringValue() : null);
        value = columnGroupJson.get(EMPTYINTERVALS);
        columnGroup.setEmptyIntervalsAllowed(value != null ? Boolean.valueOf(value.isString().stringValue()) : false);
        value = columnGroupJson.get(ASCENDING);
        columnGroup.setAscendingOrder(value != null ? Boolean.valueOf(value.isString().stringValue()) : false);
        value = columnGroupJson.get(FIRSTMONTHOFYEAR);
        columnGroup.setFirstMonthOfYear(value != null ? Month.getByName((String)value.isString().stringValue()) : null);
        value = columnGroupJson.get(FIRSTDAYOFWEEK);
        columnGroup.setFirstDayOfWeek(value != null ? DayOfWeek.getByName((String)value.isString().stringValue()) : null);
        return columnGroup;
    }

    private List<GroupFunction> parseGroupFunctions(JSONArray groupFunctionsJson) {
        if (groupFunctionsJson == null) {
            return null;
        }
        ArrayList<GroupFunction> groupFunctions = new ArrayList<GroupFunction>(groupFunctionsJson.size());
        for (int i = 0; i < groupFunctionsJson.size(); ++i) {
            groupFunctions.add(this.parseGroupFunction(groupFunctionsJson.get(i).isObject()));
        }
        return groupFunctions;
    }

    private GroupFunction parseGroupFunction(JSONObject groupFunctionJson) {
        if (groupFunctionJson == null) {
            return null;
        }
        GroupFunction groupFunction = new GroupFunction();
        JSONValue value = groupFunctionJson.get(SOURCEID);
        groupFunction.setSourceId(value != null ? value.isString().stringValue() : null);
        value = groupFunctionJson.get(COLUMNID);
        groupFunction.setColumnId(value != null ? value.isString().stringValue() : null);
        value = groupFunctionJson.get(FUNCTION);
        groupFunction.setFunction(value != null ? AggregateFunctionType.getByName((String)value.isString().stringValue()) : null);
        return groupFunction;
    }

    private List<Interval> parseSelectedIntervals(JSONArray selectedIntervalsJson) {
        if (selectedIntervalsJson == null) {
            return null;
        }
        ArrayList<Interval> intervalList = new ArrayList<Interval>(selectedIntervalsJson.size());
        for (int i = 0; i < selectedIntervalsJson.size(); ++i) {
            JSONString value = selectedIntervalsJson.get(i).isString();
            if (value == null) continue;
            intervalList.add(new Interval(value.stringValue()));
        }
        return intervalList;
    }

    private List<DataSetSort> parseSortOperations(JSONArray columnSortsJsonArray) {
        if (columnSortsJsonArray == null) {
            return null;
        }
        ArrayList<DataSetSort> dataSetSorts = new ArrayList<DataSetSort>();
        DataSetSort dataSetSort = new DataSetSort();
        dataSetSorts.add(dataSetSort);
        List<ColumnSort> columnSorts = this.parseColumnSorts(columnSortsJsonArray);
        if (columnSorts != null) {
            dataSetSort.getColumnSortList().addAll(columnSorts);
        }
        return dataSetSorts;
    }

    private List<ColumnSort> parseColumnSorts(JSONArray columnSortsJsonArray) {
        if (columnSortsJsonArray == null) {
            return null;
        }
        ArrayList<ColumnSort> columnSorts = new ArrayList<ColumnSort>(columnSortsJsonArray.size());
        for (int i = 0; i < columnSortsJsonArray.size(); ++i) {
            columnSorts.add(this.parseColumnSort(columnSortsJsonArray.get(i).isObject()));
        }
        return columnSorts;
    }

    private ColumnSort parseColumnSort(JSONObject columnSortJson) {
        if (columnSortJson == null) {
            return null;
        }
        ColumnSort columnSort = new ColumnSort();
        JSONValue value = columnSortJson.get(COLUMNID);
        columnSort.setColumnId(value != null ? value.isString().stringValue() : null);
        value = columnSortJson.get(SORTORDER);
        columnSort.setOrder(value != null ? SortOrder.getByName((String)value.isString().stringValue()) : null);
        return columnSort;
    }

    private boolean isLogicalFilter(String functionType) {
        return this.logicalFunctionTypes.contains(functionType);
    }

    private boolean isCoreFilter(String functionType) {
        return this.coreFunctionTypes.contains(functionType);
    }

    private boolean checkNotNull(JSONValue value, boolean nullable, String errorMessage) {
        if (nullable) {
            return value != null;
        }
        if (value != null) {
            return true;
        }
        throw new RuntimeException(CommonConstants.INSTANCE.json_datasetlookup_validation_error() + (!StringUtils.isBlank((String)errorMessage) ? errorMessage : ""));
    }
}

