/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditorView;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.dashbuilder.displayer.client.widgets.group.DataSetGroupDateEditor;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DataSetLookupEditor
implements IsWidget,
DataSetFilterEditor.Listener,
DataSetGroupDateEditor.Listener {
    Listener listener;
    View view;
    DataSetClientServices clientServices;
    DataSet dataSet = null;
    DataSetLookup dataSetLookup = null;
    DataSetLookupConstraints lookupConstraints = null;
    DataSetMetadata dataSetMetadata = null;

    public DataSetLookupEditor() {
        this.view = new DataSetLookupEditorView();
        this.clientServices = DataSetClientServices.get();
    }

    @Inject
    public DataSetLookupEditor(DataSetLookupEditorView view, DataSetClientServices clientServices) {
        this.view = view;
        this.clientServices = clientServices;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void init(Listener listener) {
        this.listener = listener;
        this.dataSetLookup = null;
        this.lookupConstraints = null;
        this.dataSetMetadata = null;
        this.view.init(this);
        this.clientServices.getPublicDataSetDefs((RemoteCallback)new RemoteCallback<List<DataSetDef>>(){

            public void callback(List<DataSetDef> dataSetDefs) {
                DataSetLookupEditor.this.view.showDataSetDefs(dataSetDefs);
            }
        });
    }

    public void init(Listener listener, DataSetLookup dataSetLookup, DataSetLookupConstraints constraints, DataSetMetadata metadata) {
        this.listener = listener;
        this.dataSetLookup = dataSetLookup;
        this.lookupConstraints = constraints;
        this.dataSetMetadata = metadata;
        this.view.init(this);
        this.clientServices.getPublicDataSetDefs((RemoteCallback)new RemoteCallback<List<DataSetDef>>(){

            public void callback(List<DataSetDef> dataSetDefs) {
                DataSetLookupEditor.this.view.showDataSetDefs(dataSetDefs);
                DataSetLookupEditor.this.view.updateDataSetLookup();
            }
        });
    }

    public View getView() {
        return this.view;
    }

    public DataSetLookup getDataSetLookup() {
        return this.dataSetLookup;
    }

    public DataSetLookupConstraints getConstraints() {
        return this.lookupConstraints;
    }

    public DataSetMetadata getDataSetMetadata() {
        return this.dataSetMetadata;
    }

    public String getDataSetUUID() {
        if (this.dataSetLookup == null) {
            return null;
        }
        return this.dataSetLookup.getDataSetUUID();
    }

    public String getColumnId(int index) {
        return this.dataSetMetadata.getColumnId(index);
    }

    public ColumnType getColumnType(int index) {
        return this.dataSetMetadata.getColumnType(index);
    }

    public ColumnType getColumnType(String columnId) {
        if (columnId == null) {
            return null;
        }
        return this.dataSetMetadata.getColumnType(columnId);
    }

    public DataSetGroup getFirstGroupOp() {
        List groupOpList = this.dataSetLookup.getOperationList(DataSetGroup.class);
        if (groupOpList.isEmpty()) {
            return null;
        }
        return (DataSetGroup)groupOpList.get(0);
    }

    public boolean isFirstGroupOpDateBased() {
        DataSetGroup first = this.getFirstGroupOp();
        if (first == null) {
            return false;
        }
        ColumnGroup cg = first.getColumnGroup();
        if (cg == null) {
            return false;
        }
        ColumnType type = this.getColumnType(cg.getSourceId());
        return ColumnType.DATE.equals((Object)type);
    }

    public List<GroupFunction> getFirstGroupFunctions() {
        List groupOpList = this.dataSetLookup.getOperationList(DataSetGroup.class);
        if (groupOpList.isEmpty()) {
            return null;
        }
        return ((DataSetGroup)groupOpList.get(0)).getGroupFunctions();
    }

    public String getFirstGroupColumnId() {
        List groupOpList = this.dataSetLookup.getOperationList(DataSetGroup.class);
        if (groupOpList.isEmpty()) {
            return null;
        }
        DataSetGroup groupOp = (DataSetGroup)groupOpList.get(0);
        if (groupOp.getColumnGroup() == null) {
            return null;
        }
        return groupOp.getColumnGroup().getSourceId();
    }

    public List<Integer> getAvailableGroupColumnIdxs() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.dataSetMetadata.getNumberOfColumns(); ++i) {
            ColumnType columnType = this.dataSetMetadata.getColumnType(i);
            if (!ColumnType.LABEL.equals((Object)columnType) && !ColumnType.DATE.equals((Object)columnType)) continue;
            result.add(i);
        }
        return result;
    }

    public void changeDataSet(String uuid) {
        if (this.listener != null) {
            this.listener.dataSetChanged(uuid);
        }
    }

    public void createGroupColumn(String columnId) {
        DataSetGroup groupOp = new DataSetGroup();
        groupOp.getColumnGroup().setSourceId(columnId);
        groupOp.getColumnGroup().setColumnId(columnId);
        this.dataSetLookup.addOperation(new DataSetOp[]{groupOp});
        if (this.listener != null) {
            this.listener.groupChanged(groupOp);
        }
    }

    public void changeGroupColumn(ColumnGroup columnGroup) {
        DataSetGroup groupOp = this.getFirstGroupOp();
        if (groupOp != null) {
            groupOp.setColumnGroup(columnGroup);
            if (this.listener != null) {
                this.listener.groupChanged(groupOp);
            }
        }
    }

    public void changeGroupColumn(String columnId) {
        DataSetGroup groupOp = this.getFirstGroupOp();
        if (groupOp != null) {
            if (columnId == null) {
                groupOp.setColumnGroup(null);
                if (this.lookupConstraints.isGroupColumn()) {
                    groupOp.getGroupFunctions().remove(0);
                }
                if (!this.lookupConstraints.isFunctionRequired()) {
                    for (GroupFunction groupFunction : groupOp.getGroupFunctions()) {
                        groupFunction.setFunction(null);
                    }
                }
            } else {
                groupOp.setColumnGroup(new ColumnGroup(columnId, columnId));
                if (this.lookupConstraints.isGroupColumn()) {
                    if (groupOp.getGroupFunctions().size() == 1) {
                        GroupFunction groupFunction = new GroupFunction(groupOp.getColumnGroup().getSourceId(), null, null);
                        groupOp.getGroupFunctions().add(0, groupFunction);
                    } else {
                        GroupFunction groupFunction = (GroupFunction)groupOp.getGroupFunctions().get(0);
                        groupFunction.setSourceId(groupOp.getColumnGroup().getSourceId());
                        groupFunction.setColumnId(null);
                        groupFunction.setFunction(null);
                    }
                }
            }
            if (this.listener != null) {
                this.listener.groupChanged(groupOp);
            }
        }
    }

    protected int getGroupFunctionLastIdx(List<GroupFunction> groupFunctions, String sourceId) {
        int last = -1;
        for (GroupFunction gf : groupFunctions) {
            if (!gf.getSourceId().equals(sourceId)) continue;
            int idx = this.getGroupFunctionColumnIdx(gf.getColumnId());
            if (last != -1 && last >= idx) continue;
            last = idx;
        }
        return last;
    }

    protected int getGroupFunctionColumnIdx(String columnId) {
        int sep = columnId.lastIndexOf(95);
        if (sep != -1) {
            try {
                String str = columnId.substring(sep + 1);
                return Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    protected String nextGroupFunctionColumnId(String sourceId, AggregateFunctionType function) {
        int lastIdx = this.getGroupFunctionLastIdx(this.getFirstGroupFunctions(), sourceId);
        String next = sourceId;
        if (function != null) {
            next = next + "_" + function.name().toLowerCase();
        }
        if (lastIdx != -1) {
            next = next + "_" + ++lastIdx;
        }
        return next;
    }

    public void changeGroupFunction(GroupFunction groupFunction, String sourceId, AggregateFunctionType function) {
        groupFunction.setFunction(null);
        if (function != null) {
            ColumnType columnType = this.getColumnType(sourceId);
            if (function.supportType(columnType)) {
                groupFunction.setFunction(function);
            } else {
                for (AggregateFunctionType functionType : AggregateFunctionType.values()) {
                    if (!functionType.supportType(columnType)) continue;
                    groupFunction.setFunction(functionType);
                    break;
                }
            }
        }
        if (!sourceId.equals(groupFunction.getSourceId())) {
            String newColumnId = this.nextGroupFunctionColumnId(sourceId, groupFunction.getFunction());
            groupFunction.setSourceId(sourceId);
            groupFunction.setColumnId(newColumnId);
        }
        if (this.listener != null) {
            this.listener.columnChanged(groupFunction);
        }
    }

    public void changeDataSetFilter(DataSetFilter filterOp) {
        this.dataSetLookup.removeOperations(DataSetOpType.FILTER);
        if (filterOp != null) {
            this.dataSetLookup.addOperation(0, new DataSetOp[]{filterOp});
        }
        if (this.listener != null) {
            this.listener.filterChanged(filterOp);
        }
    }

    public void addGroupFunction() {
        if (this.lookupConstraints.areExtraColumnsAllowed()) {
            DataSetGroup op = this.getFirstGroupOp();
            List functionList = op.getGroupFunctions();
            GroupFunction last = (GroupFunction)functionList.get(functionList.size() - 1);
            GroupFunction clone = last.cloneInstance();
            String newColumnId = this.nextGroupFunctionColumnId(last.getSourceId(), last.getFunction());
            clone.setColumnId(newColumnId);
            functionList.add(clone);
            if (this.listener != null) {
                this.listener.groupChanged(op);
            }
        }
    }

    public void removeGroupFunction(int columnIdx) {
        DataSetGroup op = this.getFirstGroupOp();
        op.getGroupFunctions().remove(columnIdx);
        if (this.listener != null) {
            this.listener.groupChanged(op);
        }
    }

    @Override
    public void filterChanged(DataSetFilter filter) {
        this.changeDataSetFilter(filter);
    }

    @Override
    public void columnGroupChanged(ColumnGroup columnGroup) {
        this.changeGroupColumn(columnGroup);
    }

    private void onDataSetDefRegisteredEvent(@Observes DataSetDefRegisteredEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.view.addDataSetDef(event.getDataSetDef());
    }

    private void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.view.removeDataSetDef(event.getOldDataSetDef());
        this.view.addDataSetDef(event.getNewDataSetDef());
    }

    private void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.view.removeDataSetDef(event.getDataSetDef());
    }

    public static interface View
    extends IsWidget {
        public void init(DataSetLookupEditor var1);

        public void updateDataSetLookup();

        public void showDataSetDefs(List<DataSetDef> var1);

        public void addDataSetDef(DataSetDef var1);

        public void removeDataSetDef(DataSetDef var1);

        public void errorOnInit(Exception var1);

        public void errorDataSetNotFound(String var1);
    }

    public static interface Listener {
        public void dataSetChanged(String var1);

        public void columnChanged(GroupFunction var1);

        public void groupChanged(DataSetGroup var1);

        public void filterChanged(DataSetFilter var1);
    }
}

