/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerTypeLiterals;
import org.dashbuilder.displayer.client.widgets.DisplayerSubtypeSelector;

@Dependent
public class DisplayerTypeSelector
extends Composite
implements DisplayerSubtypeSelector.SubTypeChangeListener {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    Listener listener = null;
    DisplayerType selectedType = DisplayerType.BARCHART;
    DisplayerSubType selectedSubType = null;
    List<DisplayerTab> tabList = new ArrayList<DisplayerTab>();
    @UiField(provided=true)
    TabPanel displayerTypePanel;
    @UiField
    VerticalPanel displayerSubtypePanel;
    private DisplayerSubtypeSelector subtypeSelector;

    protected void initWidget() {
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_bar(), DisplayerType.BARCHART));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_pie(), DisplayerType.PIECHART));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_line(), DisplayerType.LINECHART));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_area(), DisplayerType.AREACHART));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_bubble(), DisplayerType.BUBBLECHART));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_meter(), DisplayerType.METERCHART));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_metric(), DisplayerType.METRIC));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_map(), DisplayerType.MAP));
        this.tabList.add(new DisplayerTab(DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_table(), DisplayerType.TABLE));
        this.displayerTypePanel = new TabPanel(Bootstrap.Tabs.LEFT);
        this.displayerTypePanel.getElement().setId("dispTypes");
        for (DisplayerTab tab : this.tabList) {
            this.displayerTypePanel.add((IsWidget)tab);
        }
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.subtypeSelector = new DisplayerSubtypeSelector(this);
        this.displayerSubtypePanel.add((Widget)this.subtypeSelector);
        this.displayerSubtypePanel.getElement().setId("dispSubtypes");
    }

    public void init(Listener listener) {
        this.listener = listener;
        if (this.displayerTypePanel == null) {
            this.initWidget();
        }
        this.draw();
    }

    protected void draw() {
        this.displayerTypePanel.clear();
        for (int i = 0; i < this.tabList.size(); ++i) {
            DisplayerTab tab = this.tabList.get(i);
            tab.setActive(false);
            this.displayerTypePanel.add((IsWidget)tab);
            if (!tab.type.equals((Object)this.selectedType)) continue;
            tab.setActive(true);
            this.displayerTypePanel.selectTab(i);
        }
    }

    public void select(String renderer, DisplayerType type, DisplayerSubType subtype) {
        this.selectedType = type;
        this.selectedSubType = subtype;
        this.subtypeSelector.select(renderer, type, subtype);
        this.draw();
    }

    @Override
    public void displayerSubtypeChanged(DisplayerSubType displayerSubType) {
        if (displayerSubType != this.selectedSubType) {
            this.selectedSubType = displayerSubType;
            this.listener.displayerTypeChanged(this.selectedType, displayerSubType);
        }
    }

    private class DisplayerTab
    extends Tab {
        String name;
        DisplayerType type;

        public DisplayerTab(String name, final DisplayerType type) {
            super.setHeading(name);
            this.name = name;
            this.type = type;
            super.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                    boolean change = !DisplayerTypeSelector.this.selectedType.equals((Object)type);
                    DisplayerTypeSelector.this.selectedType = type;
                    if (change && DisplayerTypeSelector.this.listener != null) {
                        DisplayerTypeSelector.this.listener.displayerTypeChanged(type, null);
                    }
                }
            });
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, DisplayerTypeSelector> {
    }

    public static interface Listener {
        public void displayerTypeChanged(DisplayerType var1, DisplayerSubType var2);
    }
}

