/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.InputAddOn;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.client.resources.i18n.DateIntervalTypeConstants;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.uberfire.ext.widgets.common.client.common.NumericLongTextBox;

@Dependent
public class TimeAmountEditor
extends Composite {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    Listener listener = null;
    TimeAmount timeAmount = null;
    @UiField
    NumericLongTextBox input;
    @UiField
    InputAddOn inputAddOn;
    @UiField
    ListBox typeList;
    static List<DateIntervalType> ALLOWED_SIZES = Arrays.asList(DateIntervalType.SECOND, DateIntervalType.MINUTE, DateIntervalType.HOUR, DateIntervalType.DAY, DateIntervalType.WEEK, DateIntervalType.MONTH, DateIntervalType.QUARTER, DateIntervalType.YEAR, DateIntervalType.CENTURY);

    public TimeAmountEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        Icon plusIcon = new Icon(IconType.PLUS);
        Icon minusIcon = new Icon(IconType.MINUS);
        plusIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                TimeAmountEditor.this.increaseQuantity();
            }
        }, ClickEvent.getType());
        minusIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                TimeAmountEditor.this.decreaseQuantity();
            }
        }, ClickEvent.getType());
        this.inputAddOn.addPrependWidget((IsWidget)minusIcon);
        this.inputAddOn.addAppendWidget((IsWidget)plusIcon);
    }

    public void init(TimeAmount amount, Listener listener) {
        this.listener = listener;
        this.timeAmount = amount;
        this.initListBox();
        if (this.timeAmount == null) {
            this.input.setValue("0");
        } else {
            this.input.setValue(Long.toString(this.timeAmount.getQuantity()));
        }
        this.input.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (StringUtils.isBlank((String)((String)event.getValue()))) {
                    TimeAmountEditor.this.changeQuantity(0L);
                } else {
                    TimeAmountEditor.this.changeQuantity(Long.parseLong((String)event.getValue()));
                }
            }
        });
    }

    protected void initListBox() {
        this.typeList.clear();
        for (int i = 0; i < ALLOWED_SIZES.size(); ++i) {
            DateIntervalType type = ALLOWED_SIZES.get(i);
            this.typeList.addItem(DateIntervalTypeConstants.INSTANCE.getString(type.name()));
            if (this.timeAmount == null || !this.timeAmount.getType().equals((Object)type)) continue;
            this.typeList.setSelectedIndex(i);
        }
    }

    protected void increaseQuantity() {
        this.changeQuantity(this.getQuantity() + 1L);
        this.input.setValue(Long.toString(this.getQuantity()));
    }

    protected void decreaseQuantity() {
        this.changeQuantity(this.getQuantity() - 1L);
        this.input.setValue(Long.toString(this.getQuantity()));
    }

    protected long getQuantity() {
        if (this.timeAmount == null) {
            return 0L;
        }
        return this.timeAmount.getQuantity();
    }

    protected void changeQuantity(long q) {
        if (this.timeAmount == null) {
            this.timeAmount = new TimeAmount();
            int selectedIdx = this.typeList.getSelectedIndex();
            DateIntervalType type = ALLOWED_SIZES.get(selectedIdx);
            this.timeAmount.setType(type);
        }
        this.timeAmount.setQuantity(q);
        this.listener.valueChanged(this.timeAmount);
    }

    @UiHandler(value={"typeList"})
    public void onFilterSelected(ChangeEvent changeEvent) {
        int selectedIdx = this.typeList.getSelectedIndex();
        DateIntervalType type = ALLOWED_SIZES.get(selectedIdx);
        if (this.timeAmount != null) {
            this.timeAmount.setType(type);
            this.listener.valueChanged(this.timeAmount);
        }
    }

    static interface Binder
    extends UiBinder<Widget, TimeAmountEditor> {
    }

    static interface Listener {
        public void valueChanged(TimeAmount var1);
    }
}

