/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.group;

import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.resources.i18n.AggregateFunctionTypeConstants;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.client.widgets.group.ColumnDetailsEditor;

@Dependent
public class ColumnFunctionEditor
extends Composite
implements ColumnDetailsEditor.Listener {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    Listener listener = null;
    GroupFunction column = null;
    ColumnType targetType = null;
    DataSetMetadata metadata = null;
    @UiField
    ListBox columnListBox;
    @UiField
    ListBox functionListBox;
    @UiField
    Icon columnDeleteIcon;
    @UiField
    Icon columnExpandIcon;
    @UiField
    Panel columnDetailsPanel;
    @UiField
    ColumnDetailsEditor columnDetailsEditor;

    public ColumnFunctionEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.columnExpandIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnFunctionEditor.this.expandOrCollapse();
            }
        }, ClickEvent.getType());
        this.columnDeleteIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnFunctionEditor.this.delete();
            }
        }, ClickEvent.getType());
    }

    public void init(DataSetMetadata metadata, GroupFunction groupFunction, ColumnType targetType, String columnTitle, boolean functionsEnabled, boolean canDelete, Listener listener) {
        this.column = groupFunction;
        this.targetType = targetType;
        this.listener = listener;
        this.metadata = metadata;
        this.columnExpandIcon.setType(IconType.ARROW_DOWN);
        this.columnDeleteIcon.setVisible(canDelete);
        this.columnListBox.setTitle(columnTitle);
        this.initColumnListBox();
        if (functionsEnabled && (targetType == null || this.isColumnNumeric())) {
            this.columnListBox.setWidth("120px");
            this.functionListBox.setVisible(true);
            this.initFunctionListBox();
        } else {
            this.columnListBox.setWidth("200px");
            this.functionListBox.setVisible(false);
        }
    }

    public void expand() {
        this.columnExpandIcon.setType(IconType.ARROW_UP);
        this.columnDetailsPanel.setVisible(true);
        this.columnDetailsEditor.init(this.metadata, this.column, this);
    }

    public void collapse() {
        this.columnDetailsPanel.setVisible(false);
        this.columnExpandIcon.setType(IconType.ARROW_DOWN);
    }

    public void expandOrCollapse() {
        if (this.columnDetailsPanel.isVisible()) {
            this.collapse();
        } else {
            this.expand();
        }
    }

    public void delete() {
        this.listener.columnDeleted(this);
    }

    public String getSourceId() {
        return this.columnListBox.getValue(this.columnListBox.getSelectedIndex());
    }

    public String getColumnId() {
        return this.columnDetailsEditor.getNewColumnId();
    }

    public AggregateFunctionType getFunction() {
        int idx = this.functionListBox.getSelectedIndex();
        if (!this.isColumnNumeric()) {
            --idx;
        }
        if (idx < 0) {
            return null;
        }
        return this.getSupportedFunctions().get(idx);
    }

    @UiHandler(value={"columnListBox"})
    public void onColumnSelected(ChangeEvent changeEvent) {
        this.listener.columnChanged(this);
    }

    @UiHandler(value={"functionListBox"})
    public void onFunctionSelected(ChangeEvent changeEvent) {
        this.listener.columnChanged(this);
    }

    @Override
    public void columnChanged(ColumnDetailsEditor editor) {
        this.listener.columnChanged(this);
    }

    protected boolean isColumnNumeric() {
        return this.targetType != null && this.targetType.equals((Object)ColumnType.NUMBER);
    }

    protected void initColumnListBox() {
        this.columnListBox.clear();
        for (int i = 0; i < this.metadata.getNumberOfColumns(); ++i) {
            String columnId = this.metadata.getColumnId(i);
            ColumnType columnType = this.metadata.getColumnType(i);
            if (this.targetType != null && columnType != null && !this.isColumnNumeric() && !this.targetType.equals((Object)columnType)) continue;
            this.columnListBox.addItem(columnId, columnId);
            if (columnId == null || !columnId.equals(this.column.getSourceId())) continue;
            this.columnListBox.setSelectedIndex(i);
        }
    }

    protected void initFunctionListBox() {
        this.functionListBox.clear();
        if (!this.isColumnNumeric()) {
            this.functionListBox.addItem("---");
        }
        AggregateFunctionType selected = this.column.getFunction();
        for (AggregateFunctionType functionType : this.getSupportedFunctions()) {
            String functionName = AggregateFunctionTypeConstants.INSTANCE.getString(functionType.name());
            this.functionListBox.addItem(functionName);
            if (selected == null || !functionType.equals((Object)selected)) continue;
            this.functionListBox.setSelectedValue(functionName);
        }
    }

    protected List<AggregateFunctionType> getSupportedFunctions() {
        ColumnType targetType = this.metadata.getColumnType(this.column.getSourceId());
        ArrayList<AggregateFunctionType> result = new ArrayList<AggregateFunctionType>();
        for (AggregateFunctionType function : AggregateFunctionType.values()) {
            if (!function.supportType(targetType)) continue;
            result.add(function);
        }
        return result;
    }

    static interface Binder
    extends UiBinder<Widget, ColumnFunctionEditor> {
    }

    public static interface Listener {
        public void columnChanged(ColumnFunctionEditor var1);

        public void columnDeleted(ColumnFunctionEditor var1);
    }
}

