/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.prototypes;

import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;

@ApplicationScoped
public class DataSetPrototypes {
    public static final String CITY = "City / Urban area";
    public static final String COUNTRY = "Country";
    public static final String GDP_2014 = "GDP 2014";
    public static final String GDP_2013 = "GDP 2013";
    public static final String CONTINENT = "Continent";
    public static final String AREA_SIZE = "Area size (km2)";
    public static final String DENSITY = "Density (people / km2)";
    public static final String REGION = "Region";
    public static final String POPULATION = "Population";
    @Inject
    ClientDataSetManager dataSetManager;

    public static DataSetPrototypes get() {
        Collection beans = IOC.getBeanManager().lookupBeans(DataSetPrototypes.class);
        IOCBeanDef beanDef = (IOCBeanDef)beans.iterator().next();
        return (DataSetPrototypes)beanDef.getInstance();
    }

    public DataSet getWorldPopulation() {
        return this.dataSetManager.getDataSet("worldPopulation");
    }

    public DataSet getTotalPopulation() {
        return this.dataSetManager.getDataSet("totalPopulation");
    }

    public DataSet getCountryPopulation() {
        return this.dataSetManager.getDataSet("countryPopulation");
    }

    public DataSet getTopRichCountries() {
        return this.dataSetManager.getDataSet("topRichCountries");
    }

    public DataSet getContinentPopulation() {
        return this.dataSetManager.getDataSet("continentPopulation");
    }

    public DataSet getContinentPopulationExt() {
        return this.dataSetManager.getDataSet("continentPopulationExt");
    }

    @PostConstruct
    private void init() {
        this.dataSetManager.registerDataSet(DataSetFactory.newDataSetBuilder().uuid("topRichCountries").label(COUNTRY).number(GDP_2013).number(GDP_2014).row(new Object[]{"United States", 16768100L, 17418925L}).row(new Object[]{"China", 9240270L, 1038080L}).row(new Object[]{"Japan", 4919563L, 4616335L}).row(new Object[]{"Germany", 3730261L, 3859547L}).row(new Object[]{"United Kingdom", 2678455L, 2945146L}).row(new Object[]{"France", 2806428L, 2846889L}).row(new Object[]{"Brazil", 0x224429L, 2353025L}).buildDataSet());
        this.dataSetManager.registerDataSet(DataSetFactory.newDataSetBuilder().uuid("continentPopulation").label(CONTINENT).number(POPULATION).row(new Object[]{"Asia", 4298723000L}).row(new Object[]{"Africa", 1110635000L}).row(new Object[]{"North America", 972005000L}).row(new Object[]{"South America", 972005000L}).row(new Object[]{"Europe", 742452000L}).row(new Object[]{"Oceania", 38304000L}).buildDataSet());
        this.dataSetManager.registerDataSet(DataSetFactory.newDataSetBuilder().uuid("totalPopulation").number(POPULATION).row(new Object[]{42987L}).buildDataSet());
        this.dataSetManager.registerDataSet(DataSetFactory.newDataSetBuilder().uuid("continentPopulationExt").label(CONTINENT).number(AREA_SIZE).number(DENSITY).label(REGION).number(POPULATION).row(new Object[]{"Asia", 43820000L, 95.0, "Asia", 4298723000L}).row(new Object[]{"Africa", 30370000L, 33.7, "Africa", 1110635000L}).row(new Object[]{"North America", 24490000L, 22.1, "North America", 972005000L}).row(new Object[]{"South America", 17840000L, 22.0, "South America", 972005000L}).row(new Object[]{"Europe", 10180000L, 72.5, "Europe", 742452000L}).row(new Object[]{"Oceania", 9008500L, 3.2, "Oceania", 38304000L}).buildDataSet());
        this.dataSetManager.registerDataSet(DataSetFactory.newDataSetBuilder().uuid("worldPopulation").label(CITY).label(COUNTRY).number(POPULATION).number(AREA_SIZE).number(DENSITY).row(new Object[]{"Tokyo/Yokohama", "Japan", 33200000L, 6993L, 4750L}).row(new Object[]{"New York Metro", "USA", 17800000L, 8683L, 2050L}).row(new Object[]{"Sao Paulo", "Brazil", 17700000L, 1968L, 9000L}).row(new Object[]{"Seoul/Incheon", "South Korea", 17500000L, 1049L, 16700L}).row(new Object[]{"Mexico City", "Mexico", 17400000L, 2072L, 8400L}).row(new Object[]{"Osaka/Kobe/Kyoto", "Japan", 16425000L, 2564L, 6400L}).row(new Object[]{"Manila", "Philippines", 14750000L, 1399L, 10550L}).row(new Object[]{"Mumbai", "India", 14350000L, 484L, 29650L}).row(new Object[]{"Delhi", "India", 14300000L, 1295L, 11050L}).row(new Object[]{"Jakarta", "Indonesia", 14250000L, 1360L, 10500L}).row(new Object[]{"Lagos", "Nigeria", 0xCC77C0L, 738L, 18150L}).row(new Object[]{"Kolkata", "India", 12700000L, 531L, 23900L}).row(new Object[]{"Cairo", "Egypt", 12200000L, 1295L, 9400L}).row(new Object[]{"Los Angeles", "USA", 11789000L, 4320L, 2750L}).row(new Object[]{"Buenos Aires", "Argentina", 11200000L, 2266L, 4950L}).row(new Object[]{"Rio de Janeiro", "Brazil", 10800000L, 1580L, 6850L}).row(new Object[]{"Moscow", "Russia", 10500000L, 2150L, 4900L}).row(new Object[]{"Shanghai", "China", 10000000L, 746L, 13400L}).row(new Object[]{"Karachi", "Pakistan", 9800000L, 518L, 18900L}).row(new Object[]{"Paris", "France", 9645000L, 2723L, 3550L}).row(new Object[]{"Istanbul", "Turkey", 9000000L, 1166L, 7700L}).row(new Object[]{"Nagoya", "Japan", 9000000L, 2875L, 3150L}).row(new Object[]{"Beijing", "China", 8614000L, 748L, 11500L}).row(new Object[]{"Chicago", "USA", 8308000L, 5498L, 1500L}).row(new Object[]{"London", "UK", 8278000L, 1623L, 5100L}).row(new Object[]{"Shenzhen", "China", 8000000L, 466L, 17150L}).row(new Object[]{"Essen/D\ufffdsseldorf", "Germany", 7350000L, 2642L, 2800L}).row(new Object[]{"Tehran", "Iran", 7250000L, 686L, 10550L}).row(new Object[]{"Bogota", "Colombia", 7000000L, 518L, 13500L}).row(new Object[]{"Lima", "Peru", 7000000L, 596L, 11750L}).row(new Object[]{"Bangkok", "Thailand", 6500000L, 1010L, 6450L}).row(new Object[]{"Johannesburg/East Rand", "South Africa", 6000000L, 2396L, 2500L}).row(new Object[]{"Chennai", "India", 5950000L, 414L, 14350L}).row(new Object[]{"Taipei", "Taiwan", 5700000L, 376L, 15200L}).row(new Object[]{"Baghdad", "Iraq", 5500000L, 596L, 9250L}).row(new Object[]{"Santiago", "Chile", 5425000L, 648L, 8400L}).row(new Object[]{"Bangalore", "India", 5400000L, 534L, 10100L}).row(new Object[]{"Hyderabad", "India", 5300000L, 583L, 9100L}).row(new Object[]{"St Petersburg", "Russia", 5300000L, 622L, 8550L}).row(new Object[]{"Philadelphia", "USA", 5149000L, 4661L, 1100L}).row(new Object[]{"Lahore", "Pakistan", 5100000L, 622L, 8200L}).row(new Object[]{"Kinshasa", "Congo", 5000000L, 469L, 10650L}).row(new Object[]{"Miami", "USA", 4919000L, 2891L, 1700L}).row(new Object[]{"Ho Chi Minh City", "Vietnam", 4900000L, 518L, 9450L}).row(new Object[]{"Madrid", "Spain", 4900000L, 945L, 5200L}).row(new Object[]{"Tianjin", "China", 4750000L, 453L, 10500L}).row(new Object[]{"Kuala Lumpur", "Malaysia", 4400000L, 1606L, 2750L}).row(new Object[]{"Toronto", "Canada", 4367000L, 1655L, 2650L}).row(new Object[]{"Milan", "Italy", 4250000L, 1554L, 2750L}).row(new Object[]{"Shenyang", "China", 4200000L, 453L, 9250L}).row(new Object[]{"Dallas/Fort Worth", "USA", 4146000L, 3644L, 1150L}).row(new Object[]{"Boston", "USA", 4032000L, 4497L, 900L}).row(new Object[]{"Belo Horizonte", "Brazil", 4000000L, 868L, 4600L}).row(new Object[]{"Khartoum", "Sudan", 4000000L, 583L, 6850L}).row(new Object[]{"Riyadh", "Saudi Arabia", 4000000L, 1101L, 3650L}).row(new Object[]{"Singapore", "Singapore", 4000000L, 479L, 8350L}).row(new Object[]{"Washington", "USA", 3934000L, 2996L, 1300L}).row(new Object[]{"Detroit", "USA", 3903000L, 3267L, 1200L}).row(new Object[]{"Barcelona", "Spain", 3900000L, 803L, 4850L}).row(new Object[]{"Houston", "USA", 3823000L, 3355L, 1150L}).row(new Object[]{"Athens", "Greece", 0x383A88L, 684L, 5400L}).row(new Object[]{"Berlin", "Germany", 3675000L, 984L, 3750L}).row(new Object[]{"Sydney", "Australia", 3502000L, 1687L, 2100L}).row(new Object[]{"Atlanta", "USA", 3500000L, 5083L, 700L}).row(new Object[]{"Guadalajara", "Mexico", 3500000L, 596L, 5900L}).row(new Object[]{"San Francisco/Oakland", "USA", 3229000L, 1365L, 2350L}).row(new Object[]{"Montreal.", "Canada", 3216000L, 1740L, 1850L}).row(new Object[]{"Monterey", "Mexico", 3200000L, 479L, 6700L}).row(new Object[]{"Melbourne", "Australia", 3162000L, 2080L, 1500L}).row(new Object[]{"Ankara", "Turkey", 3100000L, 583L, 5300L}).row(new Object[]{"Recife", "Brazil", 3025000L, 376L, 8050L}).row(new Object[]{"Phoenix/Mesa", "USA", 2907000L, 2069L, 1400L}).row(new Object[]{"Durban", "South Africa", 2900000L, 829L, 3500L}).row(new Object[]{"Porto Alegre", "Brazil", 2800000L, 583L, 4800L}).row(new Object[]{"Dalian", "China", 2750000L, 389L, 7100L}).row(new Object[]{"Jeddah", "Saudi Arabia", 2750000L, 777L, 3550L}).row(new Object[]{"Seattle", "USA", 2712000L, 2470L, 1100L}).row(new Object[]{"Cape Town", "South Africa", 2700000L, 686L, 3950L}).row(new Object[]{"San Diego", "USA", 2674000L, 2026L, 1300L}).row(new Object[]{"Fortaleza", "Brazil", 2650000L, 583L, 4550L}).row(new Object[]{"Curitiba", "Brazil", 2500000L, 648L, 3850L}).row(new Object[]{"Rome", "Italy", 2500000L, 842L, 2950L}).row(new Object[]{"Naples", "Italy", 2400000L, 583L, 4100L}).row(new Object[]{"Minneapolis/St. Paul", "USA", 2389000L, 2316L, 1050L}).row(new Object[]{"Tel Aviv", "Israel", 2300000L, 453L, 5050L}).row(new Object[]{"Birmingham", "UK", 2284000L, 600L, 3800L}).row(new Object[]{"Frankfurt", "Germany", 2260000L, 984L, 2300L}).row(new Object[]{"Lisbon", "Portugal", 2250000L, 881L, 2550L}).row(new Object[]{"Manchester", "UK", 2245000L, 558L, 4000L}).row(new Object[]{"San Juan", "Puerto Rico", 2217000L, 2309L, 950L}).row(new Object[]{"Katowice", "Poland", 2200000L, 544L, 4050L}).row(new Object[]{"Tashkent", "Uzbekistan", 2200000L, 531L, 4150L}).row(new Object[]{"Fukuoka", "Japan", 2150000L, 544L, 3950L}).row(new Object[]{"Baku/Sumqayit", "Azerbaijan", 0x200B20L, 544L, 3850L}).row(new Object[]{"St. Louis", "USA", 2078000L, 2147L, 950L}).row(new Object[]{"Baltimore", "USA", 2076000L, 1768L, 1150L}).row(new Object[]{"Sapporo", "Japan", 2075000L, 414L, 5000L}).row(new Object[]{"Tampa/St. Petersburg", "USA", 2062000L, 2078L, 1000L}).row(new Object[]{"Taichung", "Taiwan", 2000000L, 510L, 3900L}).row(new Object[]{"Warsaw", "Poland", 2000000L, 466L, 4300L}).row(new Object[]{"Denver", "USA", 1985000L, 1292L, 1550L}).row(new Object[]{"Cologne/Bonn", "Germany", 1960000L, 816L, 2400L}).row(new Object[]{"Hamburg", "Germany", 1925000L, 829L, 2300L}).row(new Object[]{"Dubai", "UAE", 1900000L, 712L, 2650L}).row(new Object[]{"Pretoria", "South Africa", 1850000L, 673L, 2750L}).row(new Object[]{"Vancouver", "Canada", 1830000L, 1120L, 1650L}).row(new Object[]{"Beirut", "Lebanon", 1800000L, 648L, 2800L}).row(new Object[]{"Budapest", "Hungary", 1800000L, 702L, 2550L}).row(new Object[]{"Cleveland", "USA", 1787000L, 1676L, 1050L}).row(new Object[]{"Pittsburgh", "USA", 1753000L, 2208L, 800L}).row(new Object[]{"Campinas", "Brazil", 1750000L, 492L, 3550L}).row(new Object[]{"Harare", "Zimbabwe", 1750000L, 712L, 2450L}).row(new Object[]{"Brasilia", "Brazil", 1625000L, 583L, 2800L}).row(new Object[]{"Kuwait", "Kuwait", 1600000L, 544L, 2950L}).row(new Object[]{"Munich", "Germany", 1600000L, 518L, 3100L}).row(new Object[]{"Portland", "USA", 1583000L, 1228L, 1300L}).row(new Object[]{"Brussels", "Belgium", 1570000L, 712L, 2200L}).row(new Object[]{"Vienna", "Austria", 1550000L, 453L, 3400L}).row(new Object[]{"San Jose", "USA", 1538000L, 674L, 2300L}).row(new Object[]{"Damman", "Saudi Arabia", 1525000L, 673L, 2250L}).row(new Object[]{"Copenhagen", "Denmark", 1525000L, 816L, 1850L}).row(new Object[]{"Brisbane", "Australia", 1508000L, 1603L, 950L}).row(new Object[]{"Riverside/San Bernardino", "USA", 1507000L, 1136L, 1350L}).row(new Object[]{"Cincinnati", "USA", 1503000L, 1740L, 850L}).row(new Object[]{"Accra", "Ghana", 1500000L, 453L, 3300L}).buildDataSet());
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("worldPopulation")).group(COUNTRY)).column(COUNTRY)).column(POPULATION, AggregateFunctionType.SUM)).column(AREA_SIZE, AggregateFunctionType.SUM)).buildLookup());
        result.setUUID("countryPopulation");
        this.dataSetManager.registerDataSet(result);
    }
}

