/*
 * Copyright 2015 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.dashbuilder.displayer.client.resources.i18n;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.Messages;

public interface DisplayerConstants extends Messages {

    public static final DisplayerConstants INSTANCE = GWT.create(DisplayerConstants.class);

    public String initializing();

    public String error();

    public String error_settings_unset();

    public String error_handler_unset();

    public String error_dataset_notfound();

    String displayer_keyword_not_allowed(String expr);

    String displayer_expr_invalid_syntax(String expr);

}
