/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.core.client.Callback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;

public class DisplayerCoordinator {
    protected List<Displayer> displayerList = new ArrayList<Displayer>();
    protected Map<RendererLibrary, List<Displayer>> rendererMap = new HashMap<RendererLibrary, List<Displayer>>();
    protected CoordinatorListener displayerListener = new CoordinatorListener();
    protected Map<Displayer, List<Displayer>> notificationVetoMap = new HashMap<Displayer, List<Displayer>>();

    public void addListener(DisplayerListener ... listeners) {
        for (Displayer displayer : this.displayerList) {
            displayer.addListener(listeners);
        }
    }

    public void addDisplayers(List<Displayer> displayers) {
        for (Displayer displayer : displayers) {
            this.addDisplayer(displayer);
        }
    }

    public void addDisplayer(Displayer displayer) {
        if (displayer == null) {
            return;
        }
        this.displayerList.add(displayer);
        displayer.addListener(this.displayerListener);
        RendererLibrary renderer = RendererManager.get().getRendererForDisplayer(displayer.getDisplayerSettings());
        List<Displayer> rendererGroup = this.rendererMap.get(renderer);
        if (rendererGroup == null) {
            rendererGroup = new ArrayList<Displayer>();
            this.rendererMap.put(renderer, rendererGroup);
        }
        rendererGroup.add(displayer);
    }

    public List<Displayer> getDisplayerList() {
        return this.displayerList;
    }

    public boolean removeDisplayer(Displayer displayer) {
        if (displayer == null) {
            return false;
        }
        RendererLibrary renderer = RendererManager.get().getRendererForDisplayer(displayer.getDisplayerSettings());
        List<Displayer> rendererGroup = this.rendererMap.get(renderer);
        if (rendererGroup != null) {
            rendererGroup.remove(displayer);
        }
        return this.displayerList.remove(displayer);
    }

    public void drawAll() {
        this.drawAll(null);
    }

    public void redrawAll() {
        this.redrawAll(null);
    }

    public void drawAll(Callback callback) {
        this.displayerListener.init(callback, this.displayerList.size(), true);
        for (RendererLibrary renderer : this.rendererMap.keySet()) {
            List<Displayer> rendererGroup = this.rendererMap.get(renderer);
            renderer.draw(rendererGroup);
        }
    }

    public void redrawAll(Callback callback) {
        this.displayerListener.init(callback, this.displayerList.size(), false);
        for (RendererLibrary renderer : this.rendererMap.keySet()) {
            List<Displayer> rendererGroup = this.rendererMap.get(renderer);
            renderer.redraw(rendererGroup);
        }
    }

    public void closeAll() {
        for (Displayer displayer : this.displayerList) {
            displayer.close();
        }
    }

    public void addNotificationVeto(Displayer target, List<Displayer> vetoedDisplayers) {
        this.notificationVetoMap.put(target, vetoedDisplayers);
    }

    public void addNotificationVeto(List<Displayer> vetoedDisplayers) {
        for (Displayer target : vetoedDisplayers) {
            this.notificationVetoMap.put(target, vetoedDisplayers);
        }
    }

    public boolean isNotificationVetoed(Displayer from, Displayer to) {
        List<Displayer> vetoList = this.notificationVetoMap.get(to);
        return vetoList != null && vetoList.contains(from);
    }

    private class CoordinatorListener
    implements DisplayerListener {
        int count = 0;
        int total = 0;
        Callback callback;
        boolean draw;

        private CoordinatorListener() {
        }

        protected void init(Callback callback, int total, boolean draw) {
            this.count = 0;
            this.callback = callback;
            this.draw = draw;
            this.total = total;
        }

        protected void count() {
            ++this.count;
            if (this.count == this.total && this.callback != null) {
                this.callback.onSuccess(null);
            }
        }

        protected void error() {
            ++this.count;
            if (this.count == this.total && this.callback != null) {
                this.callback.onFailure(null);
            }
        }

        @Override
        public void onDataLookup(Displayer displayer) {
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onDataLookup(displayer);
            }
        }

        @Override
        public void onDraw(Displayer displayer) {
            if (this.draw) {
                this.count();
            }
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer) continue;
                other.onDraw(displayer);
            }
        }

        @Override
        public void onRedraw(Displayer displayer) {
            if (!this.draw) {
                this.count();
            }
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onRedraw(displayer);
            }
        }

        @Override
        public void onClose(Displayer displayer) {
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onClose(displayer);
            }
        }

        @Override
        public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onFilterEnabled(displayer, groupOp);
            }
        }

        @Override
        public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onFilterEnabled(displayer, filter);
            }
        }

        @Override
        public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onFilterReset(displayer, groupOps);
            }
        }

        @Override
        public void onFilterReset(Displayer displayer, DataSetFilter filter) {
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onFilterReset(displayer, filter);
            }
        }

        @Override
        public void onError(Displayer displayer, ClientRuntimeError error) {
            this.error();
            for (Displayer other : DisplayerCoordinator.this.displayerList) {
                if (other == displayer || DisplayerCoordinator.this.isNotificationVetoed(displayer, other)) continue;
                other.onError(displayer, error);
            }
        }
    }
}

