/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.github.gwtbootstrap.client.ui.Image;
import com.github.gwtbootstrap.client.ui.constants.ImageType;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.HandlerRegistration;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerTypeLiterals;
import org.dashbuilder.displayer.client.resources.images.DisplayerImagesResources;

public class DisplayerSubtypeSelector
extends Composite {
    private SubTypeChangeListener listener;
    private List<DisplayerSubTypeImageWidget> imageWidgetList;
    RendererManager rendererManager;
    private FlexTable subtypes;
    private VerticalPanel subtypePanel;

    public DisplayerSubtypeSelector(SubTypeChangeListener subTypeChangeListener) {
        this.listener = subTypeChangeListener;
        this.rendererManager = RendererManager.get();
        this.imageWidgetList = new ArrayList<DisplayerSubTypeImageWidget>(5);
        this.subtypes = new FlexTable();
        this.subtypePanel = new VerticalPanel();
        this.subtypePanel.add((Widget)this.subtypes);
        this.initWidget((Widget)this.subtypePanel);
    }

    public void select(String renderer, DisplayerType type, DisplayerSubType selectedSubType) {
        this.subtypes.removeAllRows();
        this.imageWidgetList.clear();
        RendererLibrary rendererLibrary = null;
        rendererLibrary = !StringUtils.isBlank((String)renderer) ? this.rendererManager.getRendererByUUID(renderer) : this.rendererManager.getRendererForType(type);
        if (rendererLibrary != null) {
            List<DisplayerSubType> supportedSubTypes = rendererLibrary.getSupportedSubtypes(type);
            if (supportedSubTypes != null && supportedSubTypes.size() > 0) {
                for (int i = 0; i < supportedSubTypes.size(); ++i) {
                    final DisplayerSubType subtype = supportedSubTypes.get(i);
                    if (!type.getSubTypes().contains(subtype)) {
                        throw new RuntimeException("Wrong subtype (" + subtype + ") indicated for type " + type + " by renderer library " + rendererLibrary.getUUID());
                    }
                    String resourcePrefix = type.toString() + "_" + subtype.toString();
                    ImageResource selectedIR = (ImageResource)DisplayerImagesResources.INSTANCE.getResource(resourcePrefix + "_selected");
                    ImageResource unselectedIR = (ImageResource)DisplayerImagesResources.INSTANCE.getResource(resourcePrefix + "_unselected");
                    String tooltip = DisplayerTypeLiterals.INSTANCE.getString(resourcePrefix + "_tt");
                    boolean initiallySelected = selectedSubType != null ? subtype == selectedSubType : i == 0;
                    final DisplayerSubTypeImageWidget dstiw = new DisplayerSubTypeImageWidget(selectedIR, unselectedIR, tooltip, initiallySelected);
                    this.imageWidgetList.add(dstiw);
                    if (initiallySelected) {
                        this.listener.displayerSubtypeChanged(subtype);
                    }
                    dstiw.setSelectClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            if (!dstiw.isSelected) {
                                DisplayerSubtypeSelector.this.select(dstiw);
                            }
                            if (DisplayerSubtypeSelector.this.listener != null) {
                                DisplayerSubtypeSelector.this.listener.displayerSubtypeChanged(subtype);
                            }
                        }
                    });
                    this.subtypes.setWidget(i, 0, (Widget)dstiw);
                }
            } else {
                ImageResource selectedIR = (ImageResource)DisplayerImagesResources.INSTANCE.getResource(type.toString() + "_default");
                String tooltip = DisplayerTypeLiterals.INSTANCE.getString(type.toString() + "_default" + "_tt");
                DisplayerSubTypeImageWidget dstiw = new DisplayerSubTypeImageWidget(selectedIR, null, tooltip, true);
                this.subtypes.setWidget(0, 0, (Widget)dstiw);
            }
        }
    }

    private void select(DisplayerSubTypeImageWidget dstiw) {
        for (DisplayerSubTypeImageWidget imageWidget : this.imageWidgetList) {
            if (imageWidget == dstiw) {
                imageWidget.select();
                continue;
            }
            imageWidget.unselect();
        }
    }

    public class DisplayerSubTypeImageWidget
    extends Composite {
        private FlexTable container = new FlexTable();
        private boolean isSelected = false;
        private Image selected;
        private Image unselected;

        public DisplayerSubTypeImageWidget(ImageResource selectedImage, ImageResource unselectedImage, String tooltip, boolean initiallySelected) {
            this.initWidget((Widget)this.container);
            this.isSelected = initiallySelected;
            if (selectedImage != null) {
                this.selected = new Image(selectedImage);
                this.selected.setType(ImageType.POLAROID);
                this.selected.setTitle(tooltip);
                this.selected.setVisible(this.isSelected);
                this.selected.addStyleName("selDispSubtype");
                this.container.setWidget(0, 0, (Widget)this.selected);
            }
            if (unselectedImage != null) {
                this.unselected = new Image(unselectedImage);
                this.unselected.setType(ImageType.POLAROID);
                this.unselected.setTitle(tooltip);
                this.unselected.setVisible(!this.isSelected);
                this.container.setWidget(0, 1, (Widget)this.unselected);
            }
        }

        public HandlerRegistration setSelectClickHandler(ClickHandler selectedClickHandler) {
            return this.unselected != null ? this.unselected.addClickHandler(selectedClickHandler) : null;
        }

        public void select() {
            this.isSelected = true;
            this.selected.setVisible(true);
            this.unselected.setVisible(false);
        }

        public void unselect() {
            this.isSelected = false;
            this.selected.setVisible(false);
            this.unselected.setVisible(true);
        }
    }

    public static interface SubTypeChangeListener {
        public void displayerSubtypeChanged(DisplayerSubType var1);
    }
}

