/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.github.gwtbootstrap.client.ui.RadioButton;
import com.github.gwtbootstrap.client.ui.Tab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;

public class RendererSelector
extends Composite {
    private static final String RENDERER_KEY = "renderer";
    private static final RendererSelectorBinder uiBinder = (RendererSelectorBinder)GWT.create(RendererSelectorBinder.class);
    @UiField
    Panel mainPanel;
    @UiField
    Panel listPanel;
    @UiField
    Panel radioButtonsPanel;
    @UiField
    Panel tabPanel;
    @UiField
    ListBox listBox;

    public RendererSelector(DisplayerSettings displayerSettings, SelectorType selectorType, RendererSelectorEventHandler handler) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (handler != null) {
            this.addHandler(handler, RendererSelectorEvent.TYPE);
        }
        RendererManager rendererManager = RendererManager.get();
        RendererLibrary rendererLibrary = rendererManager.getRendererForDisplayer(displayerSettings);
        List<RendererLibrary> renderers = rendererManager.getRenderersForType(displayerSettings.getType(), displayerSettings.getSubtype());
        if (renderers != null && renderers.size() > 1) {
            switch (selectorType) {
                case LIST: {
                    this.buildDropdown(renderers, rendererLibrary);
                    break;
                }
                case RADIO: {
                    this.buildRadioList(renderers, rendererLibrary);
                    break;
                }
                case TAB: {
                    this.buildTabList(renderers, rendererLibrary);
                }
            }
        } else {
            this.listPanel.setVisible(false);
            this.radioButtonsPanel.setVisible(false);
            this.mainPanel.setVisible(false);
        }
    }

    public String getTitle() {
        return CommonConstants.INSTANCE.renderer_selector_title();
    }

    private void buildDropdown(List<RendererLibrary> renderers, RendererLibrary currentLib) {
        this.listBox.clear();
        this.listPanel.setVisible(true);
        this.radioButtonsPanel.setVisible(false);
        this.tabPanel.setVisible(false);
        int index = 0;
        int selectedIndex = 0;
        for (RendererLibrary rendererLib : renderers) {
            if (currentLib != null && rendererLib.equals(currentLib)) {
                selectedIndex = index;
            }
            this.listBox.addItem(rendererLib.getName());
            ++index;
        }
        this.listBox.setSelectedIndex(selectedIndex);
        this.listBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int index = RendererSelector.this.listBox.getSelectedIndex();
                String value = RendererSelector.this.listBox.getValue(index);
                RendererLibrary lib = RendererManager.get().getRendererByName(value);
                RendererSelector.this.fireEvent(new RendererSelectorEvent(lib.getUUID()));
            }
        });
    }

    private void buildRadioList(List<RendererLibrary> renderers, RendererLibrary currentLib) {
        this.radioButtonsPanel.setVisible(true);
        this.listPanel.setVisible(false);
        this.tabPanel.setVisible(false);
        for (RendererLibrary rendererLib : renderers) {
            final RadioButton rb = new RadioButton(RENDERER_KEY, rendererLib.getName());
            rb.setValue(Boolean.valueOf(rendererLib.equals(currentLib)));
            rb.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String value = rb.getText();
                    RendererLibrary lib = RendererManager.get().getRendererByName(value);
                    RendererSelector.this.fireEvent(new RendererSelectorEvent(lib.getUUID()));
                }
            });
            this.radioButtonsPanel.add((Widget)rb);
            if (currentLib == null || !rendererLib.equals(currentLib)) continue;
            rb.setValue(Boolean.valueOf(true));
        }
    }

    private void buildTabList(List<RendererLibrary> renderers, RendererLibrary currentLib) {
        this.tabPanel.clear();
        this.tabPanel.setVisible(true);
        this.radioButtonsPanel.setVisible(false);
        this.listPanel.setVisible(false);
        for (RendererLibrary rendererLib : renderers) {
            final Tab tab = new Tab();
            tab.setHeading(rendererLib.getName());
            tab.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    String value = tab.getHeading().trim();
                    RendererLibrary lib = RendererManager.get().getRendererByName(value);
                    RendererSelector.this.fireEvent(new RendererSelectorEvent(lib.getUUID()));
                }
            });
            this.tabPanel.add(tab.asWidget());
            if (currentLib == null || !rendererLib.equals(currentLib)) continue;
            tab.setActive(true);
        }
    }

    public void setWidth(String width) {
        super.setWidth(width);
        this.mainPanel.setWidth(width);
        this.listPanel.setWidth(width);
        this.radioButtonsPanel.setWidth(width);
        this.tabPanel.setWidth(width);
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.mainPanel.setHeight(height);
        this.listPanel.setHeight(height);
        this.radioButtonsPanel.setHeight(height);
        this.tabPanel.setHeight(height);
    }

    public static enum SelectorType {
        LIST,
        RADIO,
        TAB;

    }

    public static interface RendererSelectorEventHandler
    extends EventHandler {
        public void onRendererSelected(RendererSelectorEvent var1);
    }

    public static class RendererSelectorEvent
    extends GwtEvent<RendererSelectorEventHandler> {
        public static GwtEvent.Type<RendererSelectorEventHandler> TYPE = new GwtEvent.Type();
        private String renderer;

        public RendererSelectorEvent(String renderer) {
            this.renderer = renderer;
        }

        public GwtEvent.Type<RendererSelectorEventHandler> getAssociatedType() {
            return TYPE;
        }

        protected void dispatch(RendererSelectorEventHandler handler) {
            handler.onRendererSelected(this);
        }

        public String getRenderer() {
            return this.renderer;
        }
    }

    static interface RendererSelectorBinder
    extends UiBinder<Widget, RendererSelector> {
    }
}

