/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.client.resources.i18n.DayOfWeekConstants;
import org.dashbuilder.dataset.client.resources.i18n.MonthConstants;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalPattern;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerConstants;

public abstract class AbstractDisplayer
extends Composite
implements Displayer {
    protected DataSet dataSet;
    protected DataSetHandler dataSetHandler;
    protected DisplayerSettings displayerSettings;
    protected DisplayerConstraints displayerConstraints;
    protected List<DisplayerListener> listenerList = new ArrayList<DisplayerListener>();
    protected FlowPanel panel = new FlowPanel();
    protected Label label = new Label();
    protected Map<String, List<Interval>> columnSelectionMap = new HashMap<String, List<Interval>>();
    protected DataSetFilter currentFilter = null;
    protected boolean refreshEnabled = true;
    protected boolean drawn = false;
    protected Timer refreshTimer = null;
    Map<String, ValueFormatter> formatterMap = new HashMap<String, ValueFormatter>();
    public static final String[] _jsMalicious = new String[]{"document.", "window.", "alert(", "eval(", ".innerHTML"};
    private static Map<String, NumberFormat> numberPatternMap = new HashMap<String, NumberFormat>();
    private static Map<String, DateTimeFormat> datePatternMap = new HashMap<String, DateTimeFormat>();

    public AbstractDisplayer() {
        this.initWidget((Widget)this.panel);
    }

    public abstract DisplayerConstraints createDisplayerConstraints();

    @Override
    public DisplayerConstraints getDisplayerConstraints() {
        if (this.displayerConstraints == null) {
            this.displayerConstraints = this.createDisplayerConstraints();
        }
        return this.displayerConstraints;
    }

    @Override
    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    @Override
    public void setDisplayerSettings(DisplayerSettings displayerSettings) {
        this.checkDisplayerSettings(displayerSettings);
        this.displayerSettings = displayerSettings;
    }

    public void checkDisplayerSettings(DisplayerSettings displayerSettings) {
        ValidationError error;
        DisplayerConstraints constraints = this.getDisplayerConstraints();
        if (this.displayerConstraints != null && (error = constraints.check(displayerSettings)) != null) {
            throw error;
        }
    }

    @Override
    public DataSetHandler getDataSetHandler() {
        return this.dataSetHandler;
    }

    @Override
    public void setDataSetHandler(DataSetHandler dataSetHandler) {
        this.dataSetHandler = dataSetHandler;
    }

    @Override
    public void addListener(DisplayerListener ... listeners) {
        for (DisplayerListener listener : listeners) {
            this.listenerList.add(listener);
        }
    }

    public String getDisplayerId() {
        String id = this.displayerSettings.getUUID();
        if (!StringUtils.isBlank((String)id)) {
            return id;
        }
        id = this.displayerSettings.getTitle();
        if (!StringUtils.isBlank((String)id)) {
            int hash = id.hashCode();
            return Integer.toString(hash < 0 ? hash * -1 : hash);
        }
        return null;
    }

    @Override
    public boolean isDrawn() {
        return this.drawn;
    }

    @Override
    public void draw() {
        if (this.displayerSettings == null) {
            this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_settings_unset());
        } else if (this.dataSetHandler == null) {
            this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_handler_unset());
        } else if (!this.isDrawn()) {
            try {
                this.drawn = true;
                String initMsg = DisplayerConstants.INSTANCE.initializing();
                this.displayMessage(initMsg);
                this.beforeLoad();
                this.beforeDataSetLookup();
                this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                    public void callback(DataSet result) {
                        try {
                            AbstractDisplayer.this.dataSet = result;
                            AbstractDisplayer.this.afterDataSetLookup(result);
                            Widget w = AbstractDisplayer.this.createVisualization();
                            AbstractDisplayer.this.panel.clear();
                            AbstractDisplayer.this.panel.add(w);
                            String id = AbstractDisplayer.this.getDisplayerId();
                            if (!StringUtils.isBlank((String)id)) {
                                AbstractDisplayer.this.panel.getElement().setId(id);
                            }
                            AbstractDisplayer.this.afterDraw();
                        }
                        catch (Exception e) {
                            AbstractDisplayer.this.afterError(e);
                        }
                    }

                    public void notFound() {
                        AbstractDisplayer.this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_dataset_notfound());
                    }

                    public boolean onError(ClientRuntimeError error) {
                        AbstractDisplayer.this.afterError(error);
                        return false;
                    }
                });
            }
            catch (Exception e) {
                this.displayMessage(DisplayerConstants.INSTANCE.error() + e.getMessage());
                this.afterError(e);
            }
        }
    }

    @Override
    public void redraw() {
        if (!this.isDrawn()) {
            this.draw();
        } else {
            try {
                this.beforeLoad();
                this.beforeDataSetLookup();
                this.dataSetHandler.lookupDataSet(new DataSetReadyCallback(){

                    public void callback(DataSet result) {
                        try {
                            AbstractDisplayer.this.dataSet = result;
                            AbstractDisplayer.this.afterDataSetLookup(result);
                            AbstractDisplayer.this.updateVisualization();
                            AbstractDisplayer.this.afterRedraw();
                        }
                        catch (Exception e) {
                            AbstractDisplayer.this.afterError(e);
                        }
                    }

                    public void notFound() {
                        AbstractDisplayer.this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_dataset_notfound());
                        AbstractDisplayer.this.afterError(DisplayerConstants.INSTANCE.error_dataset_notfound());
                    }

                    public boolean onError(ClientRuntimeError error) {
                        AbstractDisplayer.this.afterError(error);
                        return false;
                    }
                });
            }
            catch (Exception e) {
                this.displayMessage(DisplayerConstants.INSTANCE.error() + e.getMessage());
                this.afterError(e);
            }
        }
    }

    @Override
    public void close() {
        this.panel.clear();
        this.afterClose();
    }

    protected abstract Widget createVisualization();

    protected abstract void updateVisualization();

    protected void beforeDataSetLookup() {
    }

    protected void afterDataSetLookup(DataSet dataSet) {
    }

    public void displayMessage(String msg) {
        this.panel.clear();
        this.panel.add((Widget)this.label);
        this.label.setText(msg);
    }

    @Override
    public void setRefreshOn(boolean enabled) {
        boolean changed = enabled != this.refreshEnabled;
        this.refreshEnabled = enabled;
        if (changed) {
            this.updateRefreshTimer();
        }
    }

    @Override
    public boolean isRefreshOn() {
        return this.refreshTimer != null;
    }

    protected void updateRefreshTimer() {
        int seconds = this.displayerSettings.getRefreshInterval();
        if (this.refreshEnabled && seconds > 0) {
            if (this.refreshTimer == null) {
                this.refreshTimer = new Timer(){

                    public void run() {
                        if (AbstractDisplayer.this.isDrawn()) {
                            AbstractDisplayer.this.redraw();
                        }
                    }
                };
            }
            this.refreshTimer.schedule(seconds * 1000);
        } else if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }

    protected void beforeLoad() {
        for (DisplayerListener listener : this.listenerList) {
            listener.onDataLookup(this);
        }
    }

    protected void afterDraw() {
        this.updateRefreshTimer();
        for (DisplayerListener listener : this.listenerList) {
            listener.onDraw(this);
        }
    }

    protected void afterRedraw() {
        this.updateRefreshTimer();
        for (DisplayerListener listener : this.listenerList) {
            listener.onRedraw(this);
        }
    }

    protected void afterClose() {
        this.setRefreshOn(false);
        for (DisplayerListener listener : this.listenerList) {
            listener.onClose(this);
        }
    }

    protected void afterError(String message) {
        this.afterError(new ClientRuntimeError(message, null));
    }

    protected void afterError(String message, Throwable error) {
        this.afterError(new ClientRuntimeError(message, error));
    }

    protected void afterError(Throwable error) {
        this.afterError(new ClientRuntimeError(error));
    }

    protected void afterError(ClientRuntimeError error) {
        if (error.getThrowable() != null) {
            GWT.log((String)("ClientRuntimeError: " + error));
        } else {
            GWT.log((String)("ClientRuntimeError: " + error), (Throwable)error.getThrowable());
        }
        for (DisplayerListener listener : this.listenerList) {
            listener.onError(this, error);
        }
    }

    @Override
    public void onDataLookup(Displayer displayer) {
    }

    @Override
    public void onDraw(Displayer displayer) {
    }

    @Override
    public void onRedraw(Displayer displayer) {
    }

    @Override
    public void onClose(Displayer displayer) {
    }

    @Override
    public void onError(Displayer displayer, ClientRuntimeError error) {
    }

    @Override
    public void onFilterEnabled(Displayer displayer, DataSetGroup groupOp) {
        if (this.displayerSettings.isFilterListeningEnabled() && this.dataSetHandler.filter(groupOp)) {
            this.redraw();
        }
    }

    @Override
    public void onFilterEnabled(Displayer displayer, DataSetFilter filter) {
        if (this.displayerSettings.isFilterListeningEnabled() && this.dataSetHandler.filter(filter)) {
            this.redraw();
        }
    }

    @Override
    public void onFilterReset(Displayer displayer, List<DataSetGroup> groupOps) {
        if (this.displayerSettings.isFilterListeningEnabled()) {
            boolean applied = false;
            for (DataSetGroup groupOp : groupOps) {
                if (!this.dataSetHandler.unfilter(groupOp)) continue;
                applied = true;
            }
            if (applied) {
                this.redraw();
            }
        }
    }

    @Override
    public void onFilterReset(Displayer displayer, DataSetFilter filter) {
        if (this.displayerSettings.isFilterListeningEnabled() && this.dataSetHandler.unfilter(filter)) {
            this.redraw();
        }
    }

    public Set<String> filterColumns() {
        return this.columnSelectionMap.keySet();
    }

    public List<Interval> filterIntervals(String columnId) {
        List<Interval> selected = this.columnSelectionMap.get(columnId);
        if (selected == null) {
            return new ArrayList<Interval>();
        }
        return selected;
    }

    public List<Integer> filterIndexes(String columnId) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<Interval> selected = this.columnSelectionMap.get(columnId);
        if (selected == null) {
            return result;
        }
        for (Interval interval : selected) {
            result.add(interval.getIndex());
        }
        return result;
    }

    public void filterUpdate(String columnId, int row) {
        this.filterUpdate(columnId, row, null);
    }

    public void filterUpdate(String columnId, int row, Integer maxSelections) {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        Interval intervalSelected = this.dataSetHandler.getInterval(columnId, row);
        if (intervalSelected == null) {
            return;
        }
        List<Interval> selectedIntervals = this.columnSelectionMap.get(columnId);
        if (selectedIntervals == null) {
            selectedIntervals = new ArrayList<Interval>();
            selectedIntervals.add(intervalSelected);
            this.columnSelectionMap.put(columnId, selectedIntervals);
            this.filterApply(columnId, selectedIntervals);
        } else if (selectedIntervals.contains(intervalSelected)) {
            selectedIntervals.remove(intervalSelected);
            if (!selectedIntervals.isEmpty()) {
                this.filterApply(columnId, selectedIntervals);
            } else {
                this.filterReset(columnId);
            }
        } else {
            if (this.displayerSettings.isFilterSelfApplyEnabled()) {
                selectedIntervals = new ArrayList<Interval>();
                this.columnSelectionMap.put(columnId, selectedIntervals);
            }
            selectedIntervals.add(intervalSelected);
            if (maxSelections != null && maxSelections > 0 && selectedIntervals.size() >= maxSelections) {
                this.filterReset(columnId);
            } else {
                this.filterApply(columnId, selectedIntervals);
            }
        }
    }

    public void filterApply(String columnId, List<Interval> intervalList) {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
        groupOp.setSelectedIntervalList(intervalList);
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            for (DisplayerListener listener : this.listenerList) {
                listener.onFilterEnabled((Displayer)this, groupOp);
            }
        }
        if (this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.dataSetHandler.drillDown(groupOp);
            this.redraw();
        }
    }

    public void filterApply(DataSetFilter filter) {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        this.currentFilter = filter;
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            for (DisplayerListener listener : this.listenerList) {
                listener.onFilterEnabled((Displayer)this, filter);
            }
        }
        if (this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.dataSetHandler.filter(filter);
            this.redraw();
        }
    }

    public void filterReset(String columnId) {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        this.columnSelectionMap.remove(columnId);
        DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            for (DisplayerListener listener : this.listenerList) {
                listener.onFilterReset((Displayer)this, Arrays.asList(groupOp));
            }
        }
        if (this.displayerSettings.isFilterSelfApplyEnabled()) {
            this.dataSetHandler.drillUp(groupOp);
            this.redraw();
        }
    }

    public void filterReset() {
        if (!this.displayerSettings.isFilterEnabled()) {
            return;
        }
        ArrayList<DataSetGroup> groupOpList = new ArrayList<DataSetGroup>();
        for (String columnId : this.columnSelectionMap.keySet()) {
            DataSetGroup groupOp = this.dataSetHandler.getGroupOperation(columnId);
            groupOpList.add(groupOp);
        }
        this.columnSelectionMap.clear();
        if (this.displayerSettings.isFilterNotificationEnabled()) {
            for (DisplayerListener listener : this.listenerList) {
                if (this.currentFilter != null) {
                    listener.onFilterReset((Displayer)this, this.currentFilter);
                }
                listener.onFilterReset((Displayer)this, groupOpList);
            }
        }
        if (this.displayerSettings.isFilterSelfApplyEnabled()) {
            boolean applied = false;
            if (this.currentFilter != null && this.dataSetHandler.unfilter(this.currentFilter)) {
                applied = true;
            }
            for (DataSetGroup groupOp : groupOpList) {
                if (!this.dataSetHandler.drillUp(groupOp)) continue;
                applied = true;
            }
            if (applied) {
                this.redraw();
            }
        }
        if (this.currentFilter != null) {
            this.currentFilter = null;
        }
    }

    public void sortApply(String columnId, SortOrder sortOrder) {
        this.dataSetHandler.sort(columnId, sortOrder);
    }

    public String formatInterval(Interval interval, DataColumn column) {
        DateIntervalType intervalType;
        if (column == null || column.getColumnGroup() == null) {
            return interval.getName();
        }
        String type = interval.getType();
        if (StringUtils.isBlank((String)type)) {
            type = column.getIntervalType();
        }
        if (StringUtils.isBlank((String)type)) {
            type = column.getColumnGroup().getIntervalSize();
        }
        if ((intervalType = DateIntervalType.getByName((String)type)) != null) {
            String expression;
            ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column.getId());
            String pattern = columnSettings != null ? columnSettings.getValuePattern() : ColumnSettings.getDatePattern((DateIntervalType)intervalType);
            String string = expression = columnSettings != null ? columnSettings.getValueExpression() : null;
            if (pattern == null) {
                pattern = ColumnSettings.getDatePattern((DateIntervalType)intervalType);
            }
            if (expression == null && column.getColumnGroup().getStrategy().equals((Object)GroupStrategy.FIXED)) {
                expression = ColumnSettings.getFixedExpression((DateIntervalType)intervalType);
            }
            return this.formatDate(intervalType, column.getColumnGroup().getStrategy(), interval.getName(), pattern, expression);
        }
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column);
        String expression = columnSettings.getValueExpression();
        if (StringUtils.isBlank((String)expression)) {
            return interval.getName();
        }
        return this.applyExpression(interval.getName(), expression);
    }

    @Override
    public void addFormatter(String columnId, ValueFormatter formatter) {
        this.formatterMap.put(columnId, formatter);
    }

    public ValueFormatter getFormatter(String columnId) {
        return this.formatterMap.get(columnId);
    }

    public String formatValue(Object value, DataColumn column) {
        ValueFormatter formatter = this.getFormatter(column.getId());
        if (formatter != null) {
            return formatter.formatValue(value);
        }
        ColumnSettings columnSettings = this.displayerSettings.getColumnSettings(column);
        String pattern = columnSettings.getValuePattern();
        String empty = columnSettings.getEmptyTemplate();
        String expression = columnSettings.getValueExpression();
        if (value == null) {
            return empty;
        }
        DateIntervalType intervalType = DateIntervalType.getByName((String)column.getIntervalType());
        if (intervalType != null) {
            ColumnGroup columnGroup = column.getColumnGroup();
            return this.formatDate(intervalType, columnGroup.getStrategy(), value.toString(), pattern, expression);
        }
        ColumnType columnType = column.getColumnType();
        if (ColumnType.DATE.equals((Object)columnType)) {
            Date d = (Date)value;
            return this.getDateFormat(pattern).format(d);
        }
        if (ColumnType.NUMBER.equals((Object)columnType)) {
            double d = ((Number)value).doubleValue();
            if (!StringUtils.isBlank((String)expression)) {
                String r = this.applyExpression(value.toString(), expression);
                try {
                    d = Double.parseDouble(r);
                }
                catch (NumberFormatException e) {
                    return r;
                }
            }
            return this.getNumberFormat(pattern).format(d);
        }
        if (StringUtils.isBlank((String)expression)) {
            return value.toString();
        }
        return this.applyExpression(value.toString(), expression);
    }

    protected String applyExpression(String val, String expr) {
        if (StringUtils.isBlank((String)expr)) {
            return val;
        }
        for (String keyword : _jsMalicious) {
            if (!expr.contains(keyword)) continue;
            this.afterError(DisplayerConstants.INSTANCE.displayer_keyword_not_allowed(expr));
            throw new RuntimeException(DisplayerConstants.INSTANCE.displayer_keyword_not_allowed(expr));
        }
        try {
            return this.evalExpression(val, expr);
        }
        catch (Exception e) {
            this.afterError(DisplayerConstants.INSTANCE.displayer_expr_invalid_syntax(expr), e);
            throw new RuntimeException(DisplayerConstants.INSTANCE.displayer_expr_invalid_syntax(expr));
        }
    }

    protected native String evalExpression(String var1, String var2);

    protected NumberFormat getNumberFormat(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return this.getNumberFormat("#,##0.00");
        }
        NumberFormat format = numberPatternMap.get(pattern);
        if (format == null) {
            format = NumberFormat.getFormat((String)pattern);
            numberPatternMap.put(pattern, format);
        }
        return format;
    }

    protected String formatDate(DateIntervalType type, GroupStrategy strategy, String date, String pattern, String expression) {
        String str;
        if (date == null) {
            return null;
        }
        String string = str = GroupStrategy.FIXED.equals((Object)strategy) ? this.formatDateFixed(type, date) : this.formatDateDynamic(type, date, pattern);
        if (StringUtils.isBlank((String)expression)) {
            return str;
        }
        return this.applyExpression(str, expression);
    }

    protected String formatDateFixed(DateIntervalType type, String date) {
        if (date == null) {
            return null;
        }
        int index = Integer.parseInt(date);
        if (DateIntervalType.DAY_OF_WEEK.equals((Object)type)) {
            DayOfWeek dayOfWeek = DayOfWeek.getByIndex((int)index);
            return DayOfWeekConstants.INSTANCE.getString(dayOfWeek.name());
        }
        if (DateIntervalType.MONTH.equals((Object)type)) {
            Month month = Month.getByIndex((int)index);
            return MonthConstants.INSTANCE.getString(month.name());
        }
        return date;
    }

    protected String formatDateDynamic(DateIntervalType type, String date, String pattern) {
        if (date == null) {
            return null;
        }
        Date d = this.parseDynamicGroupDate(type, date);
        DateTimeFormat format = this.getDateFormat(pattern);
        return format.format(d);
    }

    protected Date parseDynamicGroupDate(DateIntervalType type, String date) {
        String pattern = DateIntervalPattern.getPattern((DateIntervalType)type);
        DateTimeFormat format = this.getDateFormat(pattern);
        return format.parse(date);
    }

    protected DateTimeFormat getDateFormat(String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            return this.getDateFormat("MMM dd, yyyy HH:mm");
        }
        DateTimeFormat format = datePatternMap.get(pattern);
        if (format == null) {
            format = DateTimeFormat.getFormat((String)pattern);
            datePatternMap.put(pattern, format);
        }
        return format;
    }
}

