/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.json;

import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.json.DataSetJSONMarshaller;
import org.dashbuilder.displayer.client.json.DataSetLookupJSONMarshaller;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;

public class DisplayerSettingsJSONMarshaller {
    private static final String DATASET_PREFIX = "dataSet";
    private static final String DATASET_LOOKUP_PREFIX = "dataSetLookup";
    private static final String COLUMNS_PREFIX = "columns";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_EXPRESSION = "expression";
    private static final String COLUMN_PATTERN = "pattern";
    private static final String COLUMN_EMPTY = "empty";
    private static final String SETTINGS_UUID = "uuid";
    private DataSetJSONMarshaller dataSetJSONMarshaller;
    private DataSetLookupJSONMarshaller dataSetLookupJSONMarshaller;

    @Inject
    public DisplayerSettingsJSONMarshaller(DataSetJSONMarshaller dataSetJSONMarshaller, DataSetLookupJSONMarshaller dataSetLookupJSONMarshaller) {
        this.dataSetJSONMarshaller = dataSetJSONMarshaller;
        this.dataSetLookupJSONMarshaller = dataSetLookupJSONMarshaller;
    }

    public DisplayerSettingsJSONMarshaller() {
        this.dataSetJSONMarshaller = new DataSetJSONMarshaller();
        this.dataSetLookupJSONMarshaller = new DataSetLookupJSONMarshaller();
    }

    public DisplayerSettings fromJsonString(String jsonString) {
        JSONObject parseResult;
        DisplayerSettings ds = new DisplayerSettings();
        if (!StringUtils.isBlank((String)jsonString) && (parseResult = JSONParser.parseStrict((String)jsonString).isObject()) != null) {
            JSONValue uuidValue = parseResult.get(SETTINGS_UUID);
            ds.setUUID(uuidValue != null && uuidValue.isString() != null ? uuidValue.isString().stringValue() : null);
            parseResult.put(SETTINGS_UUID, null);
            JSONValue data = parseResult.get(DATASET_PREFIX);
            if (data != null) {
                DataSet dataSet = this.dataSetJSONMarshaller.fromJson(data.isObject());
                ds.setDataSet(dataSet);
                parseResult.put(DATASET_PREFIX, null);
            } else {
                data = parseResult.get(DATASET_LOOKUP_PREFIX);
                if (data != null) {
                    DataSetLookup dataSetLookup = this.dataSetLookupJSONMarshaller.fromJson(data.isObject());
                    ds.setDataSetLookup(dataSetLookup);
                    parseResult.put(DATASET_LOOKUP_PREFIX, null);
                } else {
                    throw new RuntimeException(CommonConstants.INSTANCE.json_displayersettings_dataset_lookup_notspecified());
                }
            }
            JSONValue columns = parseResult.get(COLUMNS_PREFIX);
            if (columns != null) {
                List<ColumnSettings> columnSettingsList = this.parseColumnsFromJson(columns.isArray());
                ds.setColumnSettingsList(columnSettingsList);
                parseResult.put(COLUMNS_PREFIX, null);
            }
            ds.setSettingsFlatMap(this.parseSettingsFromJson(parseResult));
        }
        return ds;
    }

    public String toJsonString(DisplayerSettings displayerSettings) {
        return this.toJsonObject(displayerSettings).toString();
    }

    public JSONObject toJsonObject(DisplayerSettings displayerSettings) {
        JSONObject json = new JSONObject();
        json.put(SETTINGS_UUID, (JSONValue)(displayerSettings.getUUID() != null ? new JSONString(displayerSettings.getUUID()) : null));
        for (Map.Entry entry : displayerSettings.getSettingsFlatMap().entrySet()) {
            this.setNodeValue(json, (String)entry.getKey(), (String)entry.getValue());
        }
        DataSetLookup dataSetLookup = displayerSettings.getDataSetLookup();
        DataSet dataSet = displayerSettings.getDataSet();
        if (dataSet != null) {
            json.put(DATASET_PREFIX, (JSONValue)this.dataSetJSONMarshaller.toJson(dataSet));
        } else if (dataSetLookup != null) {
            json.put(DATASET_LOOKUP_PREFIX, (JSONValue)this.dataSetLookupJSONMarshaller.toJson(dataSetLookup));
        } else {
            throw new RuntimeException(CommonConstants.INSTANCE.json_displayersettings_dataset_lookup_notspecified());
        }
        List columnSettingsList = displayerSettings.getColumnSettingsList();
        if (!columnSettingsList.isEmpty()) {
            json.put(COLUMNS_PREFIX, (JSONValue)this.formatColumnSettings(columnSettingsList));
        }
        return json;
    }

    private void setNodeValue(JSONObject node, String path, String value) {
        if (node == null || StringUtils.isBlank((String)path) || value == null) {
            return;
        }
        int separatorIndex = path.lastIndexOf(46);
        String nodesPath = separatorIndex > 0 ? path.substring(0, separatorIndex) : "";
        String leaf = separatorIndex > 0 ? path.substring(separatorIndex + 1) : path;
        JSONObject _node = this.findNode(node, nodesPath, true);
        _node.put(leaf, (JSONValue)new JSONString(value));
    }

    private String getNodeValue(JSONObject node, String path) {
        JSONValue jsonValue;
        if (node == null || StringUtils.isBlank((String)path)) {
            return null;
        }
        int separatorIndex = path.lastIndexOf(46);
        String subNodesPath = separatorIndex > 0 ? path.substring(0, separatorIndex) : "";
        String leaf = separatorIndex > 0 ? path.substring(separatorIndex + 1) : path;
        JSONObject childNode = this.findNode(node, subNodesPath, false);
        String value = null;
        if (childNode != null && (jsonValue = childNode.get(leaf)) != null && jsonValue.isString() != null) {
            value = jsonValue.isString().stringValue();
        }
        return value;
    }

    private JSONObject findNode(JSONObject parent, String path, boolean createPath) {
        if (parent == null) {
            return null;
        }
        if (StringUtils.isBlank((String)path)) {
            return parent;
        }
        int separatorIndex = path.indexOf(46);
        String strChildNode = separatorIndex > 0 ? path.substring(0, separatorIndex) : path;
        String remainingNodes = separatorIndex > 0 ? path.substring(separatorIndex + 1) : "";
        JSONObject childNode = (JSONObject)parent.get(strChildNode);
        if (childNode == null && createPath) {
            childNode = new JSONObject();
            parent.put(strChildNode, (JSONValue)childNode);
        }
        return this.findNode(childNode, remainingNodes, createPath);
    }

    private JSONArray formatColumnSettings(List<ColumnSettings> columnSettingsList) {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < columnSettingsList.size(); ++i) {
            ColumnSettings columnSettings = columnSettingsList.get(i);
            String id = columnSettings.getColumnId();
            String name = columnSettings.getColumnName();
            String expression = columnSettings.getValueExpression();
            String pattern = columnSettings.getValuePattern();
            String empty = columnSettings.getEmptyTemplate();
            JSONObject columnJson = new JSONObject();
            if (StringUtils.isBlank((String)id)) continue;
            columnJson.put(COLUMN_ID, (JSONValue)new JSONString(id));
            if (!StringUtils.isBlank((String)name)) {
                columnJson.put(COLUMN_NAME, (JSONValue)new JSONString(name));
            }
            if (!StringUtils.isBlank((String)expression)) {
                columnJson.put(COLUMN_EXPRESSION, (JSONValue)new JSONString(expression));
            }
            if (!StringUtils.isBlank((String)pattern)) {
                columnJson.put(COLUMN_PATTERN, (JSONValue)new JSONString(pattern));
            }
            if (!StringUtils.isBlank((String)empty)) {
                columnJson.put(COLUMN_EMPTY, (JSONValue)new JSONString(empty));
            }
            jsonArray.set(i, (JSONValue)columnJson);
        }
        return jsonArray;
    }

    private List<ColumnSettings> parseColumnsFromJson(JSONArray columnsJsonArray) {
        ArrayList<ColumnSettings> columnSettingsList = new ArrayList<ColumnSettings>();
        if (columnsJsonArray == null) {
            return columnSettingsList;
        }
        for (int i = 0; i < columnsJsonArray.size(); ++i) {
            JSONObject columnJson = columnsJsonArray.get(i).isObject();
            ColumnSettings columnSettings = new ColumnSettings();
            columnSettingsList.add(columnSettings);
            JSONValue value = columnJson.get(COLUMN_ID);
            if (value == null) {
                throw new RuntimeException(CommonConstants.INSTANCE.json_columnsettings_null_columnid());
            }
            columnSettings.setColumnId(value.isString().stringValue());
            value = columnJson.get(COLUMN_NAME);
            if (value != null) {
                columnSettings.setColumnName(value.isString().stringValue());
            }
            if ((value = columnJson.get(COLUMN_EXPRESSION)) != null) {
                columnSettings.setValueExpression(value.isString().stringValue());
            }
            if ((value = columnJson.get(COLUMN_PATTERN)) != null) {
                columnSettings.setValuePattern(value.isString().stringValue());
            }
            if ((value = columnJson.get(COLUMN_EMPTY)) == null) continue;
            columnSettings.setEmptyTemplate(value.isString().stringValue());
        }
        return columnSettingsList;
    }

    private Map<String, String> parseSettingsFromJson(JSONObject settingsJson) {
        HashMap<String, String> flatSettingsMap = new HashMap<String, String>(30);
        if (settingsJson != null && settingsJson.size() > 0) {
            this.fillRecursive("", settingsJson, flatSettingsMap);
        }
        return flatSettingsMap;
    }

    private void fillRecursive(String parentPath, JSONObject json, Map<String, String> settings) {
        String sb = StringUtils.isBlank((String)parentPath) ? "" : parentPath + ".";
        for (String key : json.keySet()) {
            String path = sb + key;
            JSONValue value = json.get(key);
            if (value.isObject() != null) {
                this.fillRecursive(path, value.isObject(), settings);
                continue;
            }
            if (value.isString() == null) continue;
            settings.put(path, value.isString().stringValue());
        }
    }
}

