/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.github.gwtbootstrap.client.ui.Label;
import com.github.gwtbootstrap.client.ui.constants.LabelType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerHelper;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.resources.i18n.PositionLiterals;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;
import org.uberfire.ext.properties.editor.model.PropertyEditorType;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;

@ApplicationScoped
public class DisplayerSettingsEditor
extends Composite {
    private static final Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    Panel mainPanel;
    @UiField
    PropertyEditorWidget propertyEditor;
    protected Listener listener;
    protected Displayer displayer;
    protected DisplayerSettings displayerSettings;
    protected DisplayerConstraints displayerContraints;
    private Set<DisplayerAttributeDef> supportedAttributes;
    public static final String PROPERTY_EDITOR_ID = "displayerSettingsEditor";
    public static final String COLUMNS_PREFFIX = "columns.";

    public DisplayerSettingsEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    public void init(DisplayerSettings displayerSettings, Listener listener) {
        this.displayerSettings = displayerSettings.cloneInstance();
        this.listener = listener;
        this.displayer = DisplayerHelper.lookupDisplayer(displayerSettings);
        this.displayerContraints = this.displayer.getDisplayerConstraints();
        this.supportedAttributes = this.displayerContraints.getSupportedAttributes();
        this.propertyEditor.setFilterPanelVisible(false);
        try {
            this.displayer.getDataSetHandler().lookupDataSet(new DataSetReadyCallback(){

                public void callback(DataSet dataSet) {
                    DisplayerSettingsEditor.this.propertyEditor.handle(new PropertyEditorEvent(DisplayerSettingsEditor.PROPERTY_EDITOR_ID, DisplayerSettingsEditor.this.getPropertyEditorCategories()));
                }

                public void notFound() {
                    DisplayerSettingsEditor.this.mainPanel.add((Widget)new Label(LabelType.WARNING, CommonConstants.INSTANCE.error() + CommonConstants.INSTANCE.displayer_editor_dataset_notfound()));
                }

                public boolean onError(ClientRuntimeError error) {
                    DisplayerSettingsEditor.this.mainPanel.add((Widget)new Label(LabelType.WARNING, CommonConstants.INSTANCE.error() + error.getMessage()));
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.mainPanel.add((Widget)new Label(LabelType.WARNING, CommonConstants.INSTANCE.error() + e.toString()));
        }
    }

    protected boolean isSupported(DisplayerAttributeDef attributeDef) {
        return this.supportedAttributes.contains(attributeDef);
    }

    protected boolean isSupported(DisplayerAttributeGroupDef groupDef) {
        if (this.supportedAttributes.contains(groupDef)) {
            for (DisplayerAttributeDef attrDef : groupDef.getChildren()) {
                if (attrDef instanceof DisplayerAttributeGroupDef || !this.supportedAttributes.contains(attrDef)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<PropertyEditorCategory> getPropertyEditorCategories() {
        ArrayList<String> optionList;
        PropertyEditorCategory category;
        ArrayList<PropertyEditorCategory> categories = new ArrayList<PropertyEditorCategory>();
        if (this.isSupported(DisplayerAttributeGroupDef.GENERAL_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.common_group());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.TITLE)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.common_title(), this.displayerSettings.getTitle(), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.TITLE.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.TITLE_VISIBLE)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.common_showTitle(), Boolean.toString(this.displayerSettings.isTitleVisible()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.TITLE_VISIBLE.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.ALLOW_EXPORT_CSV)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.common_allowCSV(), Boolean.toString(this.displayerSettings.isCSVExportAllowed()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.ALLOW_EXPORT_CSV.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.ALLOW_EXPORT_EXCEL)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.common_allowExcel(), Boolean.toString(this.displayerSettings.isExcelExportAllowed()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.ALLOW_EXPORT_EXCEL.getFullId()));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.RENDERER)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.common_renderer());
            categories.add(category);
            optionList = new ArrayList<String>();
            for (RendererLibrary option : RendererManager.get().getRenderersForType(this.displayerSettings.getType())) {
                optionList.add(option.getUUID());
            }
            if (optionList.size() > 1) {
                RendererLibrary renderer = RendererManager.get().getRendererForDisplayer(this.displayerSettings);
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.common_renderer(), renderer.getUUID(), PropertyEditorType.COMBO).withComboValues(optionList).withKey(DisplayerAttributeGroupDef.RENDERER.getFullId()));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.CHART_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.chart_group());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_WIDTH)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_width(), Integer.toString(this.displayerSettings.getChartWidth()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.CHART_WIDTH.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_HEIGHT)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_height(), Integer.toString(this.displayerSettings.getChartHeight()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.CHART_HEIGHT.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_BGCOLOR)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_bgColor(), this.displayerSettings.getChartBackgroundColor(), PropertyEditorType.COLOR).withKey(DisplayerAttributeGroupDef.CHART_BGCOLOR.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_3D)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_3d(), Boolean.toString(this.displayerSettings.isChart3D()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.CHART_3D.getFullId()));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.CHART_MARGIN_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.chart_marginGroup());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_MARGIN_TOP)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_topMargin(), Integer.toString(this.displayerSettings.getChartMarginTop()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.CHART_MARGIN_TOP.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_MARGIN_BOTTOM)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_bottomMargin(), Integer.toString(this.displayerSettings.getChartMarginBottom()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.CHART_MARGIN_BOTTOM.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_MARGIN_LEFT)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_leftMargin(), Integer.toString(this.displayerSettings.getChartMarginLeft()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.CHART_MARGIN_LEFT.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_MARGIN_RIGHT)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_rightMargin(), Integer.toString(this.displayerSettings.getChartMarginRight()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.CHART_MARGIN_RIGHT.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.CHART_LEGEND_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.chart_legendGroup());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_SHOWLEGEND)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_legendShow(), Boolean.toString(this.displayerSettings.isChartShowLegend()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.CHART_SHOWLEGEND.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.CHART_LEGENDPOSITION)) {
                optionList = new ArrayList();
                for (Position position : Position.values()) {
                    String positionKey = position.toString();
                    String positionLabel = PositionLiterals.INSTANCE.getString("POSITION_" + positionKey);
                    optionList.add(positionLabel);
                }
                if (optionList.size() > 1) {
                    String positionKey = this.displayerSettings.getChartLegendPosition().toString();
                    String positionLabel = PositionLiterals.INSTANCE.getString("POSITION_" + positionKey);
                    category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.chart_legendPosition(), positionLabel, PropertyEditorType.COMBO).withComboValues(optionList).withKey(DisplayerAttributeGroupDef.CHART_LEGENDPOSITION.getFullId()));
                }
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.XAXIS_GROUP) || this.isSupported(DisplayerAttributeGroupDef.YAXIS_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.axis_group());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.XAXIS_SHOWLABELS)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.xaxis_showLabels(), Boolean.toString(this.displayerSettings.isXAxisShowLabels()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.XAXIS_SHOWLABELS.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.XAXIS_TITLE)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.xaxis_title(), this.displayerSettings.getXAxisTitle(), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.XAXIS_TITLE.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.YAXIS_SHOWLABELS)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.yaxis_showLabels(), Boolean.toString(this.displayerSettings.isYAxisShowLabels()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.YAXIS_SHOWLABELS.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.YAXIS_TITLE)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.yaxis_title(), this.displayerSettings.getYAxisTitle(), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.YAXIS_TITLE.getFullId()));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.TABLE_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.table_group());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.TABLE_PAGESIZE)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.table_pageSize(), Integer.toString(this.displayerSettings.getTablePageSize()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.TABLE_PAGESIZE.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.TABLE_WIDTH)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.table_width(), Integer.toString(this.displayerSettings.getTableWidth()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.TABLE_WIDTH.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.TABLE_SORTENABLED)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.table_sortEnabled(), Boolean.toString(this.displayerSettings.isTableSortEnabled()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.TABLE_SORTENABLED.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.TABLE_SORTCOLUMNID)) {
                optionList = new ArrayList();
                DataSet dataSet = this.displayer.getDataSetHandler().getLastDataSet();
                List dsColumns = dataSet.getColumns();
                optionList.add("");
                for (DataColumn column : dsColumns) {
                    optionList.add(column.getId());
                }
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.table_sortColumn(), this.displayerSettings.getTableDefaultSortColumnId(), PropertyEditorType.COMBO).withComboValues(optionList).withKey(DisplayerAttributeGroupDef.TABLE_SORTCOLUMNID.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.TABLE_SORTORDER)) {
                optionList = new ArrayList();
                optionList.add(SortOrder.ASCENDING.toString());
                optionList.add(SortOrder.DESCENDING.toString());
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.table_sortOrder(), this.displayerSettings.getTableDefaultSortOrder().toString(), PropertyEditorType.COMBO).withComboValues(optionList).withKey(DisplayerAttributeGroupDef.TABLE_SORTORDER.getFullId()));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.METER_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.meter_group());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.METER_START)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.meter_start(), Long.toString(this.displayerSettings.getMeterStart()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.METER_START.getFullId()).withValidators(new PropertyFieldValidator[]{new MeterValidator(this.displayerSettings, 0)}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.METER_WARNING)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.meter_warning(), Long.toString(this.displayerSettings.getMeterWarning()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.METER_WARNING.getFullId()).withValidators(new PropertyFieldValidator[]{new MeterValidator(this.displayerSettings, 1)}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.METER_CRITICAL)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.meter_critical(), Long.toString(this.displayerSettings.getMeterCritical()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.METER_CRITICAL.getFullId()).withValidators(new PropertyFieldValidator[]{new MeterValidator(this.displayerSettings, 2)}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.METER_END)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.meter_end(), Long.toString(this.displayerSettings.getMeterEnd()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.METER_END.getFullId()).withValidators(new PropertyFieldValidator[]{new MeterValidator(this.displayerSettings, 3)}));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.FILTER_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.filter_group());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.FILTER_ENABLED)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.filter_enabled(), Boolean.toString(this.displayerSettings.isFilterEnabled()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.FILTER_ENABLED.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.FILTER_SELFAPPLY_ENABLED)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.filter_self(), Boolean.toString(this.displayerSettings.isFilterSelfApplyEnabled()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.FILTER_SELFAPPLY_ENABLED.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.FILTER_LISTENING_ENABLED)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.filter_listening(), Boolean.toString(this.displayerSettings.isFilterListeningEnabled()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.FILTER_LISTENING_ENABLED.getFullId()));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.FILTER_NOTIFICATION_ENABLED)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.filter_notifications(), Boolean.toString(this.displayerSettings.isFilterNotificationEnabled()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.FILTER_NOTIFICATION_ENABLED.getFullId()));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.REFRESH_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.refresh_group());
            categories.add(category);
            if (this.isSupported(DisplayerAttributeGroupDef.REFRESH_INTERVAL)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.refresh_interval(), Integer.toString(this.displayerSettings.getRefreshInterval()), PropertyEditorType.TEXT).withKey(DisplayerAttributeGroupDef.REFRESH_INTERVAL.getFullId()).withValidators(new PropertyFieldValidator[]{new LongValidator()}));
            }
            if (this.isSupported(DisplayerAttributeGroupDef.REFRESH_STALE_DATA)) {
                category.withField(new PropertyEditorFieldInfo(CommonConstants.INSTANCE.refresh_stale_data(), Boolean.toString(this.displayerSettings.isRefreshStaleData()), PropertyEditorType.BOOLEAN).withKey(DisplayerAttributeGroupDef.REFRESH_STALE_DATA.getFullId()));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.COLUMNS_GROUP)) {
            category = new PropertyEditorCategory(CommonConstants.INSTANCE.common_columns());
            categories.add(category);
            DataSet dataSet = this.displayer.getDataSetHandler().getLastDataSet();
            for (int i = 0; i < dataSet.getColumns().size(); ++i) {
                DataColumn dataColumn = dataSet.getColumnByIndex(i);
                ColumnSettings cs = this.displayerSettings.getColumnSettings(dataColumn);
                String fieldSuffix = COLUMNS_PREFFIX + cs.getColumnId() + ".";
                String expression = cs.getValueExpression();
                String pattern = cs.getValuePattern();
                category.withField(new PropertyEditorFieldInfo("\u25fe " + CommonConstants.INSTANCE.columns_name() + (i + 1), cs.getColumnName(), PropertyEditorType.TEXT).withKey(fieldSuffix + "name"));
                if (expression != null) {
                    category.withField(new PropertyEditorFieldInfo("     " + CommonConstants.INSTANCE.columns_expression(), expression, PropertyEditorType.TEXT).withKey(fieldSuffix + "expression"));
                }
                if (pattern == null) continue;
                category.withField(new PropertyEditorFieldInfo("     " + CommonConstants.INSTANCE.columns_pattern(), pattern, PropertyEditorType.TEXT).withKey(fieldSuffix + "pattern"));
            }
        }
        return categories;
    }

    public void onPropertyEditorChange(@Observes PropertyEditorChangeEvent event) {
        PropertyEditorFieldInfo property = event.getProperty();
        if (property.getEventId().equalsIgnoreCase(PROPERTY_EDITOR_ID)) {
            String attrKey = property.getKey();
            String attrValue = event.getNewValue();
            if (attrKey.startsWith(COLUMNS_PREFFIX)) {
                String[] strings = attrKey.split("\\.");
                if (strings.length == 3) {
                    String columnId = strings[1];
                    String setting = strings[2];
                    if ("name".equals(setting)) {
                        this.displayerSettings.setColumnName(columnId, attrValue);
                    } else if ("empty".equals(setting)) {
                        this.displayerSettings.setColumnEmptyTemplate(columnId, attrValue);
                    } else if ("pattern".equals(setting)) {
                        this.displayerSettings.setColumnValuePattern(columnId, attrValue);
                    } else if ("expression".equals(setting)) {
                        this.displayerSettings.setColumnValueExpression(columnId, attrValue);
                    }
                }
            } else {
                this.displayerSettings.setDisplayerSetting(attrKey, attrValue);
            }
            if (this.listener != null) {
                this.listener.displayerSettingsChanged(this.displayerSettings);
            }
        }
    }

    public class MeterValidator
    extends LongValidator {
        private DisplayerSettings displayerSettings;
        private int level;
        private boolean lowerOk;
        private boolean upperOk;

        public MeterValidator(DisplayerSettings displayerSettings, int level) {
            this.lowerOk = true;
            this.upperOk = true;
            this.displayerSettings = displayerSettings;
            this.level = level;
        }

        private long getLevelValue(int level) {
            switch (level) {
                case 0: {
                    return this.displayerSettings.getMeterStart();
                }
                case 1: {
                    return this.displayerSettings.getMeterWarning();
                }
                case 2: {
                    return this.displayerSettings.getMeterCritical();
                }
                case 3: {
                    return this.displayerSettings.getMeterEnd();
                }
            }
            return level < 0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        }

        private String getLevelDescr(int level) {
            switch (level) {
                case 0: {
                    return CommonConstants.INSTANCE.meter_start();
                }
                case 1: {
                    return CommonConstants.INSTANCE.meter_warning();
                }
                case 2: {
                    return CommonConstants.INSTANCE.meter_critical();
                }
                case 3: {
                    return CommonConstants.INSTANCE.meter_end();
                }
            }
            return CommonConstants.INSTANCE.settings_validation_meter_unknown();
        }

        @Override
        public boolean validate(Object value) {
            if (!super.validate(value)) {
                return false;
            }
            long thisLevel = Long.parseLong(value.toString());
            long lowerLevel = this.getLevelValue(this.level - 1);
            long upperLevel = this.getLevelValue(this.level + 1);
            this.lowerOk = thisLevel >= lowerLevel;
            this.upperOk = thisLevel <= upperLevel;
            return this.lowerOk && this.upperOk;
        }

        @Override
        public String getValidatorErrorMessage() {
            if (!this.lowerOk) {
                return CommonConstants.INSTANCE.settings_validation_meter_higher(this.getLevelDescr(this.level - 1));
            }
            if (!this.upperOk) {
                return CommonConstants.INSTANCE.settings_validation_meter_lower(this.getLevelDescr(this.level + 1));
            }
            return CommonConstants.INSTANCE.settings_validation_meter_invalid();
        }
    }

    public class DoubleValidator
    implements PropertyFieldValidator {
        public boolean validate(Object value) {
            try {
                Double.parseDouble(value.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getValidatorErrorMessage() {
            return CommonConstants.INSTANCE.settings_validation_double();
        }
    }

    public class LongValidator
    implements PropertyFieldValidator {
        public boolean validate(Object value) {
            try {
                Long.parseLong(value.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getValidatorErrorMessage() {
            return CommonConstants.INSTANCE.settings_validation_integer();
        }
    }

    static interface Binder
    extends UiBinder<Widget, DisplayerSettingsEditor> {
    }

    public static interface Listener {
        public void displayerSettingsChanged(DisplayerSettings var1);
    }
}

