/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.filter.ColumnFilterEditor;

@Dependent
public class DataSetFilterEditor
extends Composite
implements ColumnFilterEditor.Listener {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    Listener listener = null;
    DataSetFilter filter = null;
    DataSetMetadata metadata = null;
    @UiField
    ListBox newFilterListBox;
    @UiField
    Panel filterListPanel;
    @UiField
    Button addFilterButton;
    @UiField
    Panel addFilterPanel;
    @UiField
    Icon filterDeleteIcon;

    public DataSetFilterEditor() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.filterDeleteIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetFilterEditor.this.onNewFilterClosed(event);
            }
        }, ClickEvent.getType());
    }

    public void init(DataSetMetadata metadata, DataSetFilter filter, Listener listener) {
        this.metadata = metadata;
        this.filter = filter;
        this.listener = listener;
        this.addFilterButton.setVisible(true);
        this.addFilterPanel.setVisible(false);
        this.initNewFilterListBox();
        this.filterListPanel.clear();
        if (filter != null) {
            for (ColumnFilter columnFilter : filter.getColumnFilterList()) {
                ColumnFilterEditor columnFilterEditor = new ColumnFilterEditor();
                columnFilterEditor.init(metadata, columnFilter, this);
                this.filterListPanel.add((Widget)columnFilterEditor);
            }
        }
    }

    protected void initNewFilterListBox() {
        this.newFilterListBox.clear();
        this.newFilterListBox.addItem(CommonConstants.INSTANCE.filter_editor_selectcolumn());
        if (this.metadata != null) {
            for (int i = 0; i < this.metadata.getNumberOfColumns(); ++i) {
                this.newFilterListBox.addItem(this.metadata.getColumnId(i));
            }
        }
    }

    @UiHandler(value={"addFilterButton"})
    public void onAddFilterClicked(ClickEvent event) {
        this.addFilterButton.setVisible(false);
        this.addFilterPanel.setVisible(true);
    }

    public void onNewFilterClosed(ClickEvent event) {
        this.addFilterButton.setVisible(true);
        this.addFilterPanel.setVisible(false);
    }

    @UiHandler(value={"newFilterListBox"})
    public void onNewFilterSelected(ChangeEvent changeEvent) {
        int selectedIdx = this.newFilterListBox.getSelectedIndex();
        if (selectedIdx > 0) {
            ColumnType columnType;
            String columnId = this.metadata.getColumnId(selectedIdx - 1);
            CoreFunctionFilter columnFilter = FilterFactory.createCoreFunctionFilter((String)columnId, (ColumnType)columnType, (CoreFunctionType)(ColumnType.DATE.equals((Object)(columnType = this.metadata.getColumnType(selectedIdx - 1))) ? CoreFunctionType.TIME_FRAME : CoreFunctionType.NOT_EQUALS_TO));
            if (this.filter == null) {
                this.filter = new DataSetFilter();
            }
            this.filter.addFilterColumn(new ColumnFilter[]{columnFilter});
            ColumnFilterEditor columnFilterEditor = new ColumnFilterEditor();
            columnFilterEditor.init(this.metadata, (ColumnFilter)columnFilter, this);
            columnFilterEditor.expand();
            this.filterListPanel.add((Widget)columnFilterEditor);
            this.newFilterListBox.setSelectedIndex(0);
            this.addFilterPanel.setVisible(false);
            this.addFilterButton.setVisible(true);
            this.columnFilterChanged(columnFilterEditor);
        }
    }

    @Override
    public void columnFilterDeleted(ColumnFilterEditor editor) {
        this.addFilterButton.setVisible(true);
        this.addFilterPanel.setVisible(false);
        this.filterListPanel.remove((Widget)editor);
        Integer index = this.filter.getColumnFilterIdx(editor.getFilter());
        if (index != null) {
            this.filter.getColumnFilterList().remove(index);
            if (this.listener != null) {
                this.listener.filterChanged(this.filter);
            }
        }
    }

    @Override
    public void columnFilterChanged(ColumnFilterEditor editor) {
        if (this.listener != null) {
            this.listener.filterChanged(this.filter);
        }
    }

    static interface Binder
    extends UiBinder<Widget, DataSetFilterEditor> {
    }

    public static interface Listener {
        public void filterChanged(DataSetFilter var1);
    }
}

