/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerHelper;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.prototypes.DisplayerPrototypes;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerSettingsEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerTypeSelector;

@Dependent
public class DisplayerEditor
implements IsWidget,
DisplayerTypeSelector.Listener,
DataSetLookupEditor.Listener,
DisplayerSettingsEditor.Listener {
    protected View view = null;
    protected Listener listener = null;
    protected DisplayerSettings displayerSettings = null;
    protected boolean brandNewDisplayer = true;

    @Inject
    public DisplayerEditor(View view) {
        this.view = view;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void init(DisplayerSettings settings, Listener editorListener) {
        this.listener = editorListener;
        if (settings != null) {
            this.brandNewDisplayer = false;
            this.displayerSettings = settings;
            this.view.init(this.displayerSettings, this);
        } else {
            this.brandNewDisplayer = true;
            this.displayerSettings = DisplayerPrototypes.get().getProto(DisplayerType.BARCHART);
            this.displayerSettings.setTitle("- " + CommonConstants.INSTANCE.displayer_editor_new() + " -");
            this.view.init(this.displayerSettings, this);
            this.view.gotoTypeSelection();
        }
    }

    public boolean isBrandNewDisplayer() {
        return this.brandNewDisplayer;
    }

    public View getView() {
        return this.view;
    }

    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    public void save() {
        this.view.close();
        Displayer displayer = DisplayerHelper.lookupDisplayer(this.displayerSettings);
        DisplayerConstraints displayerConstraints = displayer.getDisplayerConstraints();
        displayerConstraints.removeUnsupportedAttributes(this.displayerSettings);
        if (this.listener != null) {
            this.listener.onSave(this);
        }
    }

    public void close() {
        this.view.close();
        if (this.listener != null) {
            this.listener.onClose(this);
        }
    }

    public void fetchDataSetLookup() {
        try {
            String uuid = this.displayerSettings.getDataSetLookup().getDataSetUUID();
            DataSetClientServices.get().fetchMetadata(uuid, new DataSetMetadataCallback(){

                public void callback(DataSetMetadata metadata) {
                    Displayer displayer = DisplayerLocator.get().lookupDisplayer(DisplayerEditor.this.displayerSettings);
                    DataSetLookupConstraints constraints = displayer.getDisplayerConstraints().getDataSetLookupConstraints();
                    DisplayerEditor.this.view.updateDataSetLookup(constraints, metadata);
                }

                public void notFound() {
                    DisplayerEditor.this.view.error(CommonConstants.INSTANCE.displayer_editor_dataset_notfound());
                }

                public boolean onError(ClientRuntimeError error) {
                    DisplayerEditor.this.view.error(error);
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.view.error(new ClientRuntimeError(CommonConstants.INSTANCE.displayer_editor_datasetmetadata_fetcherror(), (Throwable)e));
        }
    }

    @Override
    public void displayerSettingsChanged(DisplayerSettings settings) {
        this.displayerSettings = settings;
        this.view.init(this.displayerSettings, this);
    }

    @Override
    public void displayerTypeChanged(DisplayerType type, DisplayerSubType displayerSubType) {
        DisplayerSettings oldSettings = this.displayerSettings;
        DisplayerSettings newSettings = DisplayerPrototypes.get().getProto(type);
        newSettings.setSubtype(displayerSubType);
        DataSet oldDataSet = oldSettings.getDataSet();
        DataSetLookup oldDataLookup = oldSettings.getDataSetLookup();
        if (oldDataSet == null && oldDataLookup != null) {
            DataSetMetadata metadata;
            Displayer displayer = DisplayerHelper.lookupDisplayer(newSettings);
            DisplayerConstraints displayerConstraints = displayer.getDisplayerConstraints();
            DataSetLookupConstraints dataConstraints = displayerConstraints.getDataSetLookupConstraints();
            ValidationError validationError = dataConstraints.check(oldDataLookup, metadata = DataSetClientServices.get().getMetadata(oldDataLookup.getDataSetUUID()));
            if (validationError == null) {
                newSettings.setDataSet(null);
                newSettings.setDataSetLookup(oldDataLookup);
                this.changeSettings(oldSettings, newSettings);
            } else {
                this.view.showTypeChangedWarning(oldSettings, newSettings);
            }
        } else {
            this.changeSettings(oldSettings, newSettings);
        }
    }

    public void changeSettings(DisplayerSettings oldSettings, DisplayerSettings newSettings) {
        oldSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.TYPE);
        oldSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.SUBTYPE);
        oldSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.CHART_GROUP);
        oldSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.CHART_MARGIN_GROUP);
        oldSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.CHART_LEGEND_GROUP);
        oldSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.AXIS_GROUP);
        newSettings.getSettingsFlatMap().putAll(oldSettings.getSettingsFlatMap());
        try {
            DisplayerHelper.lookupDisplayer(newSettings);
        }
        catch (Exception e) {
            newSettings.removeDisplayerSetting(DisplayerAttributeDef.RENDERER);
        }
        this.displayerSettings = newSettings;
        this.removeStaleSettings();
        this.view.init(this.displayerSettings, this);
    }

    @Override
    public void dataSetChanged(String uuid) {
        try {
            DataSetClientServices.get().fetchMetadata(uuid, new DataSetMetadataCallback(){

                public void callback(DataSetMetadata metadata) {
                    Displayer displayer = DisplayerLocator.get().lookupDisplayer(DisplayerEditor.this.displayerSettings);
                    DataSetLookupConstraints constraints = displayer.getDisplayerConstraints().getDataSetLookupConstraints();
                    DataSetLookup lookup = constraints.newDataSetLookup(metadata);
                    if (lookup == null) {
                        DisplayerEditor.this.view.error(CommonConstants.INSTANCE.displayer_editor_dataset_nolookuprequest());
                    }
                    DisplayerEditor.this.displayerSettings.setDataSet(null);
                    DisplayerEditor.this.displayerSettings.setDataSetLookup(lookup);
                    DisplayerEditor.this.removeStaleSettings();
                    DisplayerEditor.this.view.updateDataSetLookup(constraints, metadata);
                }

                public void notFound() {
                    DisplayerEditor.this.view.error(CommonConstants.INSTANCE.displayer_editor_dataset_notfound());
                }

                public boolean onError(ClientRuntimeError error) {
                    DisplayerEditor.this.view.error(error);
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.view.error(new ClientRuntimeError(CommonConstants.INSTANCE.displayer_editor_datasetmetadata_fetcherror(), (Throwable)e));
        }
    }

    @Override
    public void groupChanged(DataSetGroup groupOp) {
        this.removeStaleSettings();
        this.view.init(this.displayerSettings, this);
    }

    @Override
    public void columnChanged(GroupFunction groupFunction) {
        this.removeStaleSettings();
        this.view.init(this.displayerSettings, this);
    }

    @Override
    public void filterChanged(DataSetFilter filterOp) {
        this.view.init(this.displayerSettings, this);
    }

    public void removeStaleSettings() {
        List<String> columnIds = this.getExistingDataColumnIds();
        Iterator it = this.displayerSettings.getColumnSettingsList().iterator();
        while (it.hasNext()) {
            ColumnSettings columnSettings = (ColumnSettings)it.next();
            if (columnIds.contains(columnSettings.getColumnId())) continue;
            it.remove();
        }
        if (!columnIds.contains(this.displayerSettings.getTableDefaultSortColumnId())) {
            this.displayerSettings.setTableDefaultSortColumnId(null);
        }
    }

    public List<String> getExistingDataColumnIds() {
        ArrayList<String> columnIds;
        block3: {
            int idx;
            DataSetLookup dataSetLookup;
            block2: {
                DataSet dataSet = this.displayerSettings.getDataSet();
                dataSetLookup = this.displayerSettings.getDataSetLookup();
                columnIds = new ArrayList<String>();
                if (dataSet == null) break block2;
                for (DataColumn dataColumn : dataSet.getColumns()) {
                    columnIds.add(dataColumn.getId());
                }
                break block3;
            }
            if (dataSetLookup == null || (idx = dataSetLookup.getLastGroupOpIndex(0)) == -1) break block3;
            DataSetGroup groupOp = (DataSetGroup)dataSetLookup.getOperation(idx);
            for (GroupFunction groupFunction : groupOp.getGroupFunctions()) {
                columnIds.add(groupFunction.getColumnId());
            }
        }
        return columnIds;
    }

    public static interface View
    extends IsWidget {
        public void init(DisplayerSettings var1, DisplayerEditor var2);

        public void disableTypeSelection();

        public void gotoTypeSelection();

        public void gotoDataSetConf();

        public void gotoDisplaySettings();

        public void updateDataSetLookup(DataSetLookupConstraints var1, DataSetMetadata var2);

        public void showTypeChangedWarning(DisplayerSettings var1, DisplayerSettings var2);

        public void error(String var1);

        public void error(ClientRuntimeError var1);

        public void close();
    }

    public static interface Listener {
        public void onClose(DisplayerEditor var1);

        public void onSave(DisplayerEditor var1);
    }
}

