/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerCoordinatorTest
extends AbstractDisplayerTest {
    DisplayerSettings byDepartment = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("AMOUNT", AggregateFunctionType.SUM)).sort("DEPARTMENT", SortOrder.ASCENDING)).filterOn(false, true, true)).buildSettings();
    DisplayerSettings byYear = ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("expenses")).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.SUM)).filterOn(false, true, true)).sort("CREATION_DATE", SortOrder.ASCENDING)).buildSettings();
    DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).column("DEPARTMENT")).column("CITY")).column("EMPLOYEE")).column("AMOUNT")).column("CREATION_DATE")).filterOn(true, false, true)).buildSettings();
    DisplayerCoordinator displayerCoordinator;
    AbstractDisplayer allRowsTable;
    AbstractDisplayer deptPieChart;
    AbstractDisplayer yearBarChart;
    @Mock
    DisplayerListener listener;

    @Override
    @Before
    public void init() throws Exception {
        super.init();
        this.allRowsTable = this.createNewDisplayer(this.allRows);
        this.deptPieChart = this.createNewDisplayer(this.byDepartment);
        this.yearBarChart = this.createNewDisplayer(this.byYear);
        this.displayerCoordinator = new DisplayerCoordinator(this.rendererManager);
        this.displayerCoordinator.addDisplayers(new Displayer[]{this.allRowsTable, this.deptPieChart, this.yearBarChart});
        this.displayerCoordinator.addListener(new DisplayerListener[]{this.listener});
    }

    @Test
    public void testDrawAll() {
        this.displayerCoordinator.drawAll();
        ((DisplayerListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)3))).onDataLookup((Displayer)Mockito.any(Displayer.class));
        ((DisplayerListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)3))).onDraw((Displayer)Mockito.any(Displayer.class));
    }

    @Test
    public void testFilterPropagations() {
        this.displayerCoordinator.drawAll();
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        this.deptPieChart.filterUpdate("DEPARTMENT", 0);
        DataSet dataSet = this.allRowsTable.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)19L);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)this.allRowsTable);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onRedraw((Displayer)this.allRowsTable);
    }

    @Test
    public void testFilterWithNull() {
        DataSet expensesDataSet = this.clientDataSetManager.getDataSet("expenses");
        int column = expensesDataSet.getColumnIndex(expensesDataSet.getColumnById("DEPARTMENT"));
        expensesDataSet.setValueAt(0, column, null);
        this.displayerCoordinator.drawAll();
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        this.deptPieChart.filterUpdate("DEPARTMENT", 1);
        DataSet dataSet = this.allRowsTable.getDataSetHandler().getLastDataSet();
        ((DisplayerListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onError((Displayer)Mockito.any(Displayer.class), (ClientRuntimeError)Mockito.any(ClientRuntimeError.class));
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)this.allRowsTable);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onRedraw((Displayer)this.allRowsTable);
        Assert.assertEquals((long)dataSet.getRowCount(), (long)18L);
    }

    @Test
    public void testFullTableFilterEvent() {
        AbstractDisplayer tableNoColumns = this.createNewDisplayer(((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filterOn(true, false, true)).buildSettings());
        this.displayerCoordinator = new DisplayerCoordinator(this.rendererManager);
        this.displayerCoordinator.addDisplayers(new Displayer[]{this.deptPieChart, tableNoColumns});
        this.displayerCoordinator.addListener(new DisplayerListener[]{this.listener});
        this.displayerCoordinator.drawAll();
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        this.deptPieChart.filterUpdate("DEPARTMENT", 0);
        DataSet dataSet = this.allRowsTable.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)19L);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)this.allRowsTable);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onRedraw((Displayer)tableNoColumns);
    }
}

