/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.google.web.bindery.event.shared.HandlerRegistration;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DisplayerEditor;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;
import org.uberfire.mvp.Command;

@Dependent
public class DisplayerEditorPopup
extends BaseModal {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField(provided=true)
    DisplayerEditor editor;
    private HandlerRegistration showHandlerRegistration;
    private String editDisplayerTitle = CommonConstants.INSTANCE.displayer_editor_title();
    private String newDisplayerTitle = CommonConstants.INSTANCE.displayer_editor_new();

    @Inject
    public DisplayerEditorPopup(DisplayerEditor editor) {
        this.editor = editor;
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        ModalFooterOKCancelButtons footer = this.createModalFooterOKCancelButtons();
        footer.enableCancelButton(true);
        footer.enableOkButton(true);
        this.add((Widget)footer);
        this.setWidth("1200px");
    }

    public DisplayerEditorPopup init(DisplayerSettings settings) {
        ModalShownHandler shownHandler = this.createShownHandler(settings);
        this.showHandlerRegistration = this.addShownHandler(shownHandler);
        this.show();
        return this;
    }

    public DisplayerSettings getDisplayerSettings() {
        return this.editor.getDisplayerSettings();
    }

    public void setNewDisplayerTitle(String newDisplayerTitle) {
        this.newDisplayerTitle = newDisplayerTitle;
    }

    public void setEditDisplayerTitle(String editDisplayerTitle) {
        this.editDisplayerTitle = editDisplayerTitle;
    }

    public void setOnSaveCommand(Command saveCommand) {
        this.editor.setOnSaveCommand(saveCommand);
    }

    public void setOnCloseCommand(Command closeCommand) {
        this.editor.setOnCloseCommand(closeCommand);
    }

    protected ModalShownHandler createShownHandler(final DisplayerSettings settings) {
        return new ModalShownHandler(){

            public void onShown(ModalShownEvent modalShownEvent) {
                DisplayerEditorPopup.this.editor.init(settings);
                DisplayerEditorPopup.this.setTitle(DisplayerEditorPopup.this.editor.isBrandNewDisplayer() ? DisplayerEditorPopup.this.newDisplayerTitle : DisplayerEditorPopup.this.editDisplayerTitle);
                DisplayerEditorPopup.this.removeShownHandler();
            }
        };
    }

    protected void removeShownHandler() {
        if (this.showHandlerRegistration != null) {
            this.showHandlerRegistration.removeHandler();
            this.showHandlerRegistration = null;
        }
    }

    protected ModalFooterOKCancelButtons createModalFooterOKCancelButtons() {
        return new ModalFooterOKCancelButtons(new com.google.gwt.user.client.Command(){

            public void execute() {
                DisplayerEditorPopup.this.hide();
                DisplayerEditorPopup.this.editor.save();
            }
        }, new com.google.gwt.user.client.Command(){

            public void execute() {
                DisplayerEditorPopup.this.hide();
                DisplayerEditorPopup.this.editor.close();
            }
        });
    }

    static interface Binder
    extends UiBinder<ModalBody, DisplayerEditorPopup> {
    }
}

