/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerTypeLiterals;
import org.dashbuilder.displayer.client.widgets.DisplayerTypeSelector;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;

@Dependent
public class DisplayerTypeSelectorView
extends Composite
implements DisplayerTypeSelector.View {
    private static ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);
    Map<DisplayerType, String> displayerNames = new HashMap<DisplayerType, String>();
    @UiField
    NavTabs navTabs;
    @UiField
    TabPane displayerSubTypePane;
    DisplayerTypeSelector presenter;

    public void init(DisplayerTypeSelector presenter) {
        this.presenter = presenter;
        this.displayerNames.put(DisplayerType.BARCHART, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_bar());
        this.displayerNames.put(DisplayerType.PIECHART, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_pie());
        this.displayerNames.put(DisplayerType.LINECHART, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_line());
        this.displayerNames.put(DisplayerType.AREACHART, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_area());
        this.displayerNames.put(DisplayerType.BUBBLECHART, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_bubble());
        this.displayerNames.put(DisplayerType.METERCHART, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_meter());
        this.displayerNames.put(DisplayerType.METRIC, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_metric());
        this.displayerNames.put(DisplayerType.MAP, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_map());
        this.displayerNames.put(DisplayerType.TABLE, DisplayerTypeLiterals.INSTANCE.displayer_type_selector_tab_table());
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.displayerSubTypePane.add((IsWidget)presenter.getSubtypeSelector());
        this.displayerSubTypePane.setActive(true);
    }

    @Override
    public void clear() {
        this.navTabs.clear();
    }

    @Override
    public void show(DisplayerType type) {
        String displayerName = this.displayerNames.get(type);
        DisplayerTab tab = new DisplayerTab(displayerName, type);
        tab.setDataTargetWidget((Widget)this.displayerSubTypePane);
        this.navTabs.add((Widget)tab);
    }

    @Override
    public void select(DisplayerType type) {
        for (int i = 0; i < this.navTabs.getWidgetCount(); ++i) {
            DisplayerTab tab = (DisplayerTab)this.navTabs.getWidget(i);
            tab.setActive(tab.type.equals((Object)type));
        }
    }

    private class DisplayerTab
    extends TabListItem {
        String name;
        DisplayerType type;

        public DisplayerTab(String name, final DisplayerType type) {
            super(name);
            this.name = name;
            this.type = type;
            super.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    event.stopPropagation();
                    if (!DisplayerTypeSelectorView.this.presenter.getSelectedType().equals((Object)type)) {
                        DisplayerTypeSelectorView.this.presenter.onSelect(type);
                    }
                }
            });
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, DisplayerTypeSelectorView> {
    }
}

