/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import java.util.Arrays;
import org.dashbuilder.displayer.client.widgets.filter.MultipleTextParameterEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleTextParameterEditorTest {
    MultipleTextParameterEditor presenter;
    @Mock
    MultipleTextParameterEditor.View view;
    @Mock
    Command changedEvent;

    @Before
    public void init() {
        this.presenter = new MultipleTextParameterEditor(this.view);
    }

    @Test
    public void testShowSingleValue() {
        this.presenter.setValues(Arrays.asList("val"));
        ((MultipleTextParameterEditor.View)Mockito.verify((Object)this.view)).setValue("val");
    }

    @Test
    public void testShowMultipleValues() {
        this.presenter.setValues(Arrays.asList("val1", "val2", "val3"));
        ((MultipleTextParameterEditor.View)Mockito.verify((Object)this.view)).setValue("val1 | val2 | val3");
    }

    @Test
    public void testParseVoidInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"");
        this.presenter.valueChanged();
        Assert.assertTrue((boolean)this.presenter.getValues().isEmpty());
        ((MultipleTextParameterEditor.View)Mockito.verify((Object)this.view)).error();
    }

    @Test
    public void testParseSingleInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"val");
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)1L);
        Assert.assertEquals(this.presenter.getValues().get(0), (Object)"val");
    }

    @Test
    public void testMultipleInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"|1| 2 | 3|4|  ");
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)4L);
        Assert.assertEquals(this.presenter.getValues().get(0), (Object)"1");
        Assert.assertEquals(this.presenter.getValues().get(1), (Object)"2");
        Assert.assertEquals(this.presenter.getValues().get(2), (Object)"3");
        Assert.assertEquals(this.presenter.getValues().get(3), (Object)"4");
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)4L);
    }

    @Test
    public void testMultipleInput2() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)",1, 2 , 3,4,  ");
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)4L);
        Assert.assertEquals(this.presenter.getValues().get(0), (Object)"1");
        Assert.assertEquals(this.presenter.getValues().get(1), (Object)"2");
        Assert.assertEquals(this.presenter.getValues().get(2), (Object)"3");
        Assert.assertEquals(this.presenter.getValues().get(3), (Object)"4");
    }
}

