/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.ClientDataSetManager;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.formatter.ValueFormatter;
import org.dashbuilder.displayer.client.formatter.ValueFormatterRegistry;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;

@ApplicationScoped
public class DisplayerLocator {
    private DataSetClientServices clientServices;
    private ClientDataSetManager clientDataSetManager;
    private ValueFormatterRegistry formatterRegistry;
    private RendererManager rendererManager;

    @Inject
    public DisplayerLocator(DataSetClientServices clientServices, ClientDataSetManager clientDataSetManager, RendererManager rendererManager, ValueFormatterRegistry formatterRegistry) {
        this.clientServices = clientServices;
        this.clientDataSetManager = clientDataSetManager;
        this.rendererManager = rendererManager;
        this.formatterRegistry = formatterRegistry;
    }

    public Displayer lookupDisplayer(DisplayerSettings target) {
        RendererLibrary renderer = this.rendererManager.getRendererForDisplayer(target);
        Displayer displayer = renderer.lookupDisplayer(target);
        if (displayer == null) {
            String rendererUuid = target.getRenderer();
            if (StringUtils.isBlank((String)rendererUuid)) {
                throw new RuntimeException(CommonConstants.INSTANCE.displayerlocator_default_renderer_undeclared(target.getType().toString()));
            }
            throw new RuntimeException(CommonConstants.INSTANCE.displayerlocator_unsupported_displayer_renderer(target.getType().toString(), rendererUuid));
        }
        displayer.setDisplayerSettings(target);
        DataSetLookup dataSetLookup = target.getDataSetLookup();
        if (target.getDataSet() != null) {
            DataSet dataSet = target.getDataSet();
            this.clientDataSetManager.registerDataSet(dataSet);
            dataSetLookup = new DataSetLookup(dataSet.getUUID(), new DataSetOp[0]);
        }
        DataSetHandlerImpl handler = new DataSetHandlerImpl(this.clientServices, dataSetLookup);
        displayer.setDataSetHandler(handler);
        this.setValueFormatters(displayer);
        return displayer;
    }

    protected void setValueFormatters(Displayer displayer) {
        Map<String, ValueFormatter> m = this.formatterRegistry.get(displayer.getDisplayerSettings().getUUID());
        for (String columnId : m.keySet()) {
            displayer.addFormatter(columnId, m.get(columnId));
        }
    }
}

