/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.prototypes;

import java.util.EnumMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.prototypes.DataSetPrototypes;
import org.dashbuilder.displayer.impl.AreaChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.BubbleChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.LineChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.MapChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.MeterChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.MetricSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;

@ApplicationScoped
public class DisplayerPrototypes {
    protected DataSetPrototypes dataSetPrototypes;
    protected UUIDGenerator uuidGenerator;
    protected Map<DisplayerType, DisplayerSettings> prototypeMap = new EnumMap<DisplayerType, DisplayerSettings>(DisplayerType.class);

    @Inject
    public DisplayerPrototypes(DataSetPrototypes dataSetPrototypes, UUIDGenerator uuidGenerator) {
        this.dataSetPrototypes = dataSetPrototypes;
        this.uuidGenerator = uuidGenerator;
        this.init();
    }

    public void init() {
        this.prototypeMap.put(DisplayerType.PIECHART, ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("pieChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).width(500)).height(300)).margins(10, 10, 10, 100)).legendOn("right")).set3d(true).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.BARCHART, ((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().subType_Bar()).uuid("barChartPrototype")).dataset(this.dataSetPrototypes.getTopRichCountries())).title("Top Rich Countries")).titleVisible(false)).column("Country")).format("Country")).column("GDP 2013")).format("2013", "$ #,### M")).column("GDP 2014")).format("2014", "$ #,### M")).width(500)).height(250)).margins(10, 40, 100, 50)).legendOn("right")).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.LINECHART, ((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)DisplayerSettingsFactory.newLineChartSettings().uuid("lineChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).width(500)).height(300)).margins(10, 40, 90, 10)).legendOff()).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.AREACHART, ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().uuid("areaChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).width(500)).height(300)).margins(10, 40, 90, 10)).legendOff()).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.BUBBLECHART, ((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)((BubbleChartSettingsBuilderImpl)DisplayerSettingsFactory.newBubbleChartSettings().uuid("bubbleChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulationExt())).title("Population per Continent")).titleVisible(false)).width(500)).height(300)).margins(10, 30, 50, 10)).legendOff()).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.METERCHART, ((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)((MeterChartSettingsBuilderImpl)DisplayerSettingsFactory.newMeterChartSettings().uuid("meterChartPrototype")).dataset(this.dataSetPrototypes.getContinentPopulation())).title("Population per Continent")).titleVisible(false)).width(400)).height(300)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).margins(10, 10, 10, 10)).meter(0L, 1000L, 3000L, 6000L).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.METRIC, ((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)((MetricSettingsBuilderImpl)DisplayerSettingsFactory.newMetricSettings().uuid("metricPrototype")).dataset(this.dataSetPrototypes.getTotalPopulation())).title("World population")).titleVisible(true)).width(300)).height(150)).margins(30, 30, 30, 30)).backgroundColor("B5F2D3")).filterOn(false, false, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.MAP, ((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)((MapChartSettingsBuilderImpl)DisplayerSettingsFactory.newMapChartSettings().uuid("mapChartPrototype")).dataset(this.dataSetPrototypes.getCountryPopulation())).title("World Population")).titleVisible(false)).width(500)).height(300)).margins(10, 10, 10, 10)).filterOn(false, true, true)).buildSettings());
        this.prototypeMap.put(DisplayerType.TABLE, ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().uuid("tablePrototype")).dataset(this.dataSetPrototypes.getWorldPopulation())).title("Population per Continent")).titleVisible(false)).column("Population")).expression("value/1000000")).format("Population", "#,### M")).tableOrderEnabled(true).tableOrderDefault("Population", SortOrder.DESCENDING).tablePageSize(8).filterOn(false, true, true)).buildSettings());
    }

    public DisplayerSettings getProto(DisplayerType type) {
        DisplayerSettings proto = this.prototypeMap.get(type).cloneInstance();
        proto.setUUID(this.uuidGenerator.newUuid());
        return proto;
    }
}

