/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import java.lang.annotation.Annotation;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.widgets.filter.TimeAmountEditor;
import org.dashbuilder.displayer.client.widgets.filter.TimeFrameEditor;
import org.dashbuilder.displayer.client.widgets.filter.TimeInstantEditor;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class TimeFrameEditorTest {
    @Mock
    SyncBeanManager beanManager;
    @Mock
    Command changeCommand;
    @Mock
    TimeFrameEditor.View timeFrameView;
    @Mock
    TimeAmountEditor.View timeAmountView;
    @Mock
    TimeInstantEditor.View timeInstantView;
    TimeAmountEditor fromAmountEditor;
    TimeAmountEditor toAmountEditor;
    TimeInstantEditor fromInstantEditor;
    TimeInstantEditor toInstantEditor;
    TimeFrameEditor timeFrameEditor;
    public static final TimeFrame TEN_DAYS = TimeFrame.parse((String)"begin[year March] till 10day");
    public static final TimeFrame LAST_DAY = TimeFrame.parse((String)"now -1day till now");
    public static final TimeFrame CURRENT_YEAR = TimeFrame.parse((String)"begin[year] till end[year]");
    public static final TimeFrame UNDEFINED = null;

    @Before
    public void init() {
        this.fromAmountEditor = new TimeAmountEditor(this.timeAmountView);
        this.toAmountEditor = new TimeAmountEditor(this.timeAmountView);
        this.fromInstantEditor = new TimeInstantEditor(this.timeInstantView, this.fromAmountEditor);
        this.toInstantEditor = new TimeInstantEditor(this.timeInstantView, this.toAmountEditor);
        this.timeFrameEditor = new TimeFrameEditor(this.timeFrameView, this.beanManager);
        IOCBeanDef tieBeanDef = (IOCBeanDef)Mockito.mock(IOCBeanDef.class);
        Mockito.when((Object)this.beanManager.lookupBean(TimeInstantEditor.class, new Annotation[0])).thenReturn((Object)tieBeanDef);
        Mockito.when((Object)tieBeanDef.newInstance()).thenReturn((Object)this.fromInstantEditor, new Object[]{this.toInstantEditor});
    }

    @Test
    public void testViewInitialization() {
        this.timeFrameEditor.init(TEN_DAYS, this.changeCommand);
        Assert.assertEquals((Object)this.timeFrameView, (Object)this.timeFrameEditor.view);
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView)).init((Object)this.timeFrameEditor);
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView)).clearFirstMonthSelector();
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView, (VerificationMode)Mockito.times((int)Month.values().length))).addFirstMonthItem((Month)Mockito.any(Month.class));
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView)).setSelectedFirstMonthIndex(Month.MARCH.getIndex() - 1);
    }

    @Test
    public void testNullInitialization() {
        this.timeFrameEditor.init(UNDEFINED, this.changeCommand);
        Assert.assertEquals((Object)this.timeFrameView, (Object)this.timeFrameEditor.view);
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView)).init((Object)this.timeFrameEditor);
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView)).clearFirstMonthSelector();
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView, (VerificationMode)Mockito.times((int)Month.values().length))).addFirstMonthItem((Month)Mockito.any(Month.class));
        ((TimeFrameEditor.View)Mockito.verify((Object)this.timeFrameView)).setSelectedFirstMonthIndex(Month.JANUARY.getIndex() - 1);
    }

    @Test
    public void testChangeTimeAmountQuantity() {
        TimeFrame timeFrame = TimeFrame.parse((String)"now -1year till now");
        this.timeFrameEditor.init(timeFrame, this.changeCommand);
        long qb = timeFrame.getFrom().getTimeAmount().getQuantity();
        this.fromAmountEditor.decreaseQuantity();
        long qa = timeFrame.getFrom().getTimeAmount().getQuantity();
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
        Assert.assertEquals((long)(qb - 1L), (long)qa);
    }

    @Test
    public void testChangeTimeAmountType() {
        TimeFrame timeFrame = TimeFrame.parse((String)"now -1year till now");
        this.timeFrameEditor.init(timeFrame, this.changeCommand);
        Mockito.when((Object)this.timeAmountView.getSelectedTypeIndex()).thenReturn((Object)3);
        this.fromAmountEditor.changeIntervalType();
        DateIntervalType type = timeFrame.getFrom().getTimeAmount().getType();
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
        Assert.assertEquals((Object)type, (Object)DateIntervalType.DAY);
    }

    @Test
    public void testChangeTimeInstant() {
        TimeFrame timeFrame = TimeFrame.parse((String)"now -1year till now");
        this.timeFrameEditor.init(timeFrame, this.changeCommand);
        Mockito.when((Object)this.timeInstantView.getSelectedIntervalTypeIndex()).thenReturn((Object)3);
        this.fromInstantEditor.changeIntervalType();
        DateIntervalType type = timeFrame.getFrom().getIntervalType();
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
        Assert.assertEquals((Object)type, (Object)DateIntervalType.MONTH);
    }

    @Test
    public void testFirstMonthAvailable() {
        this.timeFrameEditor.init(CURRENT_YEAR, this.changeCommand);
        Assert.assertEquals((Object)this.timeFrameEditor.isFirstMonthAvailable(), (Object)true);
    }

    @Test
    public void testFirstMonthUnavailable() {
        this.timeFrameEditor.init(LAST_DAY, this.changeCommand);
        Assert.assertEquals((Object)this.timeFrameEditor.isFirstMonthAvailable(), (Object)false);
    }
}

