/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.export.ExportCallback;
import org.dashbuilder.displayer.client.export.ExportFormat;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerExportTest
extends AbstractDisplayerTest {
    DisplayerSettings EMPTY = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filter("CITY", new ColumnFilter[]{FilterFactory.isNull()})).buildSettings();
    DisplayerSettings ALLROWS = ((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).buildSettings();
    @Mock
    ExportCallback exportCallback;

    @Test
    public void testExportDisplayer() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.draw();
        displayer.export(ExportFormat.CSV, -1, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).exportFileUrl(Mockito.anyString());
    }

    @Test
    public void testExportNonDrawnDisplayer() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.export(ExportFormat.CSV, -1, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).noData();
    }

    @Test
    public void testExportEmptyDisplayer() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.EMPTY);
        displayer.draw();
        displayer.export(ExportFormat.CSV, -1, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).noData();
    }

    @Test
    public void testExportLimitExceeded() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.draw();
        displayer.export(ExportFormat.CSV, 10, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).tooManyRows(50);
    }

    @Test
    public void testExportLimitRuledOut() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.draw();
        displayer.export(ExportFormat.CSV, 0, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback, (VerificationMode)Mockito.never())).tooManyRows(Mockito.anyInt());
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).exportFileUrl(Mockito.anyString());
    }
}

