/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.util.List;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.client.AbstractDataSetTest;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerEvaluatorMock;
import org.dashbuilder.displayer.client.DisplayerFormatterMock;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.DisplayerMock;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.formatter.ValueFormatterRegistry;
import org.junit.Before;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractDisplayerTest
extends AbstractDataSetTest {
    @Mock
    protected RendererManager rendererManager;
    @Mock
    protected RendererLibrary rendererLibrary;
    @Mock
    protected ValueFormatterRegistry formatterRegistry;
    protected DisplayerLocator displayerLocator;

    @Before
    public void init() throws Exception {
        super.init();
        this.displayerLocator = new DisplayerLocator(this.clientServices, this.clientDataSetManager, this.rendererManager, this.formatterRegistry);
        Mockito.when((Object)this.rendererManager.getRendererForDisplayer((DisplayerSettings)Mockito.any(DisplayerSettings.class))).thenReturn((Object)this.rendererLibrary);
        ((RendererLibrary)Mockito.doAnswer(mock -> this.createNewDisplayer((DisplayerSettings)mock.getArguments()[0])).when((Object)this.rendererLibrary)).lookupDisplayer((DisplayerSettings)Mockito.any(DisplayerSettings.class));
        ((RendererLibrary)Mockito.doAnswer(mock -> this.createNewDisplayer((DisplayerSettings)mock.getArguments()[0])).when((Object)this.rendererLibrary)).lookupDisplayer((DisplayerSettings)Mockito.any(DisplayerSettings.class));
        ((RendererLibrary)Mockito.doAnswer(mock -> {
            List displayerList = (List)mock.getArguments()[0];
            for (Displayer displayer : displayerList) {
                displayer.draw();
            }
            return null;
        }).when((Object)this.rendererLibrary)).draw(Mockito.anyListOf(Displayer.class));
    }

    public AbstractDisplayer createNewDisplayer(DisplayerSettings settings) {
        return this.initDisplayer(new DisplayerMock((AbstractDisplayer.View)Mockito.mock(AbstractDisplayer.View.class), null), settings);
    }

    public <D extends AbstractDisplayer> D initDisplayer(D displayer, DisplayerSettings settings) {
        displayer.setEvaluator((AbstractDisplayer.ExpressionEval)new DisplayerEvaluatorMock());
        displayer.setFormatter((AbstractDisplayer.Formatter)new DisplayerFormatterMock());
        displayer.addListener(new DisplayerListener[]{new AbstractDisplayerListener(){

            public void onError(Displayer displayer, ClientRuntimeError error) {
                throw new RuntimeException(error.getRootCause());
            }
        }});
        if (settings != null) {
            displayer.setDisplayerSettings(settings);
            displayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.clientServices, settings.getDataSetLookup()));
        }
        return displayer;
    }
}

