/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.client.events.DataSetFilterChangedEvent;
import org.dashbuilder.displayer.client.events.DataSetGroupDateChanged;
import org.dashbuilder.displayer.client.events.DataSetLookupChangedEvent;
import org.dashbuilder.displayer.client.events.GroupFunctionChangedEvent;
import org.dashbuilder.displayer.client.events.GroupFunctionDeletedEvent;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.dashbuilder.displayer.client.widgets.group.ColumnFunctionEditor;
import org.dashbuilder.displayer.client.widgets.group.DataSetGroupDateEditor;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class DataSetLookupEditor
implements IsWidget {
    View view;
    SyncBeanManager beanManager;
    DataSetClientServices clientServices;
    DataSetFilterEditor filterEditor;
    DataSetGroupDateEditor groupDateEditor;
    DataSetLookup dataSetLookup = null;
    DataSetLookupConstraints lookupConstraints = null;
    DataSetMetadata dataSetMetadata = null;
    Event<DataSetLookupChangedEvent> changeEvent = null;
    List<DataSetDef> _dataSetDefList = new ArrayList<DataSetDef>();
    Map<Integer, ColumnFunctionEditor> _editorsMap = new HashMap<Integer, ColumnFunctionEditor>();
    DataSetDefFilter dataSetDefFilter = new DataSetDefFilter(){

        @Override
        public boolean accept(DataSetDef def) {
            return true;
        }
    };

    @Inject
    public DataSetLookupEditor(View view, SyncBeanManager beanManager, DataSetFilterEditor filterEditor, DataSetGroupDateEditor groupDateEditor, DataSetClientServices clientServices, Event<DataSetLookupChangedEvent> event) {
        this.view = view;
        this.beanManager = beanManager;
        this.filterEditor = filterEditor;
        this.groupDateEditor = groupDateEditor;
        this.clientServices = clientServices;
        this.changeEvent = event;
        this.dataSetLookup = null;
        this.lookupConstraints = null;
        this.dataSetMetadata = null;
        view.init(this);
    }

    public void init(DataSetLookupConstraints lookupConstraints, final DataSetLookup dataSetLookup) {
        this.dataSetLookup = dataSetLookup;
        this.lookupConstraints = lookupConstraints;
        this.view.clearAll();
        this.clientServices.getPublicDataSetDefs((RemoteCallback)new RemoteCallback<List<DataSetDef>>(){

            public void callback(List<DataSetDef> dataSetDefs) {
                DataSetLookupEditor.this.showDataSetDefs(dataSetDefs);
                if (dataSetLookup != null && dataSetLookup.getDataSetUUID() != null) {
                    DataSetLookupEditor.this.fetchMetadata(dataSetLookup.getDataSetUUID(), new RemoteCallback<DataSetMetadata>(){

                        public void callback(DataSetMetadata metadata) {
                            DataSetLookupEditor.this.updateDataSetLookup();
                        }
                    });
                }
            }
        });
    }

    void fetchMetadata(final String uuid, final RemoteCallback<DataSetMetadata> callback) {
        try {
            this.clientServices.fetchMetadata(uuid, new DataSetMetadataCallback(){

                public void callback(DataSetMetadata metadata) {
                    DataSetLookupEditor.this.dataSetMetadata = metadata;
                    callback.callback((Object)metadata);
                }

                public void notFound() {
                    DataSetLookupEditor.this.view.errorDataSetNotFound(uuid);
                }

                public boolean onError(ClientRuntimeError error) {
                    DataSetLookupEditor.this.view.error(error);
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.view.error(new ClientRuntimeError((Throwable)e));
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public View getView() {
        return this.view;
    }

    public DataSetFilterEditor getFilterEditor() {
        return this.filterEditor;
    }

    public DataSetGroupDateEditor getGroupDateEditor() {
        return this.groupDateEditor;
    }

    public DataSetLookup getDataSetLookup() {
        return this.dataSetLookup;
    }

    public DataSetLookupConstraints getLookupConstraints() {
        return this.lookupConstraints;
    }

    public void setDataSetDefFilter(DataSetDefFilter dataSetDefFilter) {
        this.dataSetDefFilter = dataSetDefFilter;
    }

    public String getDataSetUUID() {
        return this.dataSetLookup == null ? null : this.dataSetLookup.getDataSetUUID();
    }

    public String getColumnId(int index) {
        return this.dataSetMetadata.getColumnId(index);
    }

    public ColumnType getColumnType(int index) {
        return this.dataSetMetadata.getColumnType(index);
    }

    public ColumnType getColumnType(String columnId) {
        return columnId == null ? null : this.dataSetMetadata.getColumnType(columnId);
    }

    public DataSetGroup getFirstGroupOp() {
        List groupOpList = this.dataSetLookup.getOperationList(DataSetGroup.class);
        if (groupOpList.isEmpty()) {
            return null;
        }
        return (DataSetGroup)groupOpList.get(0);
    }

    public boolean isFirstGroupOpDateBased() {
        DataSetGroup first = this.getFirstGroupOp();
        if (first == null) {
            return false;
        }
        ColumnGroup cg = first.getColumnGroup();
        if (cg == null) {
            return false;
        }
        ColumnType type = this.getColumnType(cg.getSourceId());
        return ColumnType.DATE.equals((Object)type);
    }

    public List<GroupFunction> getFirstGroupFunctions() {
        List groupOpList = this.dataSetLookup.getOperationList(DataSetGroup.class);
        if (groupOpList.isEmpty()) {
            return null;
        }
        return ((DataSetGroup)groupOpList.get(0)).getGroupFunctions();
    }

    public int getFirstGroupFunctionIdx(GroupFunction gf) {
        List groupOpList = this.dataSetLookup.getOperationList(DataSetGroup.class);
        if (groupOpList.isEmpty()) {
            return -1;
        }
        return ((DataSetGroup)groupOpList.get(0)).getGroupFunctionIdx(gf);
    }

    public String getFirstGroupColumnId() {
        List groupOpList = this.dataSetLookup.getOperationList(DataSetGroup.class);
        if (groupOpList.isEmpty()) {
            return null;
        }
        DataSetGroup groupOp = (DataSetGroup)groupOpList.get(0);
        if (groupOp.getColumnGroup() == null) {
            return null;
        }
        return groupOp.getColumnGroup().getSourceId();
    }

    public List<Integer> getAvailableGroupColumnIdxs() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < this.dataSetMetadata.getNumberOfColumns(); ++i) {
            ColumnType columnType = this.dataSetMetadata.getColumnType(i);
            if (!ColumnType.LABEL.equals((Object)columnType) && !ColumnType.DATE.equals((Object)columnType)) continue;
            result.add(i);
        }
        return result;
    }

    public void showDataSetDefs(List<DataSetDef> ds) {
        this._dataSetDefList.clear();
        this.view.clearDataSetSelector();
        String selectedUUID = this.getDataSetUUID();
        if (StringUtils.isBlank((String)selectedUUID)) {
            this.view.enableDataSetSelectorHint();
        }
        boolean found = false;
        for (int i = 0; i < ds.size(); ++i) {
            DataSetDef def = ds.get(i);
            if (!this.dataSetDefFilter.accept(def)) continue;
            this.addDataSetDef(def);
            if (selectedUUID == null || !selectedUUID.equals(def.getUUID())) continue;
            this.view.setSelectedDataSetIndex(i);
            found = true;
        }
        if (!StringUtils.isBlank((String)selectedUUID) && !found) {
            this.view.errorDataSetNotFound(selectedUUID);
        }
    }

    public void addDataSetDef(DataSetDef def) {
        this._dataSetDefList.add(def);
        if (StringUtils.isBlank((String)def.getName())) {
            this.view.addDataSetItem(def.getUUID(), def.getUUID());
        } else {
            this.view.addDataSetItem(def.getName(), def.getUUID());
        }
    }

    public void removeDataSetDef(DataSetDef def) {
        int i = 0;
        Iterator<DataSetDef> it = this._dataSetDefList.iterator();
        while (it.hasNext()) {
            DataSetDef item = it.next();
            if (item.getUUID().equals(def.getUUID())) {
                it.remove();
                this.view.removeDataSetItem(i);
            }
            ++i;
        }
    }

    void updateDataSetLookup() {
        this.view.setFilterEnabled(false);
        this.view.setGroupEnabled(false);
        this.view.setColumnsSectionEnabled(false);
        if (this.dataSetLookup != null && this.dataSetMetadata != null && this.lookupConstraints != null) {
            this.updateFilterControls();
            this.updateGroupControls();
            this.updateColumnControls();
        }
    }

    void updateFilterControls() {
        this.view.setFilterEnabled(this.lookupConstraints.isFilterAllowed());
        this.filterEditor.init(this.dataSetLookup.getFirstFilterOp(), this.dataSetMetadata);
    }

    void updateGroupControls() {
        this.view.setGroupEnabled(false);
        this.view.setGroupByDateEnabled(false);
        if (this.lookupConstraints.isGroupRequired() || this.lookupConstraints.isGroupAllowed()) {
            String groupColumnId = this.getFirstGroupColumnId();
            if (this.lookupConstraints.isGroupRequired() && groupColumnId == null) {
                this.dataSetLookup = this.lookupConstraints.newDataSetLookup(this.dataSetMetadata);
                this.changeEvent.fire((Object)new DataSetLookupChangedEvent(this.dataSetLookup));
            }
            List<Integer> groupColumnIdxs = this.getAvailableGroupColumnIdxs();
            String rowsTitle = this.lookupConstraints.getGroupsTitle();
            this.view.setGroupEnabled(true);
            if (this.isFirstGroupOpDateBased()) {
                this.view.setGroupByDateEnabled(true);
                ColumnGroup columnGroup = this.getFirstGroupOp().getColumnGroup();
                this.groupDateEditor.init(columnGroup);
            }
            if (!StringUtils.isBlank((String)rowsTitle)) {
                this.view.setGroupColumnSelectorTitle(rowsTitle);
            }
            this.view.clearGroupColumnSelector();
            if (!this.lookupConstraints.isGroupRequired()) {
                this.view.enableGroupColumnSelectorHint();
            }
            for (int i = 0; i < groupColumnIdxs.size(); ++i) {
                int idx = groupColumnIdxs.get(i);
                String columnId = this.getColumnId(idx);
                this.view.addGroupColumnItem(columnId);
                if (groupColumnId == null || !groupColumnId.equals(columnId)) continue;
                this.view.setSelectedGroupColumnIndex(i);
            }
        }
    }

    void updateColumnControls() {
        String groupColumnId = this.getFirstGroupColumnId();
        List<GroupFunction> groupFunctions = this.getFirstGroupFunctions();
        String columnsTitle = this.lookupConstraints.getColumnsTitle();
        boolean functionsRequired = this.lookupConstraints.isFunctionRequired();
        boolean functionsEnabled = groupColumnId != null || functionsRequired;
        boolean canDelete = groupFunctions.size() > this.lookupConstraints.getMinColumns();
        int n = this.lookupConstraints.getMaxColumns();
        boolean canAdd = this.lookupConstraints.areExtraColumnsAllowed() && (n < 0 || groupFunctions.size() < n);
        this.view.setColumnsSectionEnabled(true);
        this.view.clearColumnList();
        if (!StringUtils.isBlank((String)columnsTitle)) {
            this.view.setColumnSectionTitle(columnsTitle);
        }
        this.view.setAddColumnOptionEnabled(canAdd);
        for (ColumnFunctionEditor editor : this._editorsMap.values()) {
            this.beanManager.destroyBean((Object)editor);
        }
        this._editorsMap.clear();
        ColumnType lastTargetType = null;
        ColumnType[] targetTypes = this.lookupConstraints.getColumnTypes(groupFunctions.size());
        for (int i = 0; i < groupFunctions.size(); ++i) {
            int columnIdx = i;
            GroupFunction groupFunction = groupFunctions.get(columnIdx);
            if (targetTypes != null && i < targetTypes.length) {
                lastTargetType = targetTypes[i];
            }
            if (columnIdx == 0 && groupColumnId != null && this.lookupConstraints.isGroupColumn()) continue;
            ColumnType columnType = null;
            if (targetTypes != null && i < targetTypes.length) {
                columnType = targetTypes[columnIdx];
            }
            if (columnType == null) {
                columnType = lastTargetType;
            }
            String columnTitle = this.lookupConstraints.getColumnTitle(Integer.valueOf(columnIdx));
            ColumnFunctionEditor columnEditor = (ColumnFunctionEditor)this.beanManager.lookupBean(ColumnFunctionEditor.class, new Annotation[0]).newInstance();
            columnEditor.init(this.dataSetMetadata, groupFunction, columnType, columnTitle, functionsEnabled, canDelete);
            this._editorsMap.put(this._editorsMap.size(), columnEditor);
            this.view.addColumnEditor(columnEditor);
        }
    }

    int getGroupFunctionLastIdx(List<GroupFunction> groupFunctions, String sourceId) {
        int last = -1;
        for (GroupFunction gf : groupFunctions) {
            if (!gf.getSourceId().equals(sourceId)) continue;
            int idx = this.getGroupFunctionColumnIdx(gf.getColumnId());
            if (last != -1 && last >= idx) continue;
            last = idx;
        }
        return last;
    }

    int getGroupFunctionColumnIdx(String columnId) {
        int sep = columnId.lastIndexOf(95);
        if (sep != -1) {
            try {
                String str = columnId.substring(sep + 1);
                return Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    void onDataSetSelected() {
        String selectedUUID = this.view.getSelectedDataSetId();
        for (DataSetDef dataSetDef : this._dataSetDefList) {
            if (!dataSetDef.getUUID().equals(selectedUUID)) continue;
            this.fetchMetadata(selectedUUID, new RemoteCallback<DataSetMetadata>(){

                public void callback(DataSetMetadata metadata) {
                    DataSetLookupEditor.this.dataSetLookup = DataSetLookupEditor.this.lookupConstraints.newDataSetLookup(metadata);
                    DataSetLookupEditor.this.updateDataSetLookup();
                    DataSetLookupEditor.this.changeEvent.fire((Object)new DataSetLookupChangedEvent(DataSetLookupEditor.this.dataSetLookup));
                }
            });
        }
    }

    void onGroupColumnSelected() {
        DataSetGroup groupOp = this.getFirstGroupOp();
        if (groupOp != null) {
            String columnId = this.view.getSelectedGroupColumnId();
            if (columnId == null) {
                groupOp.setColumnGroup(null);
                if (this.lookupConstraints.isGroupColumn()) {
                    groupOp.getGroupFunctions().remove(0);
                }
                if (!this.lookupConstraints.isFunctionRequired()) {
                    for (GroupFunction groupFunction : groupOp.getGroupFunctions()) {
                        groupFunction.setFunction(null);
                    }
                }
            } else {
                groupOp.setColumnGroup(new ColumnGroup(columnId, columnId));
                if (this.lookupConstraints.isGroupColumn()) {
                    if (groupOp.getGroupFunctions().size() > 1) {
                        groupOp.getGroupFunctions().remove(0);
                    }
                    GroupFunction groupFunction = new GroupFunction(columnId, columnId, null);
                    groupOp.getGroupFunctions().add(0, groupFunction);
                }
            }
        }
        this.view.setGroupByDateEnabled(false);
        if (this.isFirstGroupOpDateBased()) {
            this.view.setGroupByDateEnabled(true);
            ColumnGroup columnGroup = this.getFirstGroupOp().getColumnGroup();
            this.groupDateEditor.init(columnGroup);
        }
        this.updateColumnControls();
        this.changeEvent.fire((Object)new DataSetLookupChangedEvent(this.dataSetLookup));
    }

    void onAddColumn() {
        if (this.lookupConstraints.areExtraColumnsAllowed()) {
            DataSetGroup op = this.getFirstGroupOp();
            List functionList = op.getGroupFunctions();
            GroupFunction last = (GroupFunction)functionList.get(functionList.size() - 1);
            GroupFunction clone = last.cloneInstance();
            String newColumnId = this.lookupConstraints.buildUniqueColumnId(this.dataSetLookup, clone);
            clone.setColumnId(newColumnId);
            functionList.add(clone);
            this.updateColumnControls();
            this.changeEvent.fire((Object)new DataSetLookupChangedEvent(this.dataSetLookup));
        }
    }

    void onFilterChanged(@Observes DataSetFilterChangedEvent event) {
        DataSetFilter filterOp = event.getFilter();
        this.dataSetLookup.removeOperations(DataSetOpType.FILTER);
        if (filterOp != null) {
            this.dataSetLookup.addOperation(0, new DataSetOp[]{filterOp});
        }
        this.changeEvent.fire((Object)new DataSetLookupChangedEvent(this.dataSetLookup));
    }

    void onDateGroupChanged(@Observes DataSetGroupDateChanged event) {
        ColumnGroup columnGroup = event.getColumnGroup();
        DataSetGroup groupOp = this.getFirstGroupOp();
        if (groupOp != null) {
            groupOp.setColumnGroup(columnGroup);
            this.changeEvent.fire((Object)new DataSetLookupChangedEvent(this.dataSetLookup));
        }
    }

    void onColumnFunctionChanged(@Observes GroupFunctionChangedEvent event) {
        GroupFunction gf = event.getGroupFunction();
        String newColumnId = this.lookupConstraints.buildUniqueColumnId(this.dataSetLookup, gf);
        gf.setColumnId(newColumnId);
        this.changeEvent.fire((Object)new DataSetLookupChangedEvent(this.dataSetLookup));
    }

    void onColumnFunctionDeleted(@Observes GroupFunctionDeletedEvent event) {
        List<GroupFunction> functionList = this.getFirstGroupFunctions();
        boolean canDelete = functionList.size() > this.lookupConstraints.getMinColumns();
        GroupFunction removed = event.getGroupFunction();
        int index = this.getFirstGroupFunctionIdx(removed);
        if (canDelete && index >= 0) {
            functionList.remove(index);
            this.updateColumnControls();
            this.changeEvent.fire((Object)new DataSetLookupChangedEvent(this.dataSetLookup));
        }
    }

    void onDataSetDefRegisteredEvent(@Observes DataSetDefRegisteredEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.addDataSetDef(event.getDataSetDef());
    }

    void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.removeDataSetDef(event.getOldDataSetDef());
        this.addDataSetDef(event.getNewDataSetDef());
    }

    void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        this.removeDataSetDef(event.getDataSetDef());
    }

    public static interface DataSetDefFilter {
        public boolean accept(DataSetDef var1);
    }

    public static interface View
    extends UberView<DataSetLookupEditor> {
        public void clearAll();

        public void clearDataSetSelector();

        public void enableDataSetSelectorHint();

        public void addDataSetItem(String var1, String var2);

        public void removeDataSetItem(int var1);

        public void setSelectedDataSetIndex(int var1);

        public String getSelectedDataSetId();

        public void error(ClientRuntimeError var1);

        public void errorDataSetNotFound(String var1);

        public void setFilterEnabled(boolean var1);

        public void setGroupEnabled(boolean var1);

        public void clearGroupColumnSelector();

        public void setGroupByDateEnabled(boolean var1);

        public void setGroupColumnSelectorTitle(String var1);

        public void enableGroupColumnSelectorHint();

        public void addGroupColumnItem(String var1);

        public void setSelectedGroupColumnIndex(int var1);

        public String getSelectedGroupColumnId();

        public void setColumnsSectionEnabled(boolean var1);

        public void clearColumnList();

        public void setColumnSectionTitle(String var1);

        public void setAddColumnOptionEnabled(boolean var1);

        public void addColumnEditor(ColumnFunctionEditor var1);

        public void removeColumnEditor(ColumnFunctionEditor var1);
    }
}

