/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.group;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.displayer.client.events.DataSetGroupDateChanged;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DataSetGroupDateEditor
implements IsWidget {
    View view = null;
    ColumnGroup columnGroup = null;
    Event<DataSetGroupDateChanged> changeEvent = null;

    @Inject
    public DataSetGroupDateEditor(View view, Event<DataSetGroupDateChanged> changeEvent) {
        this.view = view;
        this.changeEvent = changeEvent;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public ColumnGroup getColumnGroup() {
        return this.columnGroup;
    }

    public void init(ColumnGroup columnGroup) {
        this.columnGroup = columnGroup;
        if (columnGroup != null) {
            if (this.isFixedStrategy()) {
                this.gotoFixedMode();
            } else {
                this.gotoDynamicMode();
            }
        }
    }

    public boolean isFixedStrategy() {
        return GroupStrategy.FIXED.equals((Object)this.columnGroup.getStrategy());
    }

    protected void initIntervalTypeSelector() {
        this.view.clearIntervalTypeSelector();
        DateIntervalType current = DateIntervalType.getByName((String)this.columnGroup.getIntervalSize());
        List<DateIntervalType> entries = this.getListOfIntervalTypes();
        for (int i = 0; i < entries.size(); ++i) {
            DateIntervalType entry = entries.get(i);
            this.view.addIntervalTypeItem(entry);
            if (current == null || !current.equals((Object)entry)) continue;
            this.view.setSelectedIntervalTypeIndex(i);
        }
    }

    public List<DateIntervalType> getListOfIntervalTypes() {
        if (this.isFixedStrategy()) {
            return DateIntervalType.FIXED_INTERVALS_SUPPORTED;
        }
        return Arrays.asList(DateIntervalType.values());
    }

    protected void initFirstDayListBox() {
        this.view.setFirstDayVisibility(true);
        this.view.clearFirstDaySelector();
        DayOfWeek current = this.columnGroup.getFirstDayOfWeek();
        DayOfWeek[] entries = DayOfWeek.values();
        for (int i = 0; i < entries.length; ++i) {
            DayOfWeek entry = entries[i];
            this.view.addFirstDaySelectorItem(entry);
            if (current == null || !current.equals((Object)entry)) continue;
            this.view.setSelectedFirstDayIndex(i);
        }
    }

    protected void initFirstMonthListBox() {
        this.view.setFirstMonthVisibility(true);
        this.view.clearFirstMonthSelector();
        Month current = this.columnGroup.getFirstMonthOfYear();
        Month[] entries = Month.values();
        for (int i = 0; i < entries.length; ++i) {
            Month entry = entries[i];
            this.view.addFirstMonthSelectorItem(entry);
            if (current == null || !current.equals((Object)entry)) continue;
            this.view.setSelectedFirstMonthIndex(i);
        }
    }

    protected void initMaxIntervalsTextBox() {
        this.view.setMaxIntervalsVisibility(true);
        this.view.setMaxIntervalsValue(Integer.toString(this.columnGroup.getMaxIntervals()));
    }

    protected void initEmptyIntervalsFlag() {
        this.view.setEmptyIntervalsValue(this.columnGroup.areEmptyIntervalsAllowed());
    }

    protected void resetCommon() {
        this.view.setFixedModeValue(this.isFixedStrategy());
        this.view.setMaxIntervalsVisibility(false);
        this.view.setFirstDayVisibility(false);
        this.view.setFirstMonthVisibility(false);
        this.initIntervalTypeSelector();
        this.initEmptyIntervalsFlag();
    }

    public void gotoDynamicMode() {
        this.resetCommon();
        this.initMaxIntervalsTextBox();
    }

    public void gotoFixedMode() {
        this.resetCommon();
        DateIntervalType current = DateIntervalType.getByName((String)this.columnGroup.getIntervalSize());
        if (DateIntervalType.DAY_OF_WEEK.equals((Object)current)) {
            this.initFirstDayListBox();
        } else if (DateIntervalType.MONTH.equals((Object)current)) {
            this.initFirstMonthListBox();
        }
    }

    public void onFixedStrategyChanged() {
        this.columnGroup.setFirstMonthOfYear(null);
        this.columnGroup.setFirstDayOfWeek(null);
        if (this.view.getFixedModeValue()) {
            DateIntervalType intervalType = DateIntervalType.getByIndex((int)this.view.getSelectedIntervalTypeIndex());
            if (!DateIntervalType.FIXED_INTERVALS_SUPPORTED.contains(intervalType)) {
                this.view.setSelectedIntervalTypeIndex(DateIntervalType.MONTH.getIndex());
                this.columnGroup.setIntervalSize(DateIntervalType.MONTH.name());
            }
            this.columnGroup.setStrategy(GroupStrategy.FIXED);
            this.gotoFixedMode();
        } else {
            this.columnGroup.setStrategy(GroupStrategy.DYNAMIC);
            this.gotoDynamicMode();
        }
        this.changeEvent.fire((Object)new DataSetGroupDateChanged(this.columnGroup));
    }

    void onIntervalTypeSelected() {
        DateIntervalType intervalType = DateIntervalType.getByIndex((int)this.view.getSelectedIntervalTypeIndex());
        if (this.isFixedStrategy()) {
            intervalType = (DateIntervalType)DateIntervalType.FIXED_INTERVALS_SUPPORTED.get(this.view.getSelectedIntervalTypeIndex());
        }
        this.columnGroup.setIntervalSize(intervalType.name());
        this.columnGroup.setFirstMonthOfYear(null);
        this.columnGroup.setFirstDayOfWeek(null);
        this.view.setFirstMonthVisibility(false);
        this.view.setFirstDayVisibility(false);
        if (GroupStrategy.FIXED.equals((Object)this.columnGroup.getStrategy())) {
            if (DateIntervalType.MONTH.equals((Object)DateIntervalType.getByName((String)this.columnGroup.getIntervalSize()))) {
                this.view.setFirstMonthVisibility(true);
                this.initFirstMonthListBox();
            } else if (DateIntervalType.DAY_OF_WEEK.equals((Object)DateIntervalType.getByName((String)this.columnGroup.getIntervalSize()))) {
                this.view.setFirstDayVisibility(true);
                this.initFirstDayListBox();
            }
        }
        this.changeEvent.fire((Object)new DataSetGroupDateChanged(this.columnGroup));
    }

    void onEmptyIntervalsChanged() {
        this.columnGroup.setEmptyIntervalsAllowed(this.view.getEmptyIntervalsValue());
        this.changeEvent.fire((Object)new DataSetGroupDateChanged(this.columnGroup));
    }

    void onMaxIntervalsChanged() {
        try {
            this.columnGroup.setMaxIntervals(Integer.parseInt(this.view.getMaxIntervalsValue()));
            this.changeEvent.fire((Object)new DataSetGroupDateChanged(this.columnGroup));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onFirstDaySelected() {
        DayOfWeek dayOfWeek = DayOfWeek.getByIndex((int)(this.view.getSelectedFirstDayIndex() + 1));
        this.columnGroup.setFirstDayOfWeek(dayOfWeek);
        this.changeEvent.fire((Object)new DataSetGroupDateChanged(this.columnGroup));
    }

    void onFirstMonthSelected() {
        Month month = Month.getByIndex((int)(this.view.getSelectedFirstMonthIndex() + 1));
        this.columnGroup.setFirstMonthOfYear(month);
        this.changeEvent.fire((Object)new DataSetGroupDateChanged(this.columnGroup));
    }

    public static interface View
    extends UberView<DataSetGroupDateEditor> {
        public void setFixedModeValue(boolean var1);

        public boolean getFixedModeValue();

        public void clearIntervalTypeSelector();

        public void addIntervalTypeItem(DateIntervalType var1);

        public void setSelectedIntervalTypeIndex(int var1);

        public int getSelectedIntervalTypeIndex();

        public void setFirstDayVisibility(boolean var1);

        public void clearFirstDaySelector();

        public void addFirstDaySelectorItem(DayOfWeek var1);

        public void setSelectedFirstDayIndex(int var1);

        public int getSelectedFirstDayIndex();

        public void setFirstMonthVisibility(boolean var1);

        public void clearFirstMonthSelector();

        public void addFirstMonthSelectorItem(Month var1);

        public void setSelectedFirstMonthIndex(int var1);

        public int getSelectedFirstMonthIndex();

        public void setEmptyIntervalsValue(boolean var1);

        public boolean getEmptyIntervalsValue();

        public void setMaxIntervalsVisibility(boolean var1);

        public void setMaxIntervalsValue(String var1);

        public String getMaxIntervalsValue();
    }
}

