/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.date.TimeInstant;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.widgets.filter.TimeAmountEditor;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class TimeInstantEditor
implements IsWidget {
    static List<DateIntervalType> INTERVAL_TYPES = Arrays.asList(DateIntervalType.MINUTE, DateIntervalType.HOUR, DateIntervalType.DAY, DateIntervalType.MONTH, DateIntervalType.QUARTER, DateIntervalType.YEAR, DateIntervalType.CENTURY, DateIntervalType.MILLENIUM);
    View view;
    TimeInstant timeInstant = null;
    TimeAmountEditor timeAmountEditor = null;
    Command onChangeCommand = new Command(){

        public void execute() {
        }
    };

    @Inject
    public TimeInstantEditor(View view, TimeAmountEditor timeAmountEditor) {
        this.timeAmountEditor = timeAmountEditor;
        this.timeInstant = new TimeInstant();
        this.view = view;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public TimeInstant getTimeInstant() {
        return this.timeInstant;
    }

    public void init(TimeInstant ti, final Command onChangeCommand) {
        this.timeInstant = ti != null ? ti : new TimeInstant();
        this.onChangeCommand = onChangeCommand;
        this.timeAmountEditor.init(this.timeInstant.getTimeAmount(), new Command(){

            public void execute() {
                TimeInstantEditor.this.timeInstant.setTimeAmount(TimeInstantEditor.this.timeAmountEditor.getTimeAmount());
                onChangeCommand.execute();
            }
        });
        this.initTimeModeSelector();
        this.initIntervalTypeSelector();
    }

    public TimeAmountEditor getTimeAmountEditor() {
        return this.timeAmountEditor;
    }

    protected void initTimeModeSelector() {
        this.view.clearTimeModeSelector();
        TimeInstant.TimeMode current = this.timeInstant.getTimeMode();
        TimeInstant.TimeMode[] modes = TimeInstant.TimeMode.values();
        for (int i = 0; i < modes.length; ++i) {
            TimeInstant.TimeMode mode = modes[i];
            this.view.addTimeModeItem(mode);
            if (current == null || !current.equals((Object)mode)) continue;
            this.view.setSelectedTimeModeIndex(i);
        }
    }

    protected void initIntervalTypeSelector() {
        this.view.disableIntervalTypeSelector();
        TimeInstant.TimeMode timeMode = this.timeInstant.getTimeMode();
        if (timeMode != null && !timeMode.equals((Object)TimeInstant.TimeMode.NOW)) {
            this.view.enableIntervalTypeSelector();
            this.view.clearIntervalTypeSelector();
            DateIntervalType current = this.timeInstant.getIntervalType();
            for (int i = 0; i < INTERVAL_TYPES.size(); ++i) {
                DateIntervalType type = INTERVAL_TYPES.get(i);
                this.view.addIntervalTypeItem(type);
                if (current == null || !current.equals((Object)type)) continue;
                this.view.setSelectedIntervalTypeIndex(i);
            }
        }
    }

    void changeTimeMode() {
        int selectedIdx = this.view.getTimeModeSelectedIndex();
        TimeInstant.TimeMode mode = TimeInstant.TimeMode.getByIndex((int)selectedIdx);
        this.timeInstant.setTimeMode(mode);
        TimeAmount timeAmount = this.timeInstant.getTimeAmount();
        if (timeAmount != null) {
            timeAmount.setQuantity(0L);
        }
        this.onChangeCommand.execute();
        this.initIntervalTypeSelector();
    }

    void changeIntervalType() {
        int selectedIdx = this.view.getSelectedIntervalTypeIndex();
        DateIntervalType intervalType = INTERVAL_TYPES.get(selectedIdx);
        this.timeInstant.setIntervalType(intervalType);
        this.onChangeCommand.execute();
        this.initIntervalTypeSelector();
    }

    public static interface View
    extends UberView<TimeInstantEditor> {
        public void clearTimeModeSelector();

        public void addTimeModeItem(TimeInstant.TimeMode var1);

        public void setSelectedTimeModeIndex(int var1);

        public int getTimeModeSelectedIndex();

        public void enableIntervalTypeSelector();

        public void disableIntervalTypeSelector();

        public void clearIntervalTypeSelector();

        public void addIntervalTypeItem(DateIntervalType var1);

        public void setSelectedIntervalTypeIndex(int var1);

        public int getSelectedIntervalTypeIndex();
    }
}

