/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractErraiDisplayer;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.resources.i18n.DisplayerConstants;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.jboss.errai.ui.client.local.api.IsElement;

public abstract class AbstractErraiDisplayerView<P extends AbstractErraiDisplayer>
implements AbstractErraiDisplayer.View<P>,
IsElement {
    private Element panel = DOM.createDiv();
    private Element label = DOM.createLabel();
    private Element visualization = null;
    private Timer refreshTimer = null;
    protected P presenter = null;
    protected Widget asWidget = ElementWrapperWidget.getWidget((Element)this.panel);

    public void setPresenter(P presenter) {
        this.presenter = presenter;
    }

    public P getPresenter() {
        return this.presenter;
    }

    public void setVisualization(Element element) {
        this.visualization = element;
    }

    @Override
    public void setId(String id) {
        this.panel.setId(id);
    }

    public Widget asWidget() {
        return this.asWidget;
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)((Node)this.panel));
        ElementWrapperWidget.removeWidget((Element)this.panel);
    }

    @Override
    public void showLoading() {
        this.displayMessage(DisplayerConstants.INSTANCE.initializing());
    }

    @Override
    public void showVisualization() {
        if (this.visualization != null) {
            DOMUtil.removeAllChildren((Node)((Node)this.panel));
            this.panel.appendChild((com.google.gwt.dom.client.Node)this.visualization);
        }
    }

    @Override
    public void errorMissingSettings() {
        this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_settings_unset());
    }

    @Override
    public void errorMissingHandler() {
        this.displayMessage(DisplayerConstants.INSTANCE.error() + DisplayerConstants.INSTANCE.error_handler_unset());
    }

    @Override
    public void errorDataSetNotFound(String dataSetUUID) {
        this.displayMessage(CommonConstants.INSTANCE.dataset_lookup_dataset_notfound(dataSetUUID));
    }

    @Override
    public void error(ClientRuntimeError e) {
        this.displayMessage(DisplayerConstants.INSTANCE.error() + e.getMessage());
        if (e.getThrowable() != null) {
            GWT.log((String)e.getMessage(), (Throwable)e.getThrowable());
        } else {
            GWT.log((String)e.getMessage());
        }
    }

    @Override
    public void enableRefreshTimer(int seconds) {
        if (this.refreshTimer == null) {
            this.refreshTimer = new Timer(){

                public void run() {
                    if (((AbstractDisplayer)AbstractErraiDisplayerView.this.presenter).isDrawn()) {
                        ((AbstractDisplayer)AbstractErraiDisplayerView.this.presenter).redraw();
                    }
                }
            };
        }
        this.refreshTimer.schedule(seconds * 1000);
    }

    @Override
    public void cancelRefreshTimer() {
        if (this.refreshTimer != null) {
            this.refreshTimer.cancel();
        }
    }

    public void displayMessage(String msg) {
        DOMUtil.removeAllChildren((Node)((Node)this.panel));
        this.panel.appendChild((com.google.gwt.dom.client.Node)this.label);
        this.label.setInnerText(msg);
    }
}

