/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.dashbuilder.dataset.client.resources.i18n.CoreFunctionTypeConstants;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.displayer.client.widgets.filter.ColumnFilterEditor;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.kie.soup.commons.validation.PortablePreconditions;

public class ColumnFilterEditorView
extends Composite
implements ColumnFilterEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    ColumnFilterEditor presenter;
    boolean functionSelected = false;
    @UiField
    ListBox filterListBox;
    @UiField
    Icon filterDeleteIcon;
    @UiField
    Icon filterExpandIcon;
    @UiField
    Panel filterDetailsPanel;
    DateTimeFormat _dateTimeFormat = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_MEDIUM);
    NumberFormat _numberFormat = NumberFormat.getDecimalFormat();

    public void init(ColumnFilterEditor presenter) {
        this.presenter = (ColumnFilterEditor)PortablePreconditions.checkNotNull((String)"presenter", (Object)presenter);
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.filterExpandIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnFilterEditorView.this.onExpandCollapseDetails();
            }
        }, ClickEvent.getType());
        this.filterDeleteIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                ColumnFilterEditorView.this.onDeleteFilter();
            }
        }, ClickEvent.getType());
    }

    @Override
    public void clearFunctionSelector() {
        this.filterListBox.clear();
        this.functionSelected = false;
    }

    @Override
    public void addFunctionItem(CoreFunctionType ft) {
        String function = CoreFunctionTypeConstants.INSTANCE.getString(ft.name());
        this.filterListBox.addItem(function);
        this.filterExpandIcon.setVisible(true);
    }

    @Override
    public void setFunctionSelected(String function) {
        this.filterListBox.insertItem(function, 0);
        this.filterListBox.setTitle(function);
        if (this.functionSelected) {
            this.filterListBox.removeItem(1);
        }
        this.functionSelected = true;
    }

    @Override
    public int getSelectedFunctionIndex() {
        return this.filterListBox.getSelectedIndex() - (this.functionSelected ? 1 : 0);
    }

    @Override
    public void showFilterConfig() {
        this.filterExpandIcon.setVisible(true);
        this.filterExpandIcon.setType(IconType.ARROW_UP);
        this.filterDetailsPanel.setVisible(true);
    }

    public void hideParamConfigWidgets() {
        this.filterDetailsPanel.setVisible(false);
        this.filterExpandIcon.setType(IconType.ARROW_DOWN);
    }

    @Override
    public void addFilterConfigWidget(IsWidget widget) {
        this.filterDetailsPanel.add(widget);
        this.filterExpandIcon.setVisible(true);
    }

    @Override
    public void clearFilterConfig() {
        this.filterDetailsPanel.clear();
        this.filterDetailsPanel.setVisible(false);
        this.filterExpandIcon.setVisible(false);
    }

    @UiHandler(value={"filterListBox"})
    public void onFilterSelected(ChangeEvent changeEvent) {
        this.presenter.onSelectFilterFunction();
    }

    public void onExpandCollapseDetails() {
        if (this.filterDetailsPanel.isVisible()) {
            this.hideParamConfigWidgets();
        } else {
            this.showFilterConfig();
        }
    }

    protected void onDeleteFilter() {
        this.presenter.onDeleteFilter();
    }

    @Override
    public String formatDate(Date date) {
        return this._dateTimeFormat.format(date);
    }

    @Override
    public String formatNumber(Number number) {
        return this._numberFormat.format(number);
    }

    static interface Binder
    extends UiBinder<Widget, ColumnFilterEditorView> {
    }
}

