/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.filter.ColumnFilterEditor;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.ListBox;

public class DataSetFilterEditorView
extends Composite
implements DataSetFilterEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    ListBox newFilterListBox;
    @UiField
    Panel filterListPanel;
    @UiField
    Button addFilterButton;
    @UiField
    Panel addFilterPanel;
    @UiField
    Icon filterDeleteIcon;
    DataSetFilterEditor presenter = null;

    public DataSetFilterEditorView() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.filterDeleteIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                DataSetFilterEditorView.this.onNewFilterClosed(event);
            }
        }, ClickEvent.getType());
    }

    public void init(DataSetFilterEditor presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showNewFilterHome() {
        this.addFilterButton.setVisible(true);
        this.addFilterPanel.setVisible(false);
    }

    @Override
    public void clearColumnSelector() {
        this.newFilterListBox.clear();
        this.newFilterListBox.addItem(CommonConstants.INSTANCE.filter_editor_selectcolumn());
    }

    @Override
    public void showColumnSelector() {
        this.addFilterButton.setVisible(false);
        this.addFilterPanel.setVisible(true);
    }

    @Override
    public void addColumn(String column) {
        this.newFilterListBox.addItem(column);
    }

    @Override
    public int getSelectedColumnIndex() {
        return this.newFilterListBox.getSelectedIndex() - 1;
    }

    @Override
    public void resetSelectedColumn() {
        this.newFilterListBox.setSelectedIndex(0);
    }

    @Override
    public void clearColumnFilterEditors() {
        this.filterListPanel.clear();
    }

    @Override
    public void addColumnFilterEditor(ColumnFilterEditor editor) {
        this.filterListPanel.add((IsWidget)editor);
    }

    @Override
    public void removeColumnFilterEditor(ColumnFilterEditor editor) {
        this.filterListPanel.remove((IsWidget)editor);
    }

    @UiHandler(value={"addFilterButton"})
    public void onAddFilterClicked(ClickEvent event) {
        this.presenter.onNewFilterStart();
    }

    public void onNewFilterClosed(ClickEvent event) {
        this.presenter.onNewFilterCancel();
    }

    @UiHandler(value={"newFilterListBox"})
    public void onNewFilterSelected(ChangeEvent changeEvent) {
        this.presenter.onCreateFilter();
    }

    static interface Binder
    extends UiBinder<Widget, DataSetFilterEditorView> {
    }
}

