/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Arrays;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.events.DataSetLookupChangedEvent;
import org.dashbuilder.displayer.client.events.DisplayerEditorClosedEvent;
import org.dashbuilder.displayer.client.events.DisplayerEditorSavedEvent;
import org.dashbuilder.displayer.client.prototypes.DisplayerPrototypes;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorStatus;
import org.dashbuilder.displayer.client.widgets.DisplayerHtmlEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerSettingsEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerTypeSelector;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerEditorTest {
    @Mock
    DisplayerEditor.View view;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    DisplayerLocator displayerLocator;
    @Mock
    DisplayerTypeSelector typeSelector;
    @Mock
    DataSetLookupEditor lookupEditor;
    @Mock
    DisplayerSettingsEditor settingsEditor;
    @Mock
    DisplayerEditorStatus editorStatus;
    @Mock
    Event<DisplayerEditorSavedEvent> saveEvent;
    @Mock
    Event<DisplayerEditorClosedEvent> closeEvent;
    @Mock
    DisplayerSettings displayerSettings;
    @Mock
    DisplayerSettings tableSettings;
    @Mock
    Displayer displayer;
    @Mock
    DisplayerHtmlEditor displayerHtmlEditor;
    @Mock
    Displayer tableDisplayer;
    @Mock
    UUIDGenerator uuidGenerator;
    @Mock
    DisplayerPrototypes displayerPrototypes;
    @Mock
    DisplayerConstraints displayerConstraints;
    @Mock
    DataSetLookupConstraints lookupConstraints;
    DisplayerEditor presenter = null;

    @Before
    public void init() throws Exception {
        Mockito.when((Object)this.displayerPrototypes.getProto((DisplayerType)Mockito.any(DisplayerType.class), (DisplayerSubType)Mockito.any(DisplayerSubType.class))).thenReturn((Object)this.displayerSettings);
        Mockito.when((Object)this.displayerSettings.cloneInstance()).thenReturn((Object)this.tableSettings);
        Mockito.when((Object)this.displayerLocator.lookupDisplayer(this.displayerSettings)).thenReturn((Object)this.displayer);
        Mockito.when((Object)this.displayerLocator.lookupDisplayer(this.tableSettings)).thenReturn((Object)this.tableDisplayer);
        Mockito.when((Object)this.displayer.getDisplayerConstraints()).thenReturn((Object)this.displayerConstraints);
        Mockito.when((Object)this.displayerConstraints.getDataSetLookupConstraints()).thenReturn((Object)this.lookupConstraints);
        this.presenter = new DisplayerEditor(this.view, this.clientServices, this.displayerLocator, this.displayerPrototypes, this.typeSelector, this.lookupEditor, this.settingsEditor, this.editorStatus, this.displayerHtmlEditor, this.saveEvent, this.closeEvent);
    }

    @Test
    public void testBrandNewDisplayer() {
        Mockito.when((Object)this.view.getBrandNewDisplayerTitle()).thenReturn((Object)"New displayer");
        this.presenter.setDisplayerType(DisplayerType.SELECTOR);
        this.presenter.setDisplayerSubType(DisplayerSubType.SELECTOR_DROPDOWN);
        this.presenter.init(null);
        Assert.assertEquals((Object)this.presenter.isBrandNewDisplayer(), (Object)true);
        ((DisplayerSettings)Mockito.verify((Object)this.displayerSettings)).setTitle("New displayer");
        ((DisplayerPrototypes)Mockito.verify((Object)this.displayerPrototypes)).getProto(DisplayerType.SELECTOR, DisplayerSubType.SELECTOR_DROPDOWN);
        ((DisplayerLocator)Mockito.verify((Object)this.displayerLocator)).lookupDisplayer(this.displayerSettings);
        ((Displayer)Mockito.verify((Object)this.displayer)).draw();
        ((DisplayerTypeSelector)Mockito.verify((Object)this.typeSelector)).init((DisplayerType)Mockito.any(DisplayerType.class), (DisplayerSubType)Mockito.any(DisplayerSubType.class));
        ((DataSetLookupEditor)Mockito.verify((Object)this.lookupEditor)).init(this.lookupConstraints, null);
        ((DisplayerSettingsEditor)Mockito.verify((Object)this.settingsEditor)).init(this.displayer);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).showDisplayer((IsWidget)this.displayer);
    }

    @Test
    public void testNavigation() {
        this.presenter.setTypeSelectorEnabled(true);
        this.presenter.setDataSetLookupConfEnabled(true);
        this.presenter.setDisplaySettingsEnabled(true);
        Mockito.when((Object)this.editorStatus.getSelectedOption(Mockito.anyString())).thenReturn((Object)-1);
        this.presenter.init(null);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).gotoTypeSelection(this.typeSelector);
        Mockito.when((Object)this.editorStatus.getSelectedOption(Mockito.anyString())).thenReturn((Object)0);
        this.presenter.init(null);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).gotoTypeSelection(this.typeSelector);
        Mockito.when((Object)this.editorStatus.getSelectedOption(Mockito.anyString())).thenReturn((Object)1);
        this.presenter.init(null);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).gotoDataSetLookupConf(this.lookupEditor);
        Mockito.when((Object)this.editorStatus.getSelectedOption(Mockito.anyString())).thenReturn((Object)2);
        this.presenter.init(null);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).gotoDisplaySettings(this.settingsEditor);
    }

    @Test
    public void testTypeSelectorDisabled() {
        this.presenter.setTypeSelectorEnabled(false);
        this.presenter.setDataSetLookupConfEnabled(true);
        this.presenter.setDisplaySettingsEnabled(true);
        Mockito.when((Object)this.editorStatus.getSelectedOption(Mockito.anyString())).thenReturn((Object)-1);
        this.presenter.init(null);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).gotoDataSetLookupConf(this.lookupEditor);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).gotoTypeSelection(this.typeSelector);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).gotoDisplaySettings(this.settingsEditor);
    }

    @Test
    public void testDataLookupConfDisabled() {
        this.presenter.setTypeSelectorEnabled(false);
        this.presenter.setDataSetLookupConfEnabled(false);
        this.presenter.setDisplaySettingsEnabled(true);
        Mockito.when((Object)this.editorStatus.getSelectedOption(Mockito.anyString())).thenReturn((Object)-1);
        this.presenter.init(null);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).gotoDataSetLookupConf(this.lookupEditor);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).gotoTypeSelection(this.typeSelector);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).gotoDisplaySettings(this.settingsEditor);
    }

    @Test
    public void testTableModeAvailable() {
        for (DisplayerType type : Arrays.asList(DisplayerType.BARCHART, DisplayerType.LINECHART, DisplayerType.PIECHART, DisplayerType.AREACHART, DisplayerType.BUBBLECHART, DisplayerType.METERCHART, DisplayerType.METRIC, DisplayerType.MAP)) {
            Mockito.reset((Object[])new DisplayerEditor.View[]{this.view});
            Mockito.when((Object)this.displayerSettings.getType()).thenReturn((Object)type);
            this.presenter.init(null);
            this.presenter.gotoDataSetLookupConf();
            ((DisplayerEditor.View)Mockito.verify((Object)this.view)).setTableDisplayModeEnabled(true);
        }
    }

    @Test
    public void testTableModeNotAvailable() {
        Mockito.when((Object)this.displayerSettings.getType()).thenReturn((Object)DisplayerType.TABLE);
        this.presenter.init(null);
        this.presenter.gotoDataSetLookupConf();
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).setTableDisplayModeEnabled(false);
        ((DisplayerEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setTableDisplayModeEnabled(true);
    }

    @Test
    public void testTableMode() {
        Mockito.when((Object)this.view.isTableDisplayModeOn()).thenReturn((Object)true);
        this.presenter.init(null);
        ((Displayer)Mockito.verify((Object)this.tableDisplayer)).draw();
        ((DisplayerEditor.View)Mockito.verify((Object)this.view)).showDisplayer((IsWidget)this.tableDisplayer);
    }

    @Test
    public void testDataLookupChanged() {
        DisplayerSettings settings1 = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("test1")).dataset("test")).group("employee")).column("employee")).format("Employee")).column(AggregateFunctionType.COUNT, "#items")).format("#Items")).buildSettings();
        DisplayerSettings settings2 = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("test2")).dataset("test")).group("department")).column("department")).format("Department")).column("amount", AggregateFunctionType.SUM)).format("Total amount")).buildSettings();
        Mockito.when((Object)this.displayerLocator.lookupDisplayer((DisplayerSettings)Mockito.any())).thenReturn((Object)this.displayer);
        this.presenter.init(settings1);
        Assert.assertEquals((long)this.presenter.getDisplayerSettings().getColumnSettingsList().size(), (long)2L);
        Mockito.reset((Object[])new DisplayerSettingsEditor[]{this.settingsEditor});
        this.presenter.onDataSetLookupChanged(new DataSetLookupChangedEvent(settings2.getDataSetLookup()));
        ((DisplayerSettingsEditor)Mockito.verify((Object)this.settingsEditor)).init((Displayer)Mockito.any());
        Assert.assertEquals((long)this.presenter.getDisplayerSettings().getColumnSettingsList().size(), (long)0L);
    }
}

