/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashSet;
import java.util.Map;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.widgets.DisplayerHtmlEditor;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeEditor;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeType;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerHtmlEditorTest {
    @Mock
    DisplayerHtmlEditor.View view;
    @Mock
    SourceCodeEditor codeEditor;
    @Mock
    DisplayerConstraints constraints;
    @Mock
    Displayer displayer;
    DisplayerHtmlEditor presenter;

    @Before
    public void init() throws Exception {
        HashSet<DisplayerAttributeDef> supportedAttrs = new HashSet<DisplayerAttributeDef>();
        supportedAttrs.add(DisplayerAttributeDef.HTML_TEMPLATE);
        supportedAttrs.add(DisplayerAttributeDef.JS_TEMPLATE);
        Mockito.when((Object)this.constraints.getSupportedAttributes()).thenReturn(supportedAttrs);
        Mockito.when((Object)this.displayer.getDisplayerConstraints()).thenReturn((Object)this.constraints);
        this.presenter = new DisplayerHtmlEditor(this.view, this.codeEditor);
        this.presenter.setDisplayer(this.displayer);
    }

    @Test
    public void testInit() {
        ((DisplayerHtmlEditor.View)Mockito.verify((Object)this.view)).showDisplayer((IsWidget)this.displayer);
        ((SourceCodeEditor)Mockito.verify((Object)this.codeEditor, (VerificationMode)Mockito.never())).init((SourceCodeType)Mockito.any(), (String)Mockito.any(), (Map)Mockito.any(), (Command)Mockito.any());
    }

    @Test
    public void testSourceCodeItems() {
        ((DisplayerHtmlEditor.View)Mockito.verify((Object)this.view)).addSourceCodeItem("html");
        ((DisplayerHtmlEditor.View)Mockito.verify((Object)this.view)).addSourceCodeItem("javascript");
    }
}

