/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@ApplicationScoped
public class RendererManager {
    private SyncBeanManager beanManager;
    private List<RendererLibrary> renderersList = new ArrayList<RendererLibrary>();
    private Map<DisplayerType, RendererLibrary> renderersDefault = new EnumMap<DisplayerType, RendererLibrary>(DisplayerType.class);
    private Map<DisplayerType, List<RendererLibrary>> renderersByType = new EnumMap<DisplayerType, List<RendererLibrary>>(DisplayerType.class);
    private Map<DisplayerSubType, List<RendererLibrary>> renderersBySubType = new EnumMap<DisplayerSubType, List<RendererLibrary>>(DisplayerSubType.class);

    public RendererManager() {
    }

    @Inject
    public RendererManager(SyncBeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @PostConstruct
    private void init() {
        Collection beanDefs = this.beanManager.lookupBeans(RendererLibrary.class);
        for (SyncBeanDef beanDef : beanDefs) {
            RendererLibrary lib = (RendererLibrary)beanDef.getInstance();
            this.renderersList.add(lib);
            for (DisplayerType displayerType : DisplayerType.values()) {
                if (!lib.isDefault(displayerType)) continue;
                this.renderersDefault.put(displayerType, lib);
            }
            List<DisplayerType> types = lib.getSupportedTypes();
            if (types == null || types.isEmpty()) continue;
            for (DisplayerType type : types) {
                List<RendererLibrary> set = this.renderersByType.get(type);
                if (set == null) {
                    set = new ArrayList<RendererLibrary>();
                    this.renderersByType.put(type, set);
                }
                set.add(lib);
                List<DisplayerSubType> subTypes = lib.getSupportedSubtypes(type);
                if (subTypes == null || subTypes.isEmpty()) continue;
                for (DisplayerSubType subType : subTypes) {
                    List<RendererLibrary> subset = this.renderersBySubType.get(subType);
                    if (subset == null) {
                        subset = new ArrayList<RendererLibrary>();
                        this.renderersBySubType.put(subType, subset);
                    }
                    subset.add(lib);
                }
            }
        }
    }

    public List<RendererLibrary> getRenderers() {
        return this.renderersList;
    }

    public RendererLibrary getDefaultRenderer(DisplayerType displayerType) {
        return this.renderersDefault.get(displayerType);
    }

    public void setDefaultRenderer(DisplayerType displayerType, String rendererName) {
        this.renderersDefault.put(displayerType, this.getRendererByUUID(rendererName));
    }

    public List<RendererLibrary> getRenderersForType(DisplayerType displayerType) {
        List<RendererLibrary> result = this.renderersByType.get(displayerType);
        if (result == null) {
            return new ArrayList<RendererLibrary>();
        }
        return result;
    }

    public List<RendererLibrary> getRenderersForType(DisplayerType type, DisplayerSubType subType) {
        if (type == null) {
            return subType == null ? this.renderersList : this.renderersBySubType.get(subType);
        }
        if (subType == null) {
            return this.renderersByType.get(type);
        }
        List<RendererLibrary> types = this.renderersByType.get(type);
        ArrayList<RendererLibrary> result = new ArrayList<RendererLibrary>((Collection)this.renderersBySubType.get(subType));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            RendererLibrary rl = (RendererLibrary)it.next();
            if (types.contains(rl)) continue;
            it.remove();
        }
        return result;
    }

    public RendererLibrary getRendererByUUID(String renderer) {
        RendererLibrary lib = this._getRendererByUUID(renderer);
        if (lib != null) {
            return lib;
        }
        throw new RuntimeException(CommonConstants.INSTANCE.rendererliblocator_renderer_not_found(renderer));
    }

    private RendererLibrary _getRendererByUUID(String renderer) {
        for (RendererLibrary lib : this.renderersList) {
            if (!lib.getUUID().equals(renderer)) continue;
            return lib;
        }
        return null;
    }

    public RendererLibrary getRendererByName(String renderer) {
        for (RendererLibrary lib : this.renderersList) {
            if (!lib.getName().equals(renderer)) continue;
            return lib;
        }
        throw new RuntimeException(CommonConstants.INSTANCE.rendererliblocator_renderer_not_found(renderer));
    }

    public RendererLibrary getRendererForType(DisplayerType displayerType) {
        RendererLibrary defaultRenderer = this.renderersDefault.get(displayerType);
        if (defaultRenderer != null) {
            return defaultRenderer;
        }
        return this.renderersByType.get(displayerType).get(0);
    }

    public RendererLibrary getRendererForDisplayer(DisplayerSettings target) {
        RendererLibrary targetRenderer;
        if (!StringUtils.isBlank((String)target.getRenderer()) && (targetRenderer = this._getRendererByUUID(target.getRenderer())) != null) {
            return targetRenderer;
        }
        List<RendererLibrary> renderersSupported = this.getRenderersForType(target.getType(), target.getSubtype());
        RendererLibrary defaultRenderer = this.getDefaultRenderer(target.getType());
        for (RendererLibrary rendererLibrary : renderersSupported) {
            if (defaultRenderer == null || !rendererLibrary.equals(defaultRenderer)) continue;
            return defaultRenderer;
        }
        if (!renderersSupported.isEmpty()) {
            return renderersSupported.get(0);
        }
        throw new RuntimeException("No renderer is available for: " + target.getType());
    }
}

