/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.ValidationError;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.events.DataSetLookupChangedEvent;
import org.dashbuilder.displayer.client.events.DisplayerEditorClosedEvent;
import org.dashbuilder.displayer.client.events.DisplayerEditorSavedEvent;
import org.dashbuilder.displayer.client.events.DisplayerSettingsChangedEvent;
import org.dashbuilder.displayer.client.events.DisplayerSubtypeSelectedEvent;
import org.dashbuilder.displayer.client.events.DisplayerTypeSelectedEvent;
import org.dashbuilder.displayer.client.prototypes.DisplayerPrototypes;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorStatus;
import org.dashbuilder.displayer.client.widgets.DisplayerHtmlEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerSettingsEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerTypeSelector;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class DisplayerEditor
implements IsWidget {
    protected View view = null;
    protected DataSetClientServices clientServices = null;
    protected DisplayerLocator displayerLocator = null;
    protected DisplayerPrototypes displayerPrototypes = null;
    protected DisplayerSettings displayerSettings = null;
    protected DisplayerSettings selectedTypeSettings = null;
    protected boolean brandNewDisplayer = true;
    protected DisplayerTypeSelector typeSelector;
    protected DataSetLookupEditor lookupEditor;
    protected DisplayerSettingsEditor settingsEditor;
    protected DisplayerEditorStatus editorStatus;
    protected Displayer displayer = null;
    protected DisplayerHtmlEditor displayerHtmlEditor = null;
    protected int activeSection = -1;
    protected boolean typeSelectionEnabled = true;
    protected boolean dataLookupConfEnabled = true;
    protected boolean displaySettingsEnabled = true;
    protected Event<DisplayerEditorSavedEvent> saveEvent;
    protected Event<DisplayerEditorClosedEvent> closeEvent;
    protected Command onCloseCommand = () -> {};
    protected Command onSaveCommand = () -> {};
    protected DisplayerType displayerType = DisplayerType.BARCHART;
    protected DisplayerSubType displayerSubType = null;
    DisplayerListener displayerListener = new AbstractDisplayerListener(){

        @Override
        public void onError(Displayer displayer, ClientRuntimeError error) {
            DisplayerEditor.this.view.error(error);
        }
    };

    @Inject
    public DisplayerEditor(View view, DataSetClientServices clientServices, DisplayerLocator displayerLocator, DisplayerPrototypes displayerPrototypes, DisplayerTypeSelector typeSelector, DataSetLookupEditor lookupEditor, DisplayerSettingsEditor settingsEditor, DisplayerEditorStatus editorStatus, DisplayerHtmlEditor displayerHtmlEditor, Event<DisplayerEditorSavedEvent> savedEvent, Event<DisplayerEditorClosedEvent> closedEvent) {
        this.view = view;
        this.displayerLocator = displayerLocator;
        this.clientServices = clientServices;
        this.displayerPrototypes = displayerPrototypes;
        this.typeSelector = typeSelector;
        this.lookupEditor = lookupEditor;
        this.settingsEditor = settingsEditor;
        this.editorStatus = editorStatus;
        this.displayerHtmlEditor = displayerHtmlEditor;
        this.saveEvent = savedEvent;
        this.closeEvent = closedEvent;
        view.init(this);
    }

    public void setDisplayerType(DisplayerType displayerType) {
        this.displayerType = displayerType != null ? displayerType : DisplayerType.BARCHART;
    }

    public void setDisplayerSubType(DisplayerSubType displayerSubType) {
        this.displayerSubType = displayerSubType;
    }

    public void init(DisplayerSettings settings) {
        if (settings != null) {
            this.brandNewDisplayer = false;
            this.displayerSettings = settings;
        } else {
            this.brandNewDisplayer = true;
            this.displayerSettings = this.displayerPrototypes.getProto(this.displayerType, this.displayerSubType);
            this.displayerSettings.setTitle(this.view.getBrandNewDisplayerTitle());
        }
        this.selectedTypeSettings = this.displayerSettings;
        this.initDisplayer();
        this.initTypeSelector();
        this.initLookupEditor();
        this.initSettingsEditor();
        this.gotoLastSection();
        this.showDisplayer();
    }

    protected boolean supportsHtmlTemplate() {
        return this.displayer.getDisplayerConstraints().getSupportedAttributes().contains(DisplayerAttributeDef.HTML_TEMPLATE);
    }

    protected void initDisplayer() {
        if (this.displayer != null) {
            this.displayer.close();
        }
        this.displayer = this.displayerLocator.lookupDisplayer(this.displayerSettings);
        this.displayer.addListener(this.displayerListener);
        this.displayer.setRefreshOn(false);
        this.displayer.draw();
    }

    protected void initLookupEditor() {
        DataSetLookupConstraints lookupConstraints = this.displayer.getDisplayerConstraints().getDataSetLookupConstraints();
        this.lookupEditor.init(lookupConstraints, this.displayerSettings.getDataSetLookup());
    }

    protected void initTypeSelector() {
        this.typeSelector.init(this.displayerSettings.getType(), this.displayerSettings.getSubtype());
    }

    protected void initSettingsEditor() {
        this.settingsEditor.init(this.displayer);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public View getView() {
        return this.view;
    }

    public boolean isBrandNewDisplayer() {
        return this.brandNewDisplayer;
    }

    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    public Displayer getDisplayer() {
        return this.displayer;
    }

    public DisplayerTypeSelector getTypeSelector() {
        return this.typeSelector;
    }

    public DataSetLookupEditor getLookupEditor() {
        return this.lookupEditor;
    }

    public DisplayerSettingsEditor getSettingsEditor() {
        return this.settingsEditor;
    }

    public void setTypeSelectorEnabled(boolean enabled) {
        this.typeSelectionEnabled = enabled;
        this.view.setTypeSelectionEnabled(enabled);
    }

    public void setDataSetLookupConfEnabled(boolean enabled) {
        this.dataLookupConfEnabled = enabled;
        this.view.setDataSetLookupConfEnabled(enabled);
    }

    public void setDisplaySettingsEnabled(boolean enabled) {
        this.displaySettingsEnabled = enabled;
        this.view.setDisplaySettingsEnabled(enabled);
    }

    public void setOnSaveCommand(Command saveCommand) {
        this.onSaveCommand = saveCommand != null ? saveCommand : this.onCloseCommand;
    }

    public void setOnCloseCommand(Command closeCommand) {
        this.onCloseCommand = closeCommand != null ? closeCommand : this.onCloseCommand;
    }

    public void showDisplayer() {
        if (this.view.isTableDisplayModeOn()) {
            try {
                DisplayerSettings tableSettings = this.displayerSettings.cloneInstance();
                tableSettings.setTitleVisible(false);
                tableSettings.setType(DisplayerType.TABLE);
                tableSettings.setTablePageSize(8);
                tableSettings.setTableWidth(800);
                tableSettings.setRenderer("default");
                Displayer tableDisplayer = this.displayerLocator.lookupDisplayer(tableSettings);
                tableDisplayer.addListener(this.displayerListener);
                tableDisplayer.setRefreshOn(false);
                tableDisplayer.draw();
                this.view.showDisplayer(tableDisplayer);
            }
            catch (Exception e) {
                this.view.error(new ClientRuntimeError((Throwable)e));
            }
        } else if (this.supportsHtmlTemplate()) {
            this.displayerHtmlEditor.setDisplayer(this.displayer);
            this.view.showDisplayer(this.displayerHtmlEditor);
        } else {
            this.view.showDisplayer(this.displayer);
        }
    }

    public void gotoFirstSectionEnabled() {
        if (this.typeSelectionEnabled) {
            this.gotoTypeSelection();
        } else if (this.dataLookupConfEnabled) {
            this.gotoDataSetLookupConf();
        } else if (this.displaySettingsEnabled) {
            this.gotoDisplaySettings();
        } else {
            this.view.error("Nothing to show!");
        }
    }

    public void gotoLastSection() {
        int lastOption = this.editorStatus.getSelectedOption(this.displayerSettings.getUUID());
        if (this.activeSection < 0 || this.activeSection != lastOption) {
            switch (lastOption) {
                case 2: {
                    this.gotoDisplaySettings();
                    break;
                }
                case 1: {
                    this.gotoDataSetLookupConf();
                    break;
                }
                default: {
                    this.gotoFirstSectionEnabled();
                }
            }
        }
    }

    public void gotoTypeSelection() {
        this.activeSection = 0;
        this.editorStatus.saveSelectedOption(this.displayerSettings.getUUID(), this.activeSection);
        this.view.gotoTypeSelection(this.typeSelector);
    }

    public void gotoDataSetLookupConf() {
        this.activeSection = 1;
        this.editorStatus.saveSelectedOption(this.displayerSettings.getUUID(), this.activeSection);
        this.view.gotoDataSetLookupConf(this.lookupEditor);
        this.view.setTableDisplayModeEnabled(!DisplayerType.TABLE.equals((Object)this.displayerSettings.getType()));
    }

    public void gotoDisplaySettings() {
        this.activeSection = 2;
        this.editorStatus.saveSelectedOption(this.displayerSettings.getUUID(), this.activeSection);
        this.view.gotoDisplaySettings(this.settingsEditor);
    }

    public void save() {
        DisplayerConstraints displayerConstraints = this.displayer.getDisplayerConstraints();
        displayerConstraints.removeUnsupportedAttributes(this.displayerSettings);
        if (this.displayer != null) {
            this.displayer.close();
        }
        this.onSaveCommand.execute();
        this.saveEvent.fire((Object)new DisplayerEditorSavedEvent(this.displayerSettings));
    }

    public void close() {
        if (this.displayer != null) {
            this.displayer.close();
        }
        this.onCloseCommand.execute();
        this.closeEvent.fire((Object)new DisplayerEditorClosedEvent(this.displayerSettings));
    }

    void onDataSetLookupChanged(@Observes DataSetLookupChangedEvent event) {
        DataSetLookup dataSetLookup = event.getDataSetLookup();
        this.displayerSettings.setDataSet(null);
        this.displayerSettings.setDataSetLookup(dataSetLookup);
        this.removeStaleSettings();
        this.initDisplayer();
        this.initSettingsEditor();
        this.showDisplayer();
    }

    void onDisplayerSettingsChanged(@Observes DisplayerSettingsChangedEvent event) {
        this.displayerSettings = event.getDisplayerSettings();
        this.initDisplayer();
        this.showDisplayer();
    }

    void onDisplayerTypeChanged(@Observes DisplayerTypeSelectedEvent event) {
        this.displayerTypeChanged(event.getSelectedType(), null);
    }

    void onDisplayerSubtypeChanged(@Observes DisplayerSubtypeSelectedEvent event) {
        this.displayerTypeChanged(this.selectedTypeSettings.getType(), event.getSelectedSubType());
    }

    void displayerTypeChanged(DisplayerType type, DisplayerSubType displayerSubType) {
        this.selectedTypeSettings = this.displayerPrototypes.getProto(type, displayerSubType);
        DataSet oldDataSet = this.displayerSettings.getDataSet();
        DataSetLookup oldDataLookup = this.displayerSettings.getDataSetLookup();
        if (oldDataSet == null && oldDataLookup != null) {
            DataSetMetadata metadata;
            Displayer displayer = this.displayerLocator.lookupDisplayer(this.selectedTypeSettings);
            DisplayerConstraints displayerConstraints = displayer.getDisplayerConstraints();
            DataSetLookupConstraints dataConstraints = displayerConstraints.getDataSetLookupConstraints();
            ValidationError validationError = dataConstraints.check(oldDataLookup, metadata = this.clientServices.getMetadata(oldDataLookup.getDataSetUUID()));
            if (validationError == null) {
                this.selectedTypeSettings.setDataSet(null);
                this.selectedTypeSettings.setDataSetLookup(oldDataLookup);
                this.applySelectedType();
            } else {
                this.view.showTypeChangedWarning(this::applySelectedType, this::abortSelectedType);
            }
        } else {
            this.applySelectedType();
        }
    }

    void applySelectedType() {
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.TYPE);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.SUBTYPE);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.GENERAL_GROUP);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.CHART_GROUP);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.CHART_MARGIN_GROUP);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.CHART_LEGEND_GROUP);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.AXIS_GROUP);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.SELECTOR_GROUP);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.FILTER_GROUP);
        this.displayerSettings.removeDisplayerSetting(DisplayerAttributeGroupDef.HTML_GROUP);
        this.selectedTypeSettings.getSettingsFlatMap().putAll(this.displayerSettings.getSettingsFlatMap());
        try {
            this.displayerLocator.lookupDisplayer(this.selectedTypeSettings);
        }
        catch (Exception e) {
            this.selectedTypeSettings.removeDisplayerSetting(DisplayerAttributeDef.RENDERER);
            this.view.error(new ClientRuntimeError((Throwable)e));
        }
        this.init(this.selectedTypeSettings);
        this.removeStaleSettings();
    }

    void abortSelectedType() {
        this.selectedTypeSettings = this.displayerSettings;
        this.typeSelector.init(this.displayerSettings.getType(), this.displayerSettings.getSubtype());
        this.view.showDisplayer(this.displayer);
    }

    List<String> getExistingDataColumnIds() {
        ArrayList<String> columnIds;
        block3: {
            int idx;
            DataSetLookup dataSetLookup;
            block2: {
                DataSet dataSet = this.displayerSettings.getDataSet();
                dataSetLookup = this.displayerSettings.getDataSetLookup();
                columnIds = new ArrayList<String>();
                if (dataSet == null) break block2;
                for (DataColumn dataColumn : dataSet.getColumns()) {
                    columnIds.add(dataColumn.getId());
                }
                break block3;
            }
            if (dataSetLookup == null || (idx = dataSetLookup.getLastGroupOpIndex(0)) == -1) break block3;
            DataSetGroup groupOp = (DataSetGroup)dataSetLookup.getOperation(idx);
            for (GroupFunction groupFunction : groupOp.getGroupFunctions()) {
                columnIds.add(groupFunction.getColumnId());
            }
        }
        return columnIds;
    }

    void removeStaleSettings() {
        List<String> columnIds = this.getExistingDataColumnIds();
        Iterator it = this.displayerSettings.getColumnSettingsList().iterator();
        while (it.hasNext()) {
            ColumnSettings columnSettings = (ColumnSettings)it.next();
            if (columnIds.contains(columnSettings.getColumnId())) continue;
            it.remove();
        }
        if (!columnIds.contains(this.displayerSettings.getTableDefaultSortColumnId())) {
            this.displayerSettings.setTableDefaultSortColumnId(null);
        }
    }

    public static interface View
    extends UberView<DisplayerEditor> {
        public String getBrandNewDisplayerTitle();

        public boolean isTableDisplayModeOn();

        public void setTableDisplayModeEnabled(boolean var1);

        public void showDisplayer(IsWidget var1);

        public void setTypeSelectionEnabled(boolean var1);

        public void setDisplaySettingsEnabled(boolean var1);

        public void setDataSetLookupConfEnabled(boolean var1);

        public void gotoTypeSelection(DisplayerTypeSelector var1);

        public void gotoDataSetLookupConf(DataSetLookupEditor var1);

        public void gotoDisplaySettings(DisplayerSettingsEditor var1);

        public void showTypeChangedWarning(Command var1, Command var2);

        public void error(String var1);

        public void error(ClientRuntimeError var1);
    }
}

