/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.date.TimeAmount;
import org.dashbuilder.dataset.date.TimeInstant;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.widgets.filter.TimeAmountEditor;
import org.dashbuilder.displayer.client.widgets.filter.TimeInstantEditor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class TimeInstantEditorTest {
    @Mock
    TimeInstantEditor.View timeInstantView;
    @Mock
    TimeAmountEditor timeAmountEditor;
    @Mock
    Command changeCommand;

    @Test
    public void testViewInitialization() {
        TimeInstant beginMonth = new TimeInstant(TimeInstant.TimeMode.BEGIN, DateIntervalType.MONTH, Month.JANUARY, new TimeAmount(10L, DateIntervalType.DAY));
        TimeInstantEditor timeInstantEditor = new TimeInstantEditor(this.timeInstantView, this.timeAmountEditor);
        timeInstantEditor.init(beginMonth, this.changeCommand);
        Assert.assertEquals((Object)this.timeInstantView, (Object)timeInstantEditor.view);
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).init((Object)timeInstantEditor);
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).clearTimeModeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.times((int)TimeInstant.TimeMode.values().length))).addTimeModeItem((TimeInstant.TimeMode)Mockito.any(TimeInstant.TimeMode.class));
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).setSelectedTimeModeIndex(TimeInstant.TimeMode.BEGIN.getIndex());
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).enableIntervalTypeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).clearIntervalTypeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.times((int)TimeInstantEditor.INTERVAL_TYPES.size()))).addIntervalTypeItem((DateIntervalType)Mockito.any(DateIntervalType.class));
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).setSelectedIntervalTypeIndex(3);
    }

    @Test
    public void testNullInitialization() {
        TimeInstantEditor timeInstantEditor = new TimeInstantEditor(this.timeInstantView, this.timeAmountEditor);
        timeInstantEditor.init(null, this.changeCommand);
        Assert.assertEquals((Object)this.timeInstantView, (Object)timeInstantEditor.view);
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).init((Object)timeInstantEditor);
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).clearTimeModeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.times((int)TimeInstant.TimeMode.values().length))).addTimeModeItem((TimeInstant.TimeMode)Mockito.any(TimeInstant.TimeMode.class));
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).setSelectedTimeModeIndex(TimeInstant.TimeMode.NOW.getIndex());
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).disableIntervalTypeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.never())).clearIntervalTypeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.never())).enableIntervalTypeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.never())).addIntervalTypeItem((DateIntervalType)Mockito.any(DateIntervalType.class));
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.never())).setSelectedIntervalTypeIndex(((Integer)Mockito.any(Integer.class)).intValue());
    }

    @Test
    public void testChangeTimeMode() {
        Mockito.when((Object)this.timeInstantView.getTimeModeSelectedIndex()).thenReturn((Object)TimeInstant.TimeMode.BEGIN.getIndex());
        TimeInstantEditor timeInstantEditor = new TimeInstantEditor(this.timeInstantView, this.timeAmountEditor);
        timeInstantEditor.init(null, this.changeCommand);
        timeInstantEditor.changeTimeMode();
        TimeInstant timeInstant = timeInstantEditor.getTimeInstant();
        Assert.assertEquals((Object)timeInstant.getTimeMode(), (Object)TimeInstant.TimeMode.BEGIN);
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
    }

    @Test
    public void testChangeIntervalType() {
        Mockito.when((Object)this.timeInstantView.getSelectedIntervalTypeIndex()).thenReturn((Object)0);
        TimeInstantEditor timeInstantEditor = new TimeInstantEditor(this.timeInstantView, this.timeAmountEditor);
        timeInstantEditor.init(null, this.changeCommand);
        timeInstantEditor.changeIntervalType();
        TimeInstant timeInstant = timeInstantEditor.getTimeInstant();
        Assert.assertEquals((Object)timeInstant.getIntervalType(), (Object)DateIntervalType.MINUTE);
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
    }

    @Test
    public void testSwitchToNow() {
        TimeInstantEditor timeInstantEditor = new TimeInstantEditor(this.timeInstantView, this.timeAmountEditor);
        timeInstantEditor.init(null, this.changeCommand);
        Mockito.reset((Object[])new TimeInstantEditor.View[]{this.timeInstantView});
        Mockito.when((Object)this.timeInstantView.getTimeModeSelectedIndex()).thenReturn((Object)TimeInstant.TimeMode.NOW.getIndex());
        timeInstantEditor.changeTimeMode();
        TimeInstant timeInstant = timeInstantEditor.getTimeInstant();
        Assert.assertEquals((Object)timeInstant.getTimeMode(), (Object)TimeInstant.TimeMode.NOW);
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).disableIntervalTypeSelector();
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView, (VerificationMode)Mockito.never())).enableIntervalTypeSelector();
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
    }

    @Test
    public void testSwitchFromNow() {
        TimeInstantEditor timeInstantEditor = new TimeInstantEditor(this.timeInstantView, this.timeAmountEditor);
        timeInstantEditor.init(null, this.changeCommand);
        Mockito.reset((Object[])new TimeInstantEditor.View[]{this.timeInstantView});
        Mockito.when((Object)this.timeInstantView.getTimeModeSelectedIndex()).thenReturn((Object)TimeInstant.TimeMode.END.getIndex());
        timeInstantEditor.changeTimeMode();
        TimeInstant timeInstant = timeInstantEditor.getTimeInstant();
        Assert.assertEquals((Object)timeInstant.getTimeMode(), (Object)TimeInstant.TimeMode.END);
        ((TimeInstantEditor.View)Mockito.verify((Object)this.timeInstantView)).enableIntervalTypeSelector();
        ((Command)Mockito.verify((Object)this.changeCommand)).execute();
    }
}

