/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.dataset.client.resources.i18n.DateIntervalTypeConstants;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.displayer.client.widgets.filter.TimeAmountEditor;
import org.gwtbootstrap3.client.ui.InputGroupAddon;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.ext.widgets.common.client.common.NumericLongTextBox;

@Dependent
public class TimeAmountEditorView
extends Composite
implements TimeAmountEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    TimeAmountEditor presenter = null;
    @UiField
    NumericLongTextBox input;
    @UiField
    InputGroupAddon minusIcon;
    @UiField
    InputGroupAddon plusIcon;
    @UiField
    ListBox typeList;

    public void init(final TimeAmountEditor presenter) {
        this.presenter = presenter;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.plusIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                presenter.increaseQuantity();
            }
        }, ClickEvent.getType());
        this.minusIcon.addDomHandler((EventHandler)new ClickHandler(){

            public void onClick(ClickEvent event) {
                presenter.decreaseQuantity();
            }
        }, ClickEvent.getType());
        this.input.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                presenter.changeQuantity((String)event.getValue());
            }
        });
    }

    @Override
    public void setQuantity(long quantity) {
        this.input.setValue(Long.toString(quantity));
    }

    @Override
    public long getQuantity() {
        return Long.valueOf(this.input.getValue());
    }

    @Override
    public void clearIntervalTypeSelector() {
        this.typeList.clear();
    }

    @Override
    public void addIntervalTypeItem(DateIntervalType type) {
        String typeName = DateIntervalTypeConstants.INSTANCE.getString(type.name());
        this.typeList.addItem(typeName);
    }

    @Override
    public void setSelectedTypeIndex(int idx) {
        this.typeList.setSelectedIndex(idx);
    }

    @Override
    public int getSelectedTypeIndex() {
        return this.typeList.getSelectedIndex();
    }

    @UiHandler(value={"typeList"})
    public void onFilterSelected(ChangeEvent changeEvent) {
        this.presenter.changeIntervalType();
    }

    static interface Binder
    extends UiBinder<Widget, TimeAmountEditorView> {
    }
}

