/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerFilterTest
extends AbstractDisplayerTest {
    DisplayerSettings byDepartment = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().dataset("expenses")).group("DEPARTMENT")).column("DEPARTMENT")).column("AMOUNT", AggregateFunctionType.SUM)).filterOn(false, true, true)).buildSettings();
    DisplayerSettings allRows = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filterOn(true, false, true)).sort("DEPARTMENT", SortOrder.ASCENDING)).buildSettings();

    @Test
    public void testDrawRequired() {
        AbstractDisplayer allRowsTable = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(this.allRows);
        allRowsTable.filterUpdate("DEPARTMENT", 0);
        DataSet dataSet = allRowsTable.getDataSetHandler().getLastDataSet();
        Assert.assertNull((Object)dataSet);
    }

    @Test
    public void testNotifications() {
        AbstractDisplayer deptPieChart = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(this.byDepartment);
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        deptPieChart.addListener(new DisplayerListener[]{listener});
        deptPieChart.draw();
        deptPieChart.filterUpdate("DEPARTMENT", 0);
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterEnabled((Displayer)Mockito.eq((Object)deptPieChart), (DataSetGroup)Mockito.any(DataSetGroup.class));
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)deptPieChart);
        deptPieChart.filterReset();
        ((DisplayerListener)Mockito.verify((Object)listener)).onFilterReset((Displayer)Mockito.eq((Object)deptPieChart), Mockito.anyList());
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)deptPieChart);
    }

    @Test
    public void testDrillDown() {
        AbstractDisplayer allRowsTable = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(this.allRows);
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        allRowsTable.addListener(new DisplayerListener[]{listener});
        allRowsTable.draw();
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        allRowsTable.filterUpdate("DEPARTMENT", 0);
        DataSet dataSet = allRowsTable.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)19L);
        ((DisplayerListener)Mockito.verify((Object)listener)).onDataLookup((Displayer)allRowsTable);
        ((DisplayerListener)Mockito.verify((Object)listener)).onRedraw((Displayer)allRowsTable);
    }

    @Test
    public void testFilterNotAllowed() {
        AbstractDisplayer allRowsTable = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filterOff(true)).buildSettings());
        DisplayerListener listener = (DisplayerListener)Mockito.mock(DisplayerListener.class);
        allRowsTable.addListener(new DisplayerListener[]{listener});
        allRowsTable.draw();
        Mockito.reset((Object[])new DisplayerListener[]{listener});
        allRowsTable.filterUpdate("DEPARTMENT", 0);
        DataSet dataSet = allRowsTable.getDataSetHandler().getLastDataSet();
        Assert.assertEquals((long)dataSet.getRowCount(), (long)50L);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onDataLookup((Displayer)allRowsTable);
        ((DisplayerListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)allRowsTable);
    }
}

