/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupConstraints;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetMetadataCallback;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.impl.StaticDataSetDefBuilderImpl;
import org.dashbuilder.displayer.client.events.DataSetLookupChangedEvent;
import org.dashbuilder.displayer.client.events.GroupFunctionChangedEvent;
import org.dashbuilder.displayer.client.events.GroupFunctionDeletedEvent;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.dashbuilder.displayer.client.widgets.group.ColumnFunctionEditor;
import org.dashbuilder.displayer.client.widgets.group.DataSetGroupDateEditor;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetLookupEditorTest {
    public static final String POPULATION_UUID = "population";
    public static final String REVENUE_UUID = "revenue";
    public static final DataSetDef POPULATION_DSET = ((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)DataSetDefFactory.newStaticDataSetDef().uuid("population")).name("Population")).label("continent")).label("country")).number("population")).date("year")).buildDef();
    public static final DataSetDef REVENUE_DSET = ((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)((StaticDataSetDefBuilderImpl)DataSetDefFactory.newStaticDataSetDef().uuid("revenue")).name("Revenue")).label("company")).label("sector")).number("revenue")).date("year")).buildDef();
    public static final List<DataSetDef> DATA_SET_LIST = Arrays.asList(POPULATION_DSET, REVENUE_DSET);
    public static final DataSetMetadata POPULATION_META = new DataSetMetadataImpl(POPULATION_DSET, "population", 0, 4, Arrays.asList("continent", "country", "population", "year"), Arrays.asList(ColumnType.LABEL, ColumnType.LABEL, ColumnType.NUMBER, ColumnType.DATE), 0);
    public static final DataSetMetadata REVENUE_META = new DataSetMetadataImpl(POPULATION_DSET, "revenue", 0, 4, Arrays.asList("company", "sector", "revenue", "year"), Arrays.asList(ColumnType.LABEL, ColumnType.LABEL, ColumnType.NUMBER, ColumnType.DATE), 0);
    public static final DataSetLookupConstraints DATA_2D_MULTIPLE = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(10)).setMinColumns(2)).setExtraColumnsAllowed(true)).setExtraColumnsType(ColumnType.NUMBER)).setGroupsTitle("Categories").setColumnsTitle("Series").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
    public static final DataSetLookupConstraints DATA_2D_FIXED = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupRequired(true).setGroupColumn(true).setMaxColumns(2)).setMinColumns(2)).setExtraColumnsAllowed(false)).setGroupsTitle("Categories").setColumnsTitle("Series").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
    public static final DataSetLookupConstraints DATA_MULTIPLE = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(true).setGroupRequired(false).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle("Rows").setColumnsTitle("Columns").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
    public static final DataSetLookupConstraints DATA_MULTIPLE_NO_GROUP = (DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)((DataSetLookupConstraints)new DataSetLookupConstraints().setGroupAllowed(false).setGroupRequired(false).setMaxColumns(-1)).setMinColumns(1)).setExtraColumnsAllowed(true)).setGroupsTitle("Rows").setColumnsTitle("Columns").setColumnTypes((ColumnType[][])new ColumnType[][]{{ColumnType.LABEL, ColumnType.NUMBER}});
    @Mock
    DataSetLookupEditor.View view;
    @Mock
    Event<DataSetLookupChangedEvent> event;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    SyncBeanDef<ColumnFunctionEditor> columnFunctionEditorBeanDef;
    @Mock
    ColumnFunctionEditor columnFunctionEditor;
    @Mock
    DataSetFilterEditor filterEditor;
    @Mock
    DataSetGroupDateEditor groupDateEditor;
    @Mock
    DataSetClientServices clientServices;
    DataSetLookupEditor presenter = null;

    @Before
    public void init() throws Exception {
        this.presenter = new DataSetLookupEditor(this.view, this.beanManager, this.filterEditor, this.groupDateEditor, this.clientServices, this.event);
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                RemoteCallback callback = (RemoteCallback)invocationOnMock.getArguments()[0];
                callback.callback(DATA_SET_LIST);
                return null;
            }
        }).when((Object)this.clientServices)).getPublicDataSetDefs((RemoteCallback)Mockito.any(RemoteCallback.class));
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataSetMetadataCallback callback = (DataSetMetadataCallback)invocationOnMock.getArguments()[1];
                callback.callback(POPULATION_META);
                return null;
            }
        }).when((Object)this.clientServices)).fetchMetadata((String)Mockito.eq((Object)POPULATION_UUID), (DataSetMetadataCallback)Mockito.any(DataSetMetadataCallback.class));
        ((DataSetClientServices)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataSetMetadataCallback callback = (DataSetMetadataCallback)invocationOnMock.getArguments()[1];
                callback.callback(REVENUE_META);
                return null;
            }
        }).when((Object)this.clientServices)).fetchMetadata((String)Mockito.eq((Object)REVENUE_UUID), (DataSetMetadataCallback)Mockito.any(DataSetMetadataCallback.class));
        Mockito.when((Object)this.beanManager.lookupBean(ColumnFunctionEditor.class, new Annotation[0])).thenReturn(this.columnFunctionEditorBeanDef);
        Mockito.when((Object)this.columnFunctionEditorBeanDef.newInstance()).thenReturn((Object)this.columnFunctionEditor);
    }

    @Test
    public void testNonExistingLookup() {
        this.presenter.init(DATA_2D_FIXED, null);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).clearDataSetSelector();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).enableDataSetSelectorHint();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addDataSetItem("Population", POPULATION_UUID);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addDataSetItem("Revenue", REVENUE_UUID);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setSelectedDataSetIndex(Mockito.anyInt());
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFilterEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setGroupEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setColumnsSectionEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setAddColumnOptionEnabled(true);
    }

    @Test
    public void testExistingLookup() {
        this.presenter.init(DATA_2D_FIXED, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).filter(new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100))})).group("country")).column("country", "Country")).column(POPULATION_UUID, AggregateFunctionType.SUM, "Total")).buildLookup());
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).clearDataSetSelector();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableDataSetSelectorHint();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addDataSetItem("Population", POPULATION_UUID);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addDataSetItem("Revenue", REVENUE_UUID);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setSelectedDataSetIndex(Mockito.anyInt());
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setFilterEnabled(true);
        ((DataSetFilterEditor)Mockito.verify((Object)this.filterEditor)).init(this.presenter.getDataSetLookup().getFirstFilterOp(), POPULATION_META);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setGroupEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setGroupByDateEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setGroupColumnSelectorTitle("Categories");
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableGroupColumnSelectorHint();
        ((DataSetGroupDateEditor)Mockito.verify((Object)this.groupDateEditor, (VerificationMode)Mockito.never())).init((ColumnGroup)Mockito.any(ColumnGroup.class));
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).clearGroupColumnSelector();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addGroupColumnItem("continent");
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addGroupColumnItem("country");
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addGroupColumnItem("year");
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addGroupColumnItem(POPULATION_UUID);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setColumnsSectionEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setGroupByDateEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setColumnSectionTitle("Series");
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setAddColumnOptionEnabled(false);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setAddColumnOptionEnabled(true);
        GroupFunction gf = (GroupFunction)this.presenter.getFirstGroupFunctions().get(1);
        ((ColumnFunctionEditor)Mockito.verify((Object)this.columnFunctionEditor)).init(POPULATION_META, gf, ColumnType.NUMBER, null, true, false);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addColumnEditor((ColumnFunctionEditor)Mockito.any(ColumnFunctionEditor.class));
    }

    @Test
    public void testFromNonExistingLookup() {
        this.presenter.init(DATA_2D_FIXED, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).filter(new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100))})).group("country")).column("country", "Country")).column(POPULATION_UUID, AggregateFunctionType.SUM, "Total")).buildLookup());
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableDataSetSelectorHint();
        Mockito.reset((Object[])new DataSetLookupEditor.View[]{this.view});
        this.presenter.init(DATA_2D_FIXED, null);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).enableDataSetSelectorHint();
    }

    @Test
    public void testDataSetDefFilter() {
        this.presenter.setDataSetDefFilter(new DataSetLookupEditor.DataSetDefFilter(){

            public boolean accept(DataSetDef def) {
                return def.getUUID().equals(DataSetLookupEditorTest.REVENUE_UUID);
            }
        });
        this.presenter.init(DATA_2D_FIXED, null);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).clearDataSetSelector();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addDataSetItem("Population", POPULATION_UUID);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).addDataSetItem("Revenue", REVENUE_UUID);
    }

    @Test
    public void testDateGroup() {
        this.presenter.init(DATA_2D_FIXED, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).filter(new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100))})).group("year")).column("year", "Year")).column(POPULATION_UUID, AggregateFunctionType.SUM, "Total")).buildLookup());
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setGroupEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setGroupByDateEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableGroupColumnSelectorHint();
        ((DataSetGroupDateEditor)Mockito.verify((Object)this.groupDateEditor)).init((ColumnGroup)Mockito.any(ColumnGroup.class));
    }

    @Test
    public void testGroupAllowed() {
        this.presenter.init(DATA_MULTIPLE, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).column("year")).column(POPULATION_UUID)).buildLookup());
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setGroupEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).enableGroupColumnSelectorHint();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setAddColumnOptionEnabled(true);
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire(Mockito.any(DataSetLookupChangedEvent.class));
    }

    @Test
    public void testDeleteColumns() {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).column("year")).column(POPULATION_UUID)).buildLookup();
        GroupFunction year = lookup.getLastGroupOp().getGroupFunction("year");
        this.presenter.init(DATA_MULTIPLE, lookup);
        Mockito.reset((Object[])new DataSetLookupEditor.View[]{this.view});
        this.presenter.onColumnFunctionDeleted(new GroupFunctionDeletedEvent(year));
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).clearColumnList();
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addColumnEditor((ColumnFunctionEditor)Mockito.any(ColumnFunctionEditor.class));
        ((Event)Mockito.verify(this.event)).fire(Mockito.any(DataSetLookupChangedEvent.class));
    }

    @Test
    public void testGroupNotAllowed() {
        this.presenter.init(DATA_MULTIPLE_NO_GROUP, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).column("year")).column(POPULATION_UUID)).buildLookup());
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setGroupEnabled(true);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).enableGroupColumnSelectorHint();
        ((Event)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire(Mockito.any(DataSetLookupChangedEvent.class));
    }

    @Test
    public void testAutoCreateRequiredGroup() {
        this.presenter.init(DATA_2D_FIXED, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).filter(new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100))})).column("country")).column(POPULATION_UUID, AggregateFunctionType.SUM)).buildLookup());
        Assert.assertEquals((Object)this.presenter.getFirstGroupColumnId(), (Object)"continent");
        ((Event)Mockito.verify(this.event)).fire(Mockito.any(DataSetLookupChangedEvent.class));
    }

    @Test
    public void testDataSetSelected() {
        this.presenter.init(DATA_2D_FIXED, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).group("country")).column("country")).column(POPULATION_UUID, AggregateFunctionType.SUM)).buildLookup());
        Mockito.when((Object)this.view.getSelectedDataSetId()).thenReturn((Object)REVENUE_UUID);
        this.presenter.onDataSetSelected();
        ((Event)Mockito.verify(this.event)).fire(Mockito.any(DataSetLookupChangedEvent.class));
        DataSetLookup newLookup = this.presenter.getDataSetLookup();
        Assert.assertEquals((Object)newLookup.getDataSetUUID(), (Object)REVENUE_UUID);
        Assert.assertEquals((Object)this.presenter.getFirstGroupColumnId(), (Object)"company");
        Assert.assertEquals((long)this.presenter.getFirstGroupFunctions().size(), (long)2L);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(0)).getSourceId(), (Object)"company");
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(1)).getSourceId(), (Object)REVENUE_UUID);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(0)).getFunction(), null);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(1)).getFunction(), (Object)AggregateFunctionType.SUM);
    }

    @Test
    public void testGroupColumnSelected() {
        this.presenter.init(DATA_2D_FIXED, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).group("country")).column("country")).column(POPULATION_UUID, AggregateFunctionType.SUM)).buildLookup());
        Mockito.when((Object)this.view.getSelectedGroupColumnId()).thenReturn((Object)"continent");
        this.presenter.onGroupColumnSelected();
        ((Event)Mockito.verify(this.event)).fire(Mockito.any(DataSetLookupChangedEvent.class));
        Assert.assertEquals((Object)this.presenter.getFirstGroupColumnId(), (Object)"continent");
        Assert.assertEquals((long)this.presenter.getFirstGroupFunctions().size(), (long)2L);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(0)).getSourceId(), (Object)"continent");
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(1)).getSourceId(), (Object)POPULATION_UUID);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(0)).getFunction(), null);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(1)).getFunction(), (Object)AggregateFunctionType.SUM);
    }

    @Test
    public void testGroupColumnDeselected() {
        this.presenter.init(DATA_MULTIPLE, ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset(POPULATION_UUID)).group("country")).column("country")).column(POPULATION_UUID, AggregateFunctionType.SUM)).buildLookup());
        Mockito.when((Object)this.view.getSelectedGroupColumnId()).thenReturn(null);
        this.presenter.onGroupColumnSelected();
        ((Event)Mockito.verify(this.event)).fire(Mockito.any(DataSetLookupChangedEvent.class));
        Assert.assertEquals((Object)this.presenter.getFirstGroupColumnId(), null);
        Assert.assertEquals((long)this.presenter.getFirstGroupFunctions().size(), (long)2L);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(0)).getSourceId(), (Object)"country");
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(1)).getSourceId(), (Object)POPULATION_UUID);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(0)).getFunction(), null);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(1)).getFunction(), null);
    }

    @Test
    public void testAddColumns() {
        DataSetLookup lookup = DATA_2D_MULTIPLE.newDataSetLookup(POPULATION_META);
        this.presenter.init(DATA_2D_MULTIPLE, lookup);
        ((DataSetLookupEditor.View)Mockito.verify((Object)this.view)).setAddColumnOptionEnabled(true);
        this.presenter.onAddColumn();
        ((Event)Mockito.verify(this.event)).fire(Mockito.any(DataSetLookupChangedEvent.class));
        Assert.assertEquals((long)this.presenter.getFirstGroupFunctions().size(), (long)3L);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(2)).getSourceId(), (Object)POPULATION_UUID);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(2)).getColumnId(), (Object)"population_2");
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(2)).getFunction(), (Object)AggregateFunctionType.SUM);
        this.presenter.onAddColumn();
        Assert.assertEquals((long)this.presenter.getFirstGroupFunctions().size(), (long)4L);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(3)).getSourceId(), (Object)POPULATION_UUID);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(3)).getColumnId(), (Object)"population_3");
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(3)).getFunction(), (Object)AggregateFunctionType.SUM);
        Mockito.reset((Object[])new Event[]{this.event});
        GroupFunction gf = new GroupFunction(POPULATION_UUID, "population_2", AggregateFunctionType.SUM);
        this.presenter.onColumnFunctionDeleted(new GroupFunctionDeletedEvent(gf));
        ((Event)Mockito.verify(this.event)).fire(Mockito.any(DataSetLookupChangedEvent.class));
        Assert.assertEquals((long)this.presenter.getFirstGroupFunctions().size(), (long)3L);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(2)).getSourceId(), (Object)POPULATION_UUID);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(2)).getColumnId(), (Object)"population_3");
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(2)).getFunction(), (Object)AggregateFunctionType.SUM);
        this.presenter.onAddColumn();
        Assert.assertEquals((long)this.presenter.getFirstGroupFunctions().size(), (long)4L);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(3)).getSourceId(), (Object)POPULATION_UUID);
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(3)).getColumnId(), (Object)"population_2");
        Assert.assertEquals((Object)((GroupFunction)this.presenter.getFirstGroupFunctions().get(3)).getFunction(), (Object)AggregateFunctionType.SUM);
    }

    @Test
    public void testColumnChanged() {
        DataSetLookup lookup = DATA_2D_MULTIPLE.newDataSetLookup(POPULATION_META);
        this.presenter.init(DATA_2D_MULTIPLE, lookup);
        GroupFunction gf = new GroupFunction(POPULATION_UUID, POPULATION_UUID, AggregateFunctionType.SUM);
        this.presenter.onColumnFunctionChanged(new GroupFunctionChangedEvent(gf));
        Assert.assertEquals((Object)gf.getColumnId(), (Object)"population_2");
    }
}

