/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.sourcecode;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dashbuilder.displayer.client.widgets.sourcecode.DefaultJsValidator;
import org.dashbuilder.displayer.client.widgets.sourcecode.JsEvaluator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class JsValidatorTest {
    @Mock
    JsEvaluator jsEvaluator;
    DefaultJsValidator validator;

    @Before
    public void setUp() {
        this.validator = new DefaultJsValidator(this.jsEvaluator);
    }

    @Test
    public void testNoError() {
        String error = this.validator.validate("var a=1; var b = 42+a; alert(b);", null);
        Assert.assertNull((Object)error);
    }

    @Test
    public void testNotAllowed_document() {
        String error = this.validator.validate("document.getElementById(\"\");", null);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void testNotAllowed_window() {
        String error = this.validator.validate("window.location=\"\"", null);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void testNotAllowed_eval() {
        String error = this.validator.validate("eval(\"\");", null);
        Assert.assertNotNull((Object)error);
        error = this.validator.validate("eval\n(\"\");", null);
        Assert.assertNotNull((Object)error);
        error = this.validator.validate("eval     (\"\");", null);
        Assert.assertNotNull((Object)error);
        error = this.validator.validate("eval\t(\"\");", null);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void testNotAllowed_innerHtml() {
        String error = this.validator.validate("this.innerHtml=\"\"", null);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void testVariableReplacement() throws Exception {
        String error = this.validator.validate("${this}.style.cursor=\"pointer\";", null);
        String js = "function __alert(msg) {};\nvar __var0__ = document.createElement(\"div\");\n__var0__.style.cursor=\"pointer\";";
        ((JsEvaluator)Mockito.verify((Object)this.jsEvaluator)).evaluate(js);
        Assert.assertNull((Object)error);
        ((JsEvaluator)Mockito.doThrow((Throwable)new Exception("error __var0__")).when((Object)this.jsEvaluator)).evaluate(Mockito.anyString());
        error = this.validator.validate("${this}.style.cursor=\"pointer\";", null);
        Assert.assertEquals((Object)error, (Object)"error ${this}");
    }

    @Test
    public void testAllowedVariables() throws Exception {
        List<String> vars = Arrays.asList("${this}");
        String error = this.validator.validate("${this}.style.cursor=\"pointer\";", vars);
        Assert.assertNull((Object)error);
        vars = new ArrayList<String>();
        error = this.validator.validate("${this}.style.cursor=\"pointer\";", vars);
        Assert.assertNotNull((Object)error);
    }

    @Test
    public void testOcurrences() throws Exception {
        Assert.assertEquals((long)this.validator.occurrences("", "{"), (long)0L);
        Assert.assertEquals((long)this.validator.occurrences("{", "{"), (long)1L);
        Assert.assertEquals((long)this.validator.occurrences("{", "}"), (long)0L);
        Assert.assertEquals((long)this.validator.occurrences("{}", "}"), (long)1L);
        Assert.assertEquals((long)this.validator.occurrences("{}", "{"), (long)1L);
        Assert.assertEquals((long)this.validator.occurrences("{{}}", "{"), (long)2L);
    }

    @Test
    public void testIsolateLines() throws Exception {
        String js = "if (a) b;\nelse c;";
        String isolated = this.validator.isolateLines(js);
        Assert.assertEquals((Object)isolated, (Object)"if (a) b;\nc;\n");
        js = "   ";
        isolated = this.validator.isolateLines(js);
        Assert.assertEquals((long)isolated.length(), (long)0L);
        js = "if (a) {\nb;\n} else c;";
        isolated = this.validator.isolateLines(js);
        Assert.assertEquals((Object)isolated, (Object)"if (a) {}\nb;\n{} c;\n");
        js = "if (a) {\nb; }\nelse c;";
        isolated = this.validator.isolateLines(js);
        Assert.assertEquals((Object)isolated, (Object)"if (a) {}\nb; \nc;\n");
        js = "if (a)\n{ b;\n} else c;";
        isolated = this.validator.isolateLines(js);
        Assert.assertEquals((Object)isolated, (Object)"if (a)\n b;\n{} c;\n");
        js = "if (a) { b; } else c;";
        isolated = this.validator.isolateLines(js);
        Assert.assertEquals((Object)isolated, (Object)"if (a) { b; } c;\n");
        js = "if (a) { if (b) {}}";
        isolated = this.validator.isolateLines(js);
        Assert.assertEquals((Object)isolated, (Object)"if (a) { if (b) {}}\n");
        js = "if (a) {\nif (b) {\n}\n}";
        isolated = this.validator.isolateLines(js);
        Assert.assertEquals((Object)isolated, (Object)"if (a) {}\nif (b) {}\n");
    }
}

